/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.hotrod.configuration.BooleanElementConfiguration;
import org.infinispan.server.hotrod.configuration.SaslConfigurationBuilder;

public class BooleanElementConfigurationBuilder
implements Builder<BooleanElementConfiguration> {
    private final AttributeSet attributes;
    private final String elementName;
    private final SaslConfigurationBuilder sasl;
    private final String saslProperty;

    BooleanElementConfigurationBuilder(String elementName, SaslConfigurationBuilder sasl, String saslProperty) {
        this.elementName = elementName;
        this.sasl = sasl;
        this.saslProperty = saslProperty;
        this.attributes = BooleanElementConfiguration.attributeDefinitionSet();
    }

    public BooleanElementConfigurationBuilder value(boolean value) {
        this.attributes.attribute(BooleanElementConfiguration.VALUE).set((Object)value);
        this.sasl.addMechProperty(this.saslProperty, String.valueOf(value));
        return this;
    }

    public Boolean value() {
        return (Boolean)this.attributes.attribute(BooleanElementConfiguration.VALUE).get();
    }

    public void validate() {
    }

    public BooleanElementConfiguration create() {
        return new BooleanElementConfiguration(this.attributes.protect(), this.elementName);
    }

    public BooleanElementConfigurationBuilder read(BooleanElementConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

