/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.ClientListenerRegistry;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.iteration.IterationState;
import org.infinispan.server.hotrod.logging.Log;

class CacheRequestProcessor
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(CacheRequestProcessor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ClientListenerRegistry listenerRegistry;

    CacheRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor, server);
        this.listenerRegistry = server.getClientListenerRegistry();
    }

    void ping(HotRodHeader header, Subject subject) {
        if (!header.cacheName.isEmpty()) {
            this.server.cache(this.server.getCacheInfo(header), header, subject);
        }
        this.writeResponse(header, header.encoder().pingResponse(header, this.server, this.channel, OperationStatus.Success));
    }

    void stats(HotRodHeader header, Subject subject) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        this.executor.execute(() -> this.writeResponse(header, header.encoder().statsResponse(header, this.server, this.channel, cache.getStats(), this.server.getTransport(), SecurityActions.getCacheComponentRegistry(cache))));
    }

    void get(HotRodHeader header, Subject subject, byte[] key) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.getInternal(header, cache, key);
    }

    private void getInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key) {
        CompletableFuture get = cache.getCacheEntryAsync((Object)key);
        if (get.isDone() && !get.isCompletedExceptionally()) {
            this.handleGet(header, (CacheEntry<byte[], byte[]>)((CacheEntry)get.join()), null);
        } else {
            get.whenComplete((result, throwable) -> this.handleGet(header, (CacheEntry<byte[], byte[]>)result, (Throwable)throwable));
        }
    }

    private void handleGet(HotRodHeader header, CacheEntry<byte[], byte[]> result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (result == null) {
            this.writeNotExist(header);
        } else {
            try {
                switch (header.op) {
                    case GET: {
                        this.writeResponse(header, header.encoder().valueResponse(header, this.server, this.channel, OperationStatus.Success, (byte[])result.getValue()));
                        break;
                    }
                    case GET_WITH_VERSION: {
                        NumericVersion numericVersion = (NumericVersion)result.getMetadata().version();
                        long version = numericVersion != null ? numericVersion.getVersion() : 0L;
                        this.writeResponse(header, header.encoder().valueWithVersionResponse(header, this.server, this.channel, (byte[])result.getValue(), version));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (Throwable t2) {
                this.writeException(header, t2);
            }
        }
    }

    void getWithMetadata(HotRodHeader header, Subject subject, byte[] key, int offset) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.getWithMetadataInternal(header, cache, key, offset);
    }

    private void getWithMetadataInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, int offset) {
        CompletableFuture get = cache.getCacheEntryAsync((Object)key);
        if (get.isDone() && !get.isCompletedExceptionally()) {
            this.handleGetWithMetadata(header, offset, (CacheEntry<byte[], byte[]>)((CacheEntry)get.join()), null);
        } else {
            get.whenComplete((ce, throwable) -> this.handleGetWithMetadata(header, offset, (CacheEntry<byte[], byte[]>)ce, (Throwable)throwable));
        }
    }

    private void handleGetWithMetadata(HotRodHeader header, int offset, CacheEntry<byte[], byte[]> entry, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
            return;
        }
        if (entry == null) {
            this.writeNotExist(header);
        } else if (header.op == HotRodOperation.GET_WITH_METADATA) {
            assert (offset == 0);
            this.writeResponse(header, header.encoder().getWithMetadataResponse(header, this.server, this.channel, entry));
        } else {
            if (entry == null) {
                offset = 0;
            }
            this.writeResponse(header, header.encoder().getStreamResponse(header, this.server, this.channel, offset, entry));
        }
    }

    void containsKey(HotRodHeader header, Subject subject, byte[] key) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.containsKeyInternal(header, cache, key);
    }

    private void containsKeyInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key) {
        CompletableFuture contains = cache.containsKeyAsync((Object)key);
        if (contains.isDone() && !contains.isCompletedExceptionally()) {
            this.handleContainsKey(header, (Boolean)contains.join(), null);
        } else {
            contains.whenComplete((result, throwable) -> this.handleContainsKey(header, (Boolean)result, (Throwable)throwable));
        }
    }

    private void handleContainsKey(HotRodHeader header, Boolean result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (result.booleanValue()) {
            this.writeSuccess(header);
        } else {
            this.writeNotExist(header);
        }
    }

    void put(HotRodHeader header, Subject subject, byte[] key, byte[] value, Metadata.Builder metadata) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        metadata.version((EntryVersion)cacheInfo.versionGenerator.generateNew());
        this.putInternal(header, cache, key, value, metadata.build());
    }

    private void putInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, byte[] value, Metadata metadata) {
        cache.putAsync((Object)key, (Object)value, metadata).whenComplete((result, throwable) -> this.handlePut(header, (byte[])result, (Throwable)throwable));
    }

    private void handlePut(HotRodHeader header, byte[] result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            this.writeSuccess(header, result);
        }
    }

    void replaceIfUnmodified(HotRodHeader header, Subject subject, byte[] key, long version, byte[] value, Metadata.Builder metadata) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        metadata.version((EntryVersion)cacheInfo.versionGenerator.generateNew());
        this.replaceIfUnmodifiedInternal(header, cache, key, version, value, metadata.build());
    }

    private void replaceIfUnmodifiedInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, long version, byte[] value, Metadata metadata) {
        cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getCacheEntryAsync((Object)key).whenComplete((entry, throwable) -> this.handleGetForReplaceIfUnmodified(header, cache, (CacheEntry<byte[], byte[]>)entry, version, value, metadata, (Throwable)throwable));
    }

    private void handleGetForReplaceIfUnmodified(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, CacheEntry<byte[], byte[]> entry, long version, byte[] value, Metadata metadata, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(version);
            if (entry.getMetadata().version().equals(streamVersion)) {
                cache.replaceAsync((Object)((byte[])entry.getKey()), (Object)prev, (Object)value, metadata).whenComplete((replaced, throwable2) -> {
                    if (throwable2 != null) {
                        this.writeException(header, (Throwable)throwable2);
                    } else if (replaced.booleanValue()) {
                        this.writeSuccess(header, prev);
                    } else {
                        this.writeNotExecuted(header, prev);
                    }
                });
            } else {
                this.writeNotExecuted(header, prev);
            }
        } else {
            this.writeNotExist(header);
        }
    }

    void replace(HotRodHeader header, Subject subject, byte[] key, byte[] value, Metadata.Builder metadata) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        metadata.version((EntryVersion)cacheInfo.versionGenerator.generateNew());
        this.replaceInternal(header, cache, key, value, metadata.build());
    }

    private void replaceInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, byte[] value, Metadata metadata) {
        cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getAsync((Object)key).whenComplete((prev, throwable) -> this.handleGetForReplace(header, cache, key, (byte[])prev, value, metadata, (Throwable)throwable));
    }

    private void handleGetForReplace(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, byte[] prev, byte[] value, Metadata metadata, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (prev != null) {
            cache.replaceAsync((Object)key, (Object)value, metadata).whenComplete((result, throwable1) -> this.handleReplace(header, (byte[])result, (Throwable)throwable1));
        } else {
            this.writeNotExecuted(header);
        }
    }

    private void handleReplace(HotRodHeader header, byte[] result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (result != null) {
            this.writeSuccess(header, result);
        } else {
            this.writeNotExecuted(header);
        }
    }

    void putIfAbsent(HotRodHeader header, Subject subject, byte[] key, byte[] value, Metadata.Builder metadata) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        metadata.version((EntryVersion)cacheInfo.versionGenerator.generateNew());
        this.putIfAbsentInternal(header, cache, key, value, metadata.build());
    }

    private void putIfAbsentInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, byte[] value, Metadata metadata) {
        cache.getAsync((Object)key).whenComplete((prev, throwable) -> this.handleGetForPutIfAbsent(header, cache, key, (byte[])prev, value, metadata, (Throwable)throwable));
    }

    private void handleGetForPutIfAbsent(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, byte[] prev, byte[] value, Metadata metadata, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (prev == null) {
            cache.putIfAbsentAsync((Object)key, (Object)value, metadata).whenComplete((result, throwable1) -> this.handlePutIfAbsent(header, (byte[])result, (Throwable)throwable1));
        } else {
            this.writeNotExecuted(header, prev);
        }
    }

    private void handlePutIfAbsent(HotRodHeader header, byte[] result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (result == null) {
            this.writeSuccess(header);
        } else {
            this.writeNotExecuted(header, result);
        }
    }

    void remove(HotRodHeader header, Subject subject, byte[] key) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.removeInternal(header, cache, key);
    }

    private void removeInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key) {
        cache.removeAsync((Object)key).whenComplete((prev, throwable) -> this.handleRemove(header, (byte[])prev, (Throwable)throwable));
    }

    private void handleRemove(HotRodHeader header, byte[] prev, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (prev != null) {
            this.writeSuccess(header, prev);
        } else {
            this.writeNotExist(header);
        }
    }

    void removeIfUnmodified(HotRodHeader header, Subject subject, byte[] key, long version) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.removeIfUnmodifiedInternal(header, cache, key, version);
    }

    private void removeIfUnmodifiedInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] key, long version) {
        cache.getCacheEntryAsync((Object)key).whenComplete((entry, throwable) -> this.handleGetForRemoveIfUnmodified(header, cache, (CacheEntry<byte[], byte[]>)entry, key, version, (Throwable)throwable));
    }

    private void handleGetForRemoveIfUnmodified(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, CacheEntry<byte[], byte[]> entry, byte[] key, long version, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(version);
            if (entry.getMetadata().version().equals(streamVersion)) {
                cache.removeAsync((Object)key, (Object)prev).whenComplete((removed, throwable2) -> {
                    if (throwable2 != null) {
                        this.writeException(header, (Throwable)throwable2);
                    } else if (removed.booleanValue()) {
                        this.writeSuccess(header, prev);
                    } else {
                        this.writeNotExecuted(header, prev);
                    }
                });
            } else {
                this.writeNotExecuted(header, prev);
            }
        } else {
            this.writeNotExist(header);
        }
    }

    void clear(HotRodHeader header, Subject subject) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.clearInternal(header, cache);
    }

    private void clearInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache) {
        cache.clearAsync().whenComplete((nil, throwable) -> {
            if (throwable != null) {
                this.writeException(header, (Throwable)throwable);
            } else {
                this.writeSuccess(header);
            }
        });
    }

    void putAll(HotRodHeader header, Subject subject, Map<byte[], byte[]> entries, Metadata.Builder metadata) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.putAllInternal(header, cache, entries, metadata.build());
    }

    private void putAllInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, Map<byte[], byte[]> entries, Metadata metadata) {
        cache.putAllAsync(entries, metadata).whenComplete((nil, throwable) -> this.handlePutAll(header, (Throwable)throwable));
    }

    private void handlePutAll(HotRodHeader header, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            this.writeSuccess(header);
        }
    }

    void getAll(HotRodHeader header, Subject subject, Set<?> keys) {
        HotRodServer.CacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.getAllInternal(header, cache, keys);
    }

    private void getAllInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, Set<?> keys) {
        cache.getAllAsync(keys).whenComplete((map, throwable) -> this.handleGetAll(header, (Map<byte[], byte[]>)map, (Throwable)throwable));
    }

    private void handleGetAll(HotRodHeader header, Map<byte[], byte[]> map, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().getAllResponse(header, this.server, this.channel, map));
        }
    }

    void size(HotRodHeader header, Subject subject) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        this.sizeInternal(header, cache);
    }

    private void sizeInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache) {
        cache.sizeAsync().whenComplete((size, throwable) -> this.handleSize(header, (Long)size, (Throwable)throwable));
    }

    private void handleSize(HotRodHeader header, Long size, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().unsignedLongResponse(header, this.server, this.channel, size));
        }
    }

    void bulkGet(HotRodHeader header, Subject subject, int size) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        this.executor.execute(() -> this.bulkGetInternal(header, cache, size));
    }

    private void bulkGetInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, int size) {
        try {
            if (trace) {
                log.tracef("About to create bulk response count = %d", size);
            }
            this.writeResponse(header, header.encoder().bulkGetResponse(header, this.server, this.channel, size, (CacheSet<Map.Entry<byte[], byte[]>>)cache.entrySet()));
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void bulkGetKeys(HotRodHeader header, Subject subject, int scope) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        this.executor.execute(() -> this.bulkGetKeysInternal(header, cache, scope));
    }

    private void bulkGetKeysInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, int scope) {
        try {
            if (trace) {
                log.tracef("About to create bulk get keys response scope = %d", scope);
            }
            this.writeResponse(header, header.encoder().bulkGetKeysResponse(header, this.server, this.channel, (CloseableIterator<byte[]>)cache.keySet().iterator()));
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void query(HotRodHeader header, Subject subject, byte[] queryBytes) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        this.executor.execute(() -> this.queryInternal(header, cache, queryBytes));
    }

    private void queryInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] queryBytes) {
        try {
            byte[] queryResult = this.server.query(cache, queryBytes);
            this.writeResponse(header, header.encoder().valueResponse(header, this.server, this.channel, OperationStatus.Success, queryResult));
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void addClientListener(HotRodHeader header, Subject subject, byte[] listenerId, boolean includeCurrentState, String filterFactory, List<byte[]> filterParams, String converterFactory, List<byte[]> converterParams, boolean useRawData, int listenerInterests) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        CompletionStage<Void> stage = this.listenerRegistry.addClientListener(this.channel, header, listenerId, cache, includeCurrentState, filterFactory, filterParams, converterFactory, converterParams, useRawData, listenerInterests);
        stage.whenComplete((ignore, cause) -> {
            if (cause != null) {
                log.trace("Failed to add listener", (Throwable)cause);
                if (cause instanceof CompletionException) {
                    this.writeException(header, cause.getCause());
                } else {
                    this.writeException(header, (Throwable)cause);
                }
            } else {
                this.writeSuccess(header);
            }
        });
    }

    void removeClientListener(HotRodHeader header, Subject subject, byte[] listenerId) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        this.removeClientListenerInternal(header, cache, listenerId);
    }

    private void removeClientListenerInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, byte[] listenerId) {
        this.server.getClientListenerRegistry().removeClientListener(listenerId, (Cache)cache).whenComplete((success, t) -> {
            if (t != null) {
                this.writeException(header, (Throwable)t);
            } else if (success == Boolean.TRUE) {
                this.writeSuccess(header);
            } else {
                this.writeNotExecuted(header);
            }
        });
    }

    void iterationStart(HotRodHeader header, Subject subject, byte[] segmentMask, String filterConverterFactory, List<byte[]> filterConverterParams, int batch, boolean includeMetadata) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        this.executor.execute(() -> {
            try {
                IterationState iterationState = this.server.getIterationManager().start((Cache)cache, segmentMask != null ? BitSet.valueOf(segmentMask) : null, filterConverterFactory, filterConverterParams, header.getValueMediaType(), batch, includeMetadata);
                iterationState.getReaper().registerChannel(this.channel);
                this.writeResponse(header, header.encoder().iterationStartResponse(header, this.server, this.channel, iterationState.getId()));
            }
            catch (Throwable t) {
                this.writeException(header, t);
            }
        });
    }

    void iterationNext(HotRodHeader header, Subject subject, String iterationId) {
        this.executor.execute(() -> {
            try {
                IterableIterationResult iterationResult = this.server.getIterationManager().next(iterationId);
                this.writeResponse(header, header.encoder().iterationNextResponse(header, this.server, this.channel, iterationResult));
            }
            catch (Throwable t) {
                this.writeException(header, t);
            }
        });
    }

    void iterationEnd(HotRodHeader header, Subject subject, String iterationId) {
        this.executor.execute(() -> {
            try {
                IterationState removed = this.server.getIterationManager().close(iterationId);
                this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, removed != null ? OperationStatus.Success : OperationStatus.InvalidIteration));
            }
            catch (Throwable t) {
                this.writeException(header, t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putStream(HotRodHeader header, Subject subject, byte[] key, ByteBuf buf, long version, Metadata.Builder metadata) {
        try {
            byte[] value = new byte[buf.readableBytes()];
            buf.readBytes(value);
            if (version == 0L) {
                this.put(header, subject, key, value, metadata);
            } else if (version < 0L) {
                this.putIfAbsent(header, subject, key, value, metadata);
            } else {
                this.replaceIfUnmodified(header, subject, key, version, value, metadata);
            }
        }
        finally {
            buf.release();
        }
    }

    EmbeddedCacheManager getCacheManager() {
        return this.server.getCacheManager();
    }
}

