/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.server.core.AbstractMarshallingTest;
import org.infinispan.util.ByteString;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodMarshallingTest")
public class HotRodMarshallingTest
extends AbstractMarshallingTest {
    public void testMarshallingBigByteArrayKey() throws Exception {
        byte[] cacheKey = this.getBigByteArray();
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)cacheKey);
        byte[] readKey = (byte[])this.marshaller.objectFromByteBuffer(bytes);
        AssertJUnit.assertEquals((byte[])readKey, (byte[])cacheKey);
    }

    public void testMarshallingCommandWithBigByteArrayKey() throws Exception {
        byte[] cacheKey = this.getBigByteArray();
        ClusteredGetCommand command = new ClusteredGetCommand((Object)new WrappedByteArray(cacheKey), ByteString.fromString((String)"c"), Integer.valueOf(0), 0L);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)command);
        ClusteredGetCommand readCommand = (ClusteredGetCommand)this.marshaller.objectFromByteBuffer(bytes);
        AssertJUnit.assertEquals((Object)readCommand, (Object)command);
    }
}

