/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;

public abstract class HotRodMultiNodeTest
extends MultipleCacheManagersTest {
    private List<HotRodServer> hotRodServers = new ArrayList<HotRodServer>();
    private List<HotRodClient> hotRodClients = new ArrayList<HotRodClient>();

    protected void createCacheManagers() {
        for (int i = 0; i < this.nodeCount(); ++i) {
            EmbeddedCacheManager cm = this.createCacheManager();
            this.cacheManagers.add(cm);
        }
        this.startCaches(this.cacheName());
    }

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    void startCaches(String cacheName) {
        this.cacheManagers.forEach(cm -> cm.createCache(cacheName, this.createCacheConfig().build()));
    }

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        int nextServerPort = HotRodTestingUtil.serverPort();
        for (int i = 0; i < this.nodeCount(); ++i) {
            this.hotRodServers.add(this.startTestHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(i), nextServerPort));
            nextServerPort += 50;
        }
        this.hotRodClients = this.createClients(this.cacheName());
    }

    protected OptionalInt findHighestPort() {
        return this.hotRodServers.stream().mapToInt(AbstractProtocolServer::getPort).max();
    }

    List<HotRodClient> createClients(String cacheName) {
        return this.hotRodServers.stream().map(s -> this.createClient((HotRodServer)s, cacheName)).collect(Collectors.toList());
    }

    protected HotRodClient createClient(HotRodServer server, String cacheName) {
        return this.createClient(server, cacheName, "127.0.0.1");
    }

    protected HotRodClient createClient(HotRodServer server, String cacheName, String address) {
        return new HotRodClient(address, server.getPort(), cacheName, 60, this.protocolVersion());
    }

    protected HotRodServer startTestHotRodServer(EmbeddedCacheManager cacheManager, int port) {
        return HotRodTestingUtil.startHotRodServer(cacheManager, port);
    }

    protected HotRodServer startClusteredServer(int port) {
        HotRodServer newServer;
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManagers.add(cm);
        cm.createCache(this.cacheName(), this.createCacheConfig().build());
        try {
            newServer = HotRodTestingUtil.startHotRodServer(cm, port);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception starting Hot Rod server", (Throwable)e);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm});
            throw e;
        }
        TestingUtil.blockUntilViewsReceived((int)50000, (boolean)true, (Collection)this.cacheManagers);
        return newServer;
    }

    protected void stopClusteredServer(HotRodServer server) {
        ServerTestingUtil.killServer((AbstractProtocolServer)server);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{server.getCacheManager()});
        this.cacheManagers.remove(server.getCacheManager());
        TestingUtil.blockUntilViewsReceived((int)50000, (boolean)false, (Collection)this.cacheManagers);
    }

    public int currentServerTopologyId() {
        return HotRodTestingUtil.getServerTopologyId(this.servers().get(0).getCacheManager(), this.cacheName());
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            this.log.debug((Object)"Test finished, close Hot Rod server");
            this.hotRodClients.forEach(HotRodTestingUtil::killClient);
            this.hotRodServers.forEach(ServerTestingUtil::killServer);
            this.hotRodServers.clear();
        }
        finally {
            super.destroy();
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() {
    }

    protected List<HotRodServer> servers() {
        return this.hotRodServers;
    }

    protected List<HotRodClient> clients() {
        return this.hotRodClients;
    }

    protected abstract String cacheName();

    protected abstract ConfigurationBuilder createCacheConfig();

    protected byte protocolVersion() {
        return 21;
    }

    protected int nodeCount() {
        return 2;
    }
}

