/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.event;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.event.EventLogListener;
import org.infinispan.server.hotrod.event.HotRodClusterEventsSCIImpl;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestClientListener;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.KeyValuePair;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractHotRodClusterEventsTest
extends HotRodMultiNodeTest {
    private ArrayList<AcceptedKeyFilterFactory> filters = new ArrayList();
    private ArrayList<AcceptedKeyValueConverterFactory> converters = new ArrayList();

    @Override
    protected String cacheName() {
        return "remote-clustered-events";
    }

    @Override
    protected int nodeCount() {
        return 3;
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration(AbstractHotRodClusterEventsTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)false));
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createClusteredCacheManager((SerializationContextInitializer)HotRodClusterEventsSCI.INSTANCE, (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    @Override
    protected HotRodServer startTestHotRodServer(EmbeddedCacheManager cacheManager, int port) {
        HotRodServer server = HotRodTestingUtil.startHotRodServer(cacheManager, port);
        this.filters.add(new AcceptedKeyFilterFactory());
        server.addCacheEventFilterFactory("accepted-key-filter-factory", (CacheEventFilterFactory)this.filters.get(0));
        this.converters.add(new AcceptedKeyValueConverterFactory());
        server.addCacheEventConverterFactory("accepted-keyvalue-converter-factory", (CacheEventConverterFactory)this.converters.get(0));
        return server;
    }

    public void testEventForwarding(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        HotRodClient client3 = this.clients().get(2);
        EventLogListener listener1 = new EventLogListener();
        HotRodTestingUtil.withClientListener(client1, listener1, Optional.empty(), Optional.empty(), false, true, () -> {
            byte[] key = HotRodTestingUtil.k(m);
            client2.put(key, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectOnlyCreatedEvent(this.anyCache(), key);
            client3.put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            listener1.expectOnlyModifiedEvent(this.anyCache(), key);
            client2.remove(key);
            listener1.expectOnlyRemovedEvent(this.anyCache(), key);
        });
    }

    public void testNoEventsAfterRemovingListener(Method m) {
        HotRodClient client1 = this.clients().get(0);
        EventLogListener listener1 = new EventLogListener();
        byte[] key = HotRodTestingUtil.k(m);
        HotRodTestingUtil.withClientListener(client1, listener1, Optional.empty(), Optional.empty(), false, true, () -> {
            client1.put(key, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectOnlyCreatedEvent(this.anyCache(), key);
            client1.put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            listener1.expectOnlyModifiedEvent(this.anyCache(), key);
            client1.remove(key);
            listener1.expectOnlyRemovedEvent(this.anyCache(), key);
        });
        client1.put(key, 0, 0, HotRodTestingUtil.v(m));
        listener1.expectNoEvents(Optional.empty());
        client1.remove(key);
        listener1.expectNoEvents(Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoEventsAfterRemovingListenerInDifferentNode(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        EventLogListener listener1 = new EventLogListener();
        byte[] key = HotRodTestingUtil.k(m);
        HotRodTestingUtil.assertStatus(client1.addClientListener(listener1, false, Optional.empty(), Optional.empty(), true), OperationStatus.Success);
        try {
            client1.put(key, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectOnlyCreatedEvent(this.anyCache(), key);
            client1.put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            listener1.expectOnlyModifiedEvent(this.anyCache(), key);
            client1.remove(key);
            listener1.expectOnlyRemovedEvent(this.anyCache(), key);
            client2.removeClientListener(listener1.getId());
            client1.put(key, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectOnlyCreatedEvent(this.anyCache(), key);
            client1.remove(key);
            listener1.expectOnlyRemovedEvent(this.anyCache(), key);
        }
        finally {
            HotRodTestingUtil.assertStatus(client1.removeClientListener(listener1.getId()), OperationStatus.Success);
        }
    }

    public void testClientDisconnectListenerCleanup(Method m) throws InterruptedException {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient newClient = new HotRodClient("127.0.0.1", this.servers().get(1).getPort(), this.cacheName(), 60, this.protocolVersion());
        EventLogListener listener = new EventLogListener();
        HotRodTestingUtil.assertStatus(newClient.addClientListener(listener, false, Optional.empty(), Optional.empty(), true), OperationStatus.Success);
        byte[] key = HotRodTestingUtil.k(m);
        client1.put(key, 0, 0, HotRodTestingUtil.v(m));
        listener.expectOnlyCreatedEvent(this.anyCache(), key);
        newClient.stop().await();
        client1.put(HotRodTestingUtil.k(m, "k2-"), 0, 0, HotRodTestingUtil.v(m));
        listener.expectNoEvents(Optional.empty());
        client1.remove(key);
        client1.remove(HotRodTestingUtil.k(m, "k2-"));
    }

    public void testFailoverSendsEventsForNewContent(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        HotRodClient client3 = this.clients().get(2);
        EventLogListener listener1 = new EventLogListener();
        EventLogListener listener2 = new EventLogListener();
        HotRodTestingUtil.withClientListener(client1, listener1, Optional.empty(), Optional.empty(), false, true, () -> {
            HotRodServer newServer;
            byte[] key;
            block3: {
                key = HotRodTestingUtil.k(m);
                client2.put(key, 0, 0, HotRodTestingUtil.v(m));
                listener1.expectOnlyCreatedEvent(this.anyCache(), key);
                client2.remove(key);
                listener1.expectOnlyRemovedEvent(this.anyCache(), key);
                newServer = this.startClusteredServer(this.servers().get(2).getPort() + 50);
                HotRodClient client4 = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion());
                try {
                    HotRodTestingUtil.withClientListener(client4, listener2, Optional.empty(), Optional.empty(), false, true, () -> {
                        byte[] newKey = HotRodTestingUtil.k(m, "k2-");
                        client3.put(newKey, 0, 0, HotRodTestingUtil.v(m));
                        listener1.expectOnlyCreatedEvent(this.anyCache(), newKey);
                        listener2.expectOnlyCreatedEvent(this.anyCache(), newKey);
                        client1.put(newKey, 0, 0, HotRodTestingUtil.v(m, "v2-"));
                        listener1.expectOnlyModifiedEvent(this.anyCache(), newKey);
                        listener2.expectOnlyModifiedEvent(this.anyCache(), newKey);
                        client4.remove(newKey);
                        listener1.expectOnlyRemovedEvent(this.anyCache(), newKey);
                        listener2.expectOnlyRemovedEvent(this.anyCache(), newKey);
                    });
                    if (client4 == null) break block3;
                    client4.stop();
                }
                catch (Throwable throwable) {
                    if (client4 != null) {
                        client4.stop();
                    }
                    this.stopClusteredServer(newServer);
                    TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName()), this.cache(2, this.cacheName())});
                    throw throwable;
                }
            }
            this.stopClusteredServer(newServer);
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName()), this.cache(2, this.cacheName())});
            client3.put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            listener1.expectOnlyCreatedEvent(this.anyCache(), key);
            listener2.expectNoEvents(Optional.empty());
            client3.put(key, 0, 0, HotRodTestingUtil.v(m, "v3-"));
            listener1.expectOnlyModifiedEvent(this.anyCache(), key);
            listener2.expectNoEvents(Optional.empty());
            client2.remove(key);
            listener1.expectOnlyRemovedEvent(this.anyCache(), key);
            listener2.expectNoEvents(Optional.empty());
        });
    }

    public void testFilteringInCluster(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        EventLogListener listener1 = new EventLogListener();
        Optional<KeyValuePair<String, List<byte[]>>> filterFactory = Optional.of(new KeyValuePair((Object)"accepted-key-filter-factory", Collections.emptyList()));
        byte[] key1 = HotRodTestingUtil.k(m, "k1-");
        this.withClusterClientListener(client1, listener1, filterFactory, Optional.empty(), key1, false, () -> {
            client2.put(HotRodTestingUtil.k(m, "k-99"), 0, 0, HotRodTestingUtil.v(m));
            listener1.expectNoEvents(Optional.empty());
            client2.remove(HotRodTestingUtil.k(m, "k-99"));
            listener1.expectNoEvents(Optional.empty());
            client2.put(key1, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectOnlyCreatedEvent(this.anyCache(), key1);
            client1.remove(key1);
            listener1.expectOnlyRemovedEvent(this.anyCache(), key1);
        });
    }

    public void testParameterBasedFilteringInCluster(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        EventLogListener listener1 = new EventLogListener();
        byte[] dynamicAcceptedKey = new byte[]{4, 5, 6};
        Optional<KeyValuePair<String, List<byte[]>>> filterFactory = Optional.of(new KeyValuePair((Object)"accepted-key-filter-factory", Collections.singletonList(dynamicAcceptedKey)));
        this.withClusterClientListener(client1, listener1, filterFactory, Optional.empty(), null, false, () -> {
            byte[] key1 = HotRodTestingUtil.k(m, "k1-");
            client2.put(HotRodTestingUtil.k(m, "k-99"), 0, 0, HotRodTestingUtil.v(m));
            listener1.expectNoEvents(Optional.empty());
            client2.remove(HotRodTestingUtil.k(m, "k-99"));
            listener1.expectNoEvents(Optional.empty());
            client2.put(key1, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectNoEvents(Optional.empty());
            client2.put(dynamicAcceptedKey, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectOnlyCreatedEvent(this.anyCache(), dynamicAcceptedKey);
            client1.remove(dynamicAcceptedKey);
            listener1.expectOnlyRemovedEvent(this.anyCache(), dynamicAcceptedKey);
        });
    }

    public void testConversionInCluster(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        EventLogListener listener1 = new EventLogListener();
        Optional<KeyValuePair<String, List<byte[]>>> converterFactory = Optional.of(new KeyValuePair((Object)"accepted-keyvalue-converter-factory", Collections.emptyList()));
        byte[] key1 = HotRodTestingUtil.k(m, "k1-");
        this.withClusterClientListener(client1, listener1, Optional.empty(), converterFactory, key1, false, () -> {
            byte[] value = HotRodTestingUtil.v(m);
            byte[] key99 = HotRodTestingUtil.k(m, "k-99");
            client2.put(key99, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(key99));
            client2.put(key1, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(key1, value));
            client2.remove(key99);
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(key99));
            client2.remove(key1);
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(key1));
        });
    }

    public void testParameterBasedConversionInCluster(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        EventLogListener listener1 = new EventLogListener();
        byte[] convertedKey = new byte[]{4, 5, 6};
        Optional<KeyValuePair<String, List<byte[]>>> converteFactory = Optional.of(new KeyValuePair((Object)"accepted-keyvalue-converter-factory", Collections.singletonList(new byte[]{4, 5, 6})));
        this.withClusterClientListener(client1, listener1, Optional.empty(), converteFactory, null, false, () -> {
            byte[] key1 = HotRodTestingUtil.k(m, "k1-");
            byte[] value = HotRodTestingUtil.v(m);
            byte[] key99 = HotRodTestingUtil.k(m, "k-99");
            client2.put(key99, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(key99));
            client2.put(key1, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(key1));
            client2.put(convertedKey, 0, 0, HotRodTestingUtil.v(m));
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(convertedKey, value));
            client1.remove(convertedKey);
            listener1.expectSingleCustomEvent(this.anyCache(), AbstractHotRodClusterEventsTest.addLengthPrefix(convertedKey));
        });
    }

    public void testEventReplayAfterAddingListenerInCluster(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        HotRodClient client3 = this.clients().get(2);
        byte[] k1 = HotRodTestingUtil.k(m, "k1-");
        byte[] v1 = HotRodTestingUtil.v(m, "v1-");
        byte[] k2 = HotRodTestingUtil.k(m, "k2-");
        byte[] v2 = HotRodTestingUtil.v(m, "v2-");
        byte[] k3 = HotRodTestingUtil.k(m, "k3-");
        byte[] v3 = HotRodTestingUtil.v(m, "v3-");
        client1.put(k1, 0, 0, v1);
        client2.put(k2, 0, 0, v2);
        client3.put(k3, 0, 0, v3);
        EventLogListener listener1 = new EventLogListener();
        HotRodTestingUtil.withClientListener(client1, listener1, Optional.empty(), Optional.empty(), true, true, () -> {
            List<byte[]> keys = Arrays.asList(k1, k2, k3);
            listener1.expectUnorderedEvents(this.anyCache(), keys, Event.Type.CACHE_ENTRY_CREATED);
            client1.remove(k1);
            listener1.expectOnlyRemovedEvent(this.anyCache(), k1);
            client2.remove(k2);
            listener1.expectOnlyRemovedEvent(this.anyCache(), k2);
            client3.remove(k3);
            listener1.expectOnlyRemovedEvent(this.anyCache(), k3);
        });
    }

    public void testNoEventReplayAfterAddingListenerInCluster(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        HotRodClient client3 = this.clients().get(2);
        byte[] k1 = HotRodTestingUtil.k(m, "k1-");
        byte[] v1 = HotRodTestingUtil.v(m, "v1-");
        byte[] k2 = HotRodTestingUtil.k(m, "k2-");
        byte[] v2 = HotRodTestingUtil.v(m, "v2-");
        byte[] k3 = HotRodTestingUtil.k(m, "k3-");
        byte[] v3 = HotRodTestingUtil.v(m, "v3-");
        client1.put(k1, 0, 0, v1);
        client2.put(k2, 0, 0, v2);
        client3.put(k3, 0, 0, v3);
        EventLogListener listener1 = new EventLogListener();
        HotRodTestingUtil.withClientListener(client1, listener1, Optional.empty(), Optional.empty(), false, true, () -> {
            listener1.expectNoEvents(Optional.empty());
            client1.remove(k1);
            listener1.expectOnlyRemovedEvent(this.anyCache(), k1);
            client2.remove(k2);
            listener1.expectOnlyRemovedEvent(this.anyCache(), k2);
            client3.remove(k3);
            listener1.expectOnlyRemovedEvent(this.anyCache(), k3);
        });
    }

    private Cache<byte[], byte[]> anyCache() {
        return ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache(this.cacheName()).getAdvancedCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withClusterClientListener(HotRodClient client, TestClientListener listener, Optional<KeyValuePair<String, List<byte[]>>> filterFactory, Optional<KeyValuePair<String, List<byte[]>>> converterFactory, byte[] staticKey, boolean includeState, Runnable fn) {
        this.filters.forEach(factory -> {
            factory.staticKey = staticKey;
        });
        this.converters.forEach(factory -> {
            factory.staticKey = staticKey;
        });
        TestResponse response = client.addClientListener(listener, includeState, filterFactory, converterFactory, true);
        HotRodTestingUtil.assertStatus(response, OperationStatus.Success);
        try {
            fn.run();
        }
        finally {
            HotRodTestingUtil.assertStatus(client.removeClientListener(listener.getId()), OperationStatus.Success);
            this.filters.forEach(factory -> {
                factory.staticKey = null;
            });
            this.converters.forEach(factory -> {
                factory.staticKey = null;
            });
        }
    }

    public static byte[] addLengthPrefix(byte[] key) {
        byte keyLength = (byte)key.length;
        ByteBuffer buffer = ByteBuffer.allocate(keyLength + 1);
        buffer.put(keyLength);
        buffer.put(key);
        return buffer.array();
    }

    public static byte[] addLengthPrefix(byte[] key, byte[] value) {
        byte keyLength = (byte)key.length;
        byte valueLength = (byte)value.length;
        ByteBuffer buffer = ByteBuffer.allocate(keyLength + valueLength + 2);
        buffer.put(keyLength);
        buffer.put(key);
        buffer.put(valueLength);
        buffer.put(value);
        return buffer.array();
    }

    @AutoProtoSchemaBuilder(includeClasses={AcceptedKeyFilterFactory.class, AcceptedKeyValueConverterFactory.class}, schemaFileName="test.hotrod.AbstractHotRodClusterEvents.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.hotord.AbstractHotRodClusterEvents", service=false)
    static interface HotRodClusterEventsSCI
    extends SerializationContextInitializer {
        public static final HotRodClusterEventsSCI INSTANCE = new HotRodClusterEventsSCIImpl();
    }

    static class AcceptedKeyValueConverterFactory
    implements CacheEventConverterFactory,
    Serializable {
        @ProtoField(number=1)
        byte[] staticKey = null;

        AcceptedKeyValueConverterFactory() {
        }

        Optional<byte[]> getStaticKey() {
            return Optional.ofNullable(this.staticKey);
        }

        public <K, V, C> CacheEventConverter<K, V, C> getConverter(Object[] params) {
            return (CacheEventConverter & Serializable)(key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> {
                byte[] checkKey = this.getStaticKey().orElseGet(() -> (byte[])params[0]);
                if (newValue == null || !Arrays.equals(checkKey, key)) {
                    return AbstractHotRodClusterEventsTest.addLengthPrefix(key);
                }
                return AbstractHotRodClusterEventsTest.addLengthPrefix(key, newValue);
            };
        }
    }

    static class AcceptedKeyFilterFactory
    implements CacheEventFilterFactory,
    Serializable {
        @ProtoField(number=1)
        byte[] staticKey = null;

        AcceptedKeyFilterFactory() {
        }

        Optional<byte[]> getStaticKey() {
            return Optional.ofNullable(this.staticKey);
        }

        public <K, V> CacheEventFilter<K, V> getFilter(Object[] params) {
            return (CacheEventFilter & Serializable)(key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> {
                byte[] checkKey = this.getStaticKey().orElseGet(() -> (byte[])params[0]);
                return Arrays.equals(checkKey, (byte[])key);
            };
        }
    }
}

