/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.hotrod.configuration.Attribute;
import org.infinispan.server.hotrod.configuration.SaslConfiguration;

public class AuthenticationConfiguration {
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((Enum)Attribute.SECURITY_REALM, null, String.class).build();
    private final AttributeSet attributes;
    private final boolean enabled;
    private final SaslConfiguration saslConfiguration;
    private final ServerAuthenticationProvider serverAuthenticationProvider;
    private final Subject serverSubject;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{SECURITY_REALM});
    }

    AuthenticationConfiguration(AttributeSet attributes, SaslConfiguration saslConfiguration, boolean enabled, ServerAuthenticationProvider serverAuthenticationProvider, Subject serverSubject) {
        this.attributes = attributes.checkProtection();
        this.saslConfiguration = saslConfiguration;
        this.enabled = enabled;
        this.serverAuthenticationProvider = serverAuthenticationProvider;
        this.serverSubject = serverSubject;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Set<String> allowedMechs() {
        return this.saslConfiguration.mechanisms();
    }

    public ServerAuthenticationProvider serverAuthenticationProvider() {
        return this.serverAuthenticationProvider;
    }

    public Map<String, String> mechProperties() {
        return this.saslConfiguration.mechProperties();
    }

    public String serverName() {
        return this.saslConfiguration.serverName();
    }

    public Subject serverSubject() {
        return this.serverSubject;
    }

    public SaslConfiguration sasl() {
        return this.saslConfiguration;
    }

    public String toString() {
        return "AuthenticationConfiguration{attributes=" + this.attributes + ", enabled=" + this.enabled + ", saslConfiguration=" + (Object)((Object)this.saslConfiguration) + ", serverAuthenticationProvider=" + this.serverAuthenticationProvider + ", serverSubject=" + this.serverSubject + '}';
    }
}

