/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;

@SerializeWith(value=CheckAddressTaskExternalizer.class)
class CheckAddressTask
implements Function<EmbeddedCacheManager, Boolean> {
    private final String cacheName;
    private final Address clusterAddress;

    CheckAddressTask(String cacheName, Address clusterAddress) {
        this.cacheName = cacheName;
        this.clusterAddress = clusterAddress;
    }

    @Override
    public Boolean apply(EmbeddedCacheManager embeddedCacheManager) {
        if (embeddedCacheManager.isRunning(this.cacheName)) {
            Cache cache = embeddedCacheManager.getCache(this.cacheName);
            return cache.containsKey((Object)this.clusterAddress);
        }
        return true;
    }

    public static final class CheckAddressTaskExternalizer
    implements Externalizer<CheckAddressTask> {
        public void writeObject(ObjectOutput output, CheckAddressTask object) throws IOException {
            output.writeUTF(object.cacheName);
            output.writeObject(object.clusterAddress);
        }

        public CheckAddressTask readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CheckAddressTask(input.readUTF(), (Address)input.readObject());
        }
    }
}

