/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.CreateStateFunction;
import org.infinispan.server.hotrod.tx.table.functions.PreparingDecisionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetCompletedTransactionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetDecisionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetPreparedFunction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.ByteString;

public class PrepareCoordinator {
    private final AdvancedCache<?, ?> cache;
    private final XidImpl xid;
    private final PerCacheTxTable perCacheTxTable;
    private final TransactionTable transactionTable;
    private final CacheXid cacheXid;
    private final GlobalTxTable globalTxTable;
    private final long transactionTimeout;
    private EmbeddedTransaction tx;
    private LocalTxInvocationContext localTxInvocationContext;
    private final boolean recoverable;

    public PrepareCoordinator(AdvancedCache<byte[], byte[]> cache, XidImpl xid, boolean recoverable, long transactionTimeout) {
        this.xid = xid;
        this.recoverable = recoverable;
        this.transactionTimeout = transactionTimeout;
        this.cache = cache;
        ComponentRegistry registry = cache.getComponentRegistry();
        this.transactionTable = (TransactionTable)registry.getComponent(TransactionTable.class);
        this.perCacheTxTable = (PerCacheTxTable)registry.getComponent(PerCacheTxTable.class);
        this.globalTxTable = (GlobalTxTable)registry.getGlobalComponentRegistry().getComponent(GlobalTxTable.class);
        this.cacheXid = new CacheXid(ByteString.fromString((String)cache.getName()), xid);
    }

    public final TxState getTxState() {
        return this.globalTxTable.getState(this.cacheXid);
    }

    public final boolean isAlive(Address address) {
        RpcManager rpcManager = this.cache.getRpcManager();
        return rpcManager == null || rpcManager.getMembers().contains(address);
    }

    public final void rollbackRemoteTransaction(GlobalTransaction gtx) {
        RpcManager rpcManager = this.cache.getRpcManager();
        ComponentRegistry componentRegistry = this.cache.getComponentRegistry();
        CommandsFactory factory = componentRegistry.getCommandsFactory();
        try {
            RollbackCommand rollbackCommand = factory.buildRollbackCommand(gtx);
            rollbackCommand.setTopologyId(rpcManager.getTopologyId());
            CompletionStage cs = rpcManager.invokeCommandOnAll((ReplicableCommand)rollbackCommand, (ResponseCollector)VoidResponseCollector.validOnly(), rpcManager.getSyncRpcOptions());
            rollbackCommand.invokeAsync(componentRegistry).toCompletableFuture().join();
            cs.toCompletableFuture().join();
        }
        catch (Throwable throwable) {
            throw Util.rewrapAsCacheException((Throwable)CompletableFutures.extractException((Throwable)throwable));
        }
        finally {
            this.forgetTransaction(gtx, rpcManager, factory);
        }
    }

    public boolean startTransaction() {
        EmbeddedTransaction tx = new EmbeddedTransaction((EmbeddedBaseTransactionManager)EmbeddedTransactionManager.getInstance());
        tx.setXid(this.xid);
        LocalTransaction localTransaction = this.transactionTable.getOrCreateLocalTransaction((Transaction)tx, false, this::newGlobalTransaction);
        GlobalTransaction gtx = localTransaction.getGlobalTransaction();
        if (!this.cache.getCacheConfiguration().transaction().useSynchronization()) {
            gtx.setXid(this.xid);
        }
        if (this.createGlobalState(gtx) != Status.OK) {
            this.transactionTable.removeLocalTransaction(localTransaction);
            return false;
        }
        this.tx = tx;
        this.localTxInvocationContext = new LocalTxInvocationContext(localTransaction);
        this.perCacheTxTable.createLocalTx(this.xid, tx);
        this.transactionTable.enlistClientTransaction((Transaction)tx, localTransaction);
        return true;
    }

    public int rollback() {
        this.loggingDecision(false);
        try {
            this.tx.rollback();
        }
        catch (SystemException systemException) {
        }
        finally {
            this.perCacheTxTable.removeLocalTx(this.xid);
        }
        this.loggingCompleted(false);
        return 100;
    }

    public void setRollbackOnly() {
        this.tx.setRollbackOnly();
    }

    public int prepare(boolean onePhaseCommit) {
        Status status = this.loggingPreparing();
        if (status != Status.OK) {
            return 100;
        }
        boolean prepared = this.tx.runPrepare();
        if (prepared) {
            if (onePhaseCommit) {
                return this.onePhaseCommitTransaction();
            }
            status = this.loggingPrepared();
            return status == Status.OK ? 0 : 100;
        }
        this.loggingCompleted(false);
        this.perCacheTxTable.removeLocalTx(this.xid);
        return 100;
    }

    public <K, V> AdvancedCache<K, V> decorateCache(AdvancedCache<K, V> cache) {
        return cache.transform(this::transform);
    }

    public int onePhaseCommitRemoteTransaction(GlobalTransaction gtx, List<WriteCommand> modifications) {
        RpcManager rpcManager = this.cache.getRpcManager();
        ComponentRegistry componentRegistry = this.cache.getComponentRegistry();
        CommandsFactory factory = componentRegistry.getCommandsFactory();
        try {
            PrepareCommand command = factory.buildPrepareCommand(gtx, modifications, true);
            CompletionStage cs = rpcManager.invokeCommandOnAll((ReplicableCommand)command, (ResponseCollector)VoidResponseCollector.validOnly(), rpcManager.getSyncRpcOptions());
            command.invokeAsync(componentRegistry).toCompletableFuture().join();
            cs.toCompletableFuture().join();
            this.forgetTransaction(gtx, rpcManager, factory);
            return this.loggingCompleted(true) == Status.OK ? 0 : -3;
        }
        catch (Throwable throwable) {
            return -3;
        }
    }

    private void forgetTransaction(GlobalTransaction gtx, RpcManager rpcManager, CommandsFactory factory) {
        TxCompletionNotificationCommand cmd = factory.buildTxCompletionNotificationCommand(this.xid, gtx);
        rpcManager.sendToAll((ReplicableCommand)cmd, DeliverOrder.NONE);
        this.perCacheTxTable.removeLocalTx(this.xid);
        this.globalTxTable.remove(this.cacheXid);
    }

    private Status loggingDecision(boolean commit) {
        SetDecisionFunction function = new SetDecisionFunction(commit);
        return this.globalTxTable.update(this.cacheXid, function, this.transactionTimeout);
    }

    private Status loggingCompleted(boolean committed) {
        SetCompletedTransactionFunction function = new SetCompletedTransactionFunction(committed);
        return this.globalTxTable.update(this.cacheXid, function, this.transactionTimeout);
    }

    private <K, V> AdvancedCache<K, V> transform(AdvancedCache<K, V> cache) {
        if (cache instanceof CacheImpl) {
            return this.withTransaction((CacheImpl)cache);
        }
        return cache;
    }

    private <K, V> AdvancedCache<K, V> withTransaction(CacheImpl<K, V> cache) {
        return new DecoratedCache<K, V>(cache, FlagBitSets.FORCE_WRITE_LOCK){

            protected InvocationContext readContext(int size) {
                return PrepareCoordinator.this.localTxInvocationContext;
            }

            protected InvocationContext writeContext(int size) {
                return PrepareCoordinator.this.localTxInvocationContext;
            }
        };
    }

    private int onePhaseCommitTransaction() {
        if (this.loggingDecision(true) != Status.OK) {
            return -3;
        }
        try {
            this.tx.runCommit(false);
            return this.loggingCompleted(true) == Status.OK ? 0 : -3;
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException e) {
            this.loggingCompleted(false);
            return 100;
        }
    }

    private Status loggingPrepared() {
        SetPreparedFunction function = new SetPreparedFunction();
        return this.globalTxTable.update(this.cacheXid, function, this.transactionTimeout);
    }

    private Status createGlobalState(GlobalTransaction globalTransaction) {
        CreateStateFunction function = new CreateStateFunction(globalTransaction, this.recoverable, this.transactionTimeout);
        return this.globalTxTable.update(this.cacheXid, function, this.transactionTimeout);
    }

    private Status loggingPreparing() {
        PreparingDecisionFunction function = new PreparingDecisionFunction(this.copyModifications());
        return this.globalTxTable.update(this.cacheXid, function, this.transactionTimeout);
    }

    private List<WriteCommand> copyModifications() {
        List modifications = this.getLocalTransaction().getModifications();
        return new ArrayList<WriteCommand>(modifications);
    }

    private LocalTransaction getLocalTransaction() {
        return this.transactionTable.getLocalTransaction((Transaction)this.tx);
    }

    private GlobalTransaction newGlobalTransaction() {
        TransactionFactory factory = (TransactionFactory)this.cache.getComponentRegistry().getComponent(TransactionFactory.class);
        return factory.newGlobalTransaction((Address)this.perCacheTxTable.getClientAddress(), false);
    }
}

