/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import java.io.Serializable;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.hotrod.MissingFactoryException;
import org.infinispan.server.hotrod.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean warnConditionalOperationNonTransactional_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean warnForceReturnPreviousNonTransactional_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean skippingMarshallerWrapping_$Once = new AtomicBoolean(false);

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void exceptionReported(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.exceptionReported$str(), new Object[0]);
    }

    protected String exceptionReported$str() {
        return "ISPN005003: Exception reported";
    }

    @Override
    public final void noMembersInHashTopology(ConsistentHash ch, String topologyMap) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noMembersInHashTopology$str(), (Object)ch, (Object)topologyMap);
    }

    protected String noMembersInHashTopology$str() {
        return "ISPN005019: No members for new topology after applying consistent hash %s filtering into base topology %s";
    }

    @Override
    public final void noMembersInTopology() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noMembersInTopology$str(), new Object[0]);
    }

    protected String noMembersInTopology$str() {
        return "ISPN005020: No members in new topology";
    }

    @Override
    public final void errorDetectingCrashedMember(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorDetectingCrashedMember$str(), new Object[0]);
    }

    protected String errorDetectingCrashedMember$str() {
        return "ISPN006002: Error detecting crashed member";
    }

    protected String invalidOperation$str() {
        return "ISPN006007: The requested operation is invalid";
    }

    @Override
    public final UnsupportedOperationException invalidOperation() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.invalidOperation$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unexpectedEvent$str() {
        return "ISPN006009: Event not handled by current Hot Rod event implementation: '%s'";
    }

    @Override
    public final IllegalStateException unexpectedEvent(Event e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedEvent$str(), e));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void warnConditionalOperationNonTransactional(String op) {
        if (this.log.isEnabled(Logger.Level.WARN) && warnConditionalOperationNonTransactional_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.warnConditionalOperationNonTransactional$str(), (Object)op);
        }
    }

    protected String warnConditionalOperationNonTransactional$str() {
        return "ISPN006010: Conditional operation '%s' should be used with transactional caches, otherwise data inconsistency issues could arise under failure situations";
    }

    @Override
    public final void warnForceReturnPreviousNonTransactional(String op) {
        if (this.log.isEnabled(Logger.Level.WARN) && warnForceReturnPreviousNonTransactional_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.warnForceReturnPreviousNonTransactional$str(), (Object)op);
        }
    }

    protected String warnForceReturnPreviousNonTransactional$str() {
        return "ISPN006011: Operation '%s' forced to return previous value should be used on transactional caches, otherwise data inconsistency issues could arise under failure situations";
    }

    protected String missingCacheEventFactory$str() {
        return "ISPN006013: Listener %s factory '%s' not found in server";
    }

    @Override
    public final MissingFactoryException missingCacheEventFactory(String factoryType, String name) {
        MissingFactoryException result = new MissingFactoryException(String.format(this.getLoggingLocale(), this.missingCacheEventFactory$str(), factoryType, name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalFilterConverterEventFactory$str() {
        return "ISPN006014: Trying to add a filter and converter factory with name '%s' but it does not extend CacheEventFilterConverterFactory";
    }

    @Override
    public final IllegalStateException illegalFilterConverterEventFactory(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalFilterConverterEventFactory$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unauthorizedOperation$str() {
        return "ISPN006017: Operation '%s' requires authentication";
    }

    @Override
    public final SecurityException unauthorizedOperation(String op) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.unauthorizedOperation$str(), op));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingHostAddress$str() {
        return "ISPN006019: A host or proxyHost address has not been specified";
    }

    @Override
    public final CacheConfigurationException missingHostAddress() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingHostAddress$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String expectedTransactionalCache$str() {
        return "ISPN006020: Cache '%s' is not transactional to execute a client transaction";
    }

    @Override
    public final IllegalStateException expectedTransactionalCache(String cacheName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.expectedTransactionalCache$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedIsolationLevel$str() {
        return "ISPN006021: Cache '%s' must have REPEATABLE_READ isolation level";
    }

    @Override
    public final IllegalStateException unexpectedIsolationLevel(String cacheName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedIsolationLevel$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidWeakCounter$str() {
        return "ISPN028023: Expects a STRONG counter for '%s'";
    }

    @Override
    public final CounterException invalidWeakCounter(String name) {
        CounterException result = new CounterException(String.format(this.getLoggingLocale(), this.invalidWeakCounter$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void skippingMarshallerWrapping(String mediaType) {
        if (this.log.isEnabled(Logger.Level.WARN) && skippingMarshallerWrapping_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.skippingMarshallerWrapping$str(), (Object)mediaType);
        }
    }

    protected String skippingMarshallerWrapping$str() {
        return "ISPN028024: Not wrapping custom marshaller with media type '%s' since the format is already supported by the server";
    }

    protected String errorSerializingResponse$str() {
        return "ISPN028025: Error serializing script response '%s'";
    }

    @Override
    public final EncodingException errorSerializingResponse(Object o) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.errorSerializingResponse$str(), o));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String authenticationException$str() {
        return "ISPN028027: Invalid credentials";
    }

    @Override
    public final SecurityException authenticationException(Throwable cause) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.authenticationException$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMech$str() {
        return "ISPN028028: Invalid mech '%s'";
    }

    @Override
    public final IllegalArgumentException invalidMech(String mech) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidMech$str(), mech));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void clientNotUpdatingTopology(SocketAddress socketAddress, int topologyId) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.clientNotUpdatingTopology$str(), (Object)socketAddress, (Object)topologyId);
    }

    protected String clientNotUpdatingTopology$str() {
        return "ISPN028029: Client %s keeps providing outdated topology %s";
    }
}

