/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.group.ChannelMatcher;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.NamedFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.notifications.Listenable;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.annotation.ConfigurationChanged;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ConfigurationChangedEvent;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.CacheInfo;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.server.core.iteration.DefaultIterationManager;
import org.infinispan.server.core.iteration.IterationManager;
import org.infinispan.server.core.transport.FlushConsolidationInitializer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.CacheUnavailableException;
import org.infinispan.server.hotrod.CheckAddressTask;
import org.infinispan.server.hotrod.ClientListenerRegistry;
import org.infinispan.server.hotrod.CrashedMemberDetectorListener;
import org.infinispan.server.hotrod.HotRodDecoder;
import org.infinispan.server.hotrod.HotRodDetector;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.KeyValueVersionConverterFactory;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.counter.listener.ClientCounterManagerNotificationManager;
import org.infinispan.server.hotrod.event.KeyValueWithPreviousEventConverterFactory;
import org.infinispan.server.hotrod.logging.HotRodAccessLogging;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.streaming.StreamingManager;
import org.infinispan.server.hotrod.transport.TimeoutEnabledChannelInitializer;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.BlockingManager;

public class HotRodServer
extends AbstractProtocolServer<HotRodServerConfiguration> {
    static final Log log = (Log)LogFactory.getLog(HotRodServer.class, Log.class);
    private static final long MILLISECONDS_IN_30_DAYS = TimeUnit.DAYS.toMillis(30L);
    public static final int DEFAULT_HOTROD_PORT = 11222;
    public static final int LISTENERS_CHECK_INTERVAL = 10;
    private boolean hasDefaultCache;
    private ServerAddress address;
    private Cache<Address, ServerAddress> addressCache;
    private final Map<String, ExtendedCacheInfo> knownCaches = new ConcurrentHashMap<String, ExtendedCacheInfo>();
    private QueryFacade queryFacade;
    private ClientListenerRegistry clientListenerRegistry;
    private Marshaller marshaller;
    private ClusterExecutor clusterExecutor;
    private CrashedMemberDetectorListener viewChangeListener;
    private ReAddMyAddressListener topologyChangeListener;
    private IterationManager iterationManager;
    private StreamingManager streamingManager;
    private ServerCacheListener serverCacheListener;
    private ClientCounterManagerNotificationManager clientCounterNotificationManager;
    private final HotRodAccessLogging accessLogging = new HotRodAccessLogging();
    private ScheduledExecutorService scheduledExecutor;
    private TimeService timeService;
    private InternalCacheRegistry internalCacheRegistry;
    private ConfigurationManager configurationManager;
    private BlockingManager blockingManager;

    public HotRodServer() {
        super("HotRod");
    }

    public boolean hasDefaultCache() {
        return this.hasDefaultCache;
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        return this.queryFacade.query(cache, query);
    }

    public ClientListenerRegistry getClientListenerRegistry() {
        return this.clientListenerRegistry;
    }

    public ClientCounterManagerNotificationManager getClientCounterNotificationManager() {
        if (this.clientCounterNotificationManager == null) {
            throw new IllegalLifecycleStateException("HotRod server is not fully initialized");
        }
        return this.clientCounterNotificationManager;
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public HotRodDecoder getDecoder() {
        return new HotRodDecoder(this.cacheManager, this.getExecutor(), this);
    }

    public ChannelMatcher getChannelMatcher() {
        return channel -> channel.pipeline().get(HotRodDecoder.class) != null;
    }

    public void installDetector(Channel ch) {
        ch.pipeline().addLast("hotrod-detector", (ChannelHandler)new HotRodDetector(this));
    }

    public boolean isDefaultCacheRunning() {
        return true;
    }

    protected void startInternal() {
        GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cacheManager);
        this.internalCacheRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        this.configurationManager = (ConfigurationManager)gcr.getComponent(ConfigurationManager.class);
        this.blockingManager = (BlockingManager)gcr.getComponent(BlockingManager.class);
        this.iterationManager = new DefaultIterationManager(gcr.getTimeService());
        this.streamingManager = new StreamingManager(gcr.getTimeService());
        this.hasDefaultCache = ((HotRodServerConfiguration)this.configuration).defaultCacheName() != null || this.cacheManager.getCacheManagerConfiguration().defaultCacheName().isPresent();
        this.queryFacade = this.loadQueryFacade();
        this.clientListenerRegistry = new ClientListenerRegistry((EncoderRegistry)gcr.getComponent(EncoderRegistry.class), (Executor)gcr.getComponent(ExecutorService.class, "org.infinispan.executors.non-blocking"));
        this.addKeyValueFilterConverterFactory(ToEmptyBytesKeyValueFilterConverter.class.getName(), (KeyValueFilterConverterFactory)new ToEmptyBytesFactory());
        this.addCacheEventConverterFactory("key-value-with-previous-converter-factory", new KeyValueWithPreviousEventConverterFactory());
        this.addCacheEventConverterFactory("___eager-key-value-version-converter", KeyValueVersionConverterFactory.SINGLETON);
        this.loadFilterConverterFactories(ParamKeyValueFilterConverterFactory.class, this::addKeyValueFilterConverterFactory);
        this.loadFilterConverterFactories(CacheEventFilterConverterFactory.class, this::addCacheEventFilterConverterFactory);
        this.loadFilterConverterFactories(CacheEventConverterFactory.class, this::addCacheEventConverterFactory);
        this.loadFilterConverterFactories(KeyValueFilterConverterFactory.class, this::addKeyValueFilterConverterFactory);
        DefaultThreadFactory factory = new DefaultThreadFactory(this.getQualifiedName() + "-Scheduled");
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)factory);
        this.serverCacheListener = new ServerCacheListener();
        SecurityActions.addListener((EmbeddedCacheManager)this.cacheManager, (Object)this.serverCacheListener);
        super.startInternal();
    }

    public void internalPostStart() {
        super.internalPostStart();
        this.clientCounterNotificationManager = new ClientCounterManagerNotificationManager(EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager));
        if (Configurations.isClustered((GlobalConfiguration)SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)this.cacheManager))) {
            this.defineTopologyCacheConfig(this.cacheManager);
            if (log.isDebugEnabled()) {
                log.debugf("Externally facing address is %s:%d", ((HotRodServerConfiguration)this.configuration).proxyHost(), ((HotRodServerConfiguration)this.configuration).proxyPort());
            }
            this.addSelfToTopologyView(this.cacheManager);
        }
    }

    public ChannelInitializer<Channel> getInitializer() {
        if (((HotRodServerConfiguration)this.configuration).idleTimeout() > 0) {
            return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), this::getDecoder), new FlushConsolidationInitializer(), new TimeoutEnabledChannelInitializer(this)});
        }
        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), this::getDecoder), new FlushConsolidationInitializer()});
    }

    private <T> void loadFilterConverterFactories(Class<T> c, BiConsumer<String, T> biConsumer) {
        ServiceFinder.load(c, (ClassLoader[])new ClassLoader[0]).forEach(factory -> {
            NamedFactory annotation = factory.getClass().getAnnotation(NamedFactory.class);
            if (annotation != null) {
                String name = annotation.name();
                biConsumer.accept(name, factory);
            }
        });
    }

    private QueryFacade loadQueryFacade() {
        QueryFacade facadeImpl = null;
        Iterator<QueryFacade> iterator = ServiceLoader.load(QueryFacade.class, ((Object)((Object)this)).getClass().getClassLoader()).iterator();
        if (iterator.hasNext()) {
            facadeImpl = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("Found multiple QueryFacade service implementations: " + facadeImpl.getClass().getName() + " and " + iterator.next().getClass().getName());
            }
        }
        return facadeImpl;
    }

    protected void startTransport() {
        super.startTransport();
    }

    protected void startCaches() {
        super.startCaches();
        this.scheduledExecutor.scheduleWithFixedDelay(new CacheInfoUpdateTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    private void addSelfToTopologyView(EmbeddedCacheManager cacheManager) {
        this.addressCache = cacheManager.getCache(((HotRodServerConfiguration)this.configuration).topologyCacheName());
        Address clusterAddress = cacheManager.getAddress();
        this.address = ServerAddress.forAddress(((HotRodServerConfiguration)this.configuration).publicHost(), ((HotRodServerConfiguration)this.configuration).publicPort(), ((HotRodServerConfiguration)this.configuration).networkPrefixOverride());
        this.clusterExecutor = cacheManager.executor();
        this.viewChangeListener = new CrashedMemberDetectorListener(this.addressCache, this);
        cacheManager.addListener((Object)this.viewChangeListener);
        this.topologyChangeListener = new ReAddMyAddressListener(this.addressCache, clusterAddress, this.address);
        this.addressCache.addListener((Object)this.topologyChangeListener);
        this.timeService = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getTimeService();
        log.debugf("Map %s cluster address with %s server endpoint in address cache", clusterAddress, this.address);
        this.addressCache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)clusterAddress, (Object)this.address);
    }

    private void defineTopologyCacheConfig(EmbeddedCacheManager cacheManager) {
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache(((HotRodServerConfiguration)this.configuration).topologyCacheName(), this.createTopologyCacheConfig(cacheManager.getCacheManagerConfiguration().transport().distributedSyncTimeout()).build(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE));
    }

    protected ConfigurationBuilder createTopologyCacheConfig(long distSyncTimeout) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).remoteTimeout(((HotRodServerConfiguration)this.configuration).topologyReplTimeout()).locking().lockAcquisitionTimeout(((HotRodServerConfiguration)this.configuration).topologyLockTimeout()).clustering().partitionHandling().mergePolicy(null).expiration().lifespan(-1L).maxIdle(-1L).clustering().stateTransfer().awaitInitialTransfer(((HotRodServerConfiguration)this.configuration).topologyAwaitInitialTransfer()).fetchInMemoryState(true).timeout(distSyncTimeout + ((HotRodServerConfiguration)this.configuration).topologyReplTimeout());
        return builder;
    }

    public AdvancedCache<byte[], byte[]> cache(ExtendedCacheInfo cacheInfo, HotRodHeader header, Subject subject) {
        KeyValuePair<MediaType, MediaType> requestMediaTypes = HotRodServer.getRequestMediaTypes(header, cacheInfo.configuration);
        AdvancedCache<byte[], byte[]> cache = cacheInfo.getCache(requestMediaTypes, subject);
        cache = header.getOptimizedCache(cache, cacheInfo.transactional, cacheInfo.clustered);
        return cache;
    }

    public EmbeddedMultimapCache<byte[], byte[]> multimap(HotRodHeader header, Subject subject, boolean supportsDuplicates) {
        AdvancedCache cache = this.cache(this.getCacheInfo(header), header, subject).withStorageMediaType();
        return new EmbeddedMultimapCache((Cache)cache, supportsDuplicates);
    }

    public CompletionStage<Void> ensureCacheInitialized(HotRodHeader header) {
        String cacheName = header.cacheName;
        if (this.isCacheIgnored(cacheName)) {
            return CompletableFuture.failedFuture((Throwable)((Object)new CacheUnavailableException()));
        }
        if (this.knownCaches.get(cacheName) != null) {
            return CompletableFutures.completedNull();
        }
        boolean keep = this.checkCacheIsAvailable(cacheName, header.version, header.messageId);
        String validCacheName = this.validCacheName(cacheName);
        if (this.cacheManager.isRunning(validCacheName)) {
            this.actualCacheRetrieval(cacheName, keep, true);
            return CompletableFutures.completedNull();
        }
        return this.blockingManager.runBlocking(() -> this.actualCacheRetrieval(cacheName, keep, false), (Object)"cache-initialization");
    }

    public ExtendedCacheInfo getCacheInfo(HotRodHeader header) {
        return this.getCacheInfo(header.cacheName, header.version, header.messageId, true);
    }

    public ExtendedCacheInfo getCacheInfo(String cacheName, byte hotRodVersion, long messageId, boolean checkIgnored) {
        if (checkIgnored && this.isCacheIgnored(cacheName)) {
            throw new CacheUnavailableException();
        }
        ExtendedCacheInfo info = this.knownCaches.get(cacheName);
        if (info != null) {
            return info;
        }
        boolean keep = this.checkCacheIsAvailable(cacheName, hotRodVersion, messageId);
        return this.actualCacheRetrieval(cacheName, keep, true);
    }

    private ExtendedCacheInfo actualCacheRetrieval(String cacheName, boolean keep, boolean assertRunning) {
        AdvancedCache<byte[], byte[]> cache = this.obtainAnonymizedCache(cacheName, assertRunning);
        Configuration cacheCfg = SecurityActions.getCacheConfiguration(cache);
        ExtendedCacheInfo info = new ExtendedCacheInfo(cache, cacheCfg);
        this.updateCacheInfo(info);
        if (keep) {
            this.knownCaches.put(cacheName, info);
        }
        return info;
    }

    private boolean checkCacheIsAvailable(String cacheName, byte hotRodVersion, long messageId) {
        if (this.internalCacheRegistry.isPrivateCache(cacheName)) {
            throw new RequestParsingException(String.format("Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", cacheName), hotRodVersion, messageId);
        }
        if (this.internalCacheRegistry.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.PROTECTED)) {
            return false;
        }
        if (!(cacheName.isEmpty() || this.cacheManager.getCacheNames().contains(cacheName) || this.configurationManager.getAliases().contains(cacheName))) {
            throw new CacheNotFoundException(String.format("Cache with name '%s' not found amongst the configured caches", cacheName), hotRodVersion, messageId);
        }
        if (cacheName.isEmpty() && !this.hasDefaultCache) {
            throw new CacheNotFoundException("Default cache requested but not configured", hotRodVersion, messageId);
        }
        return true;
    }

    public void updateCacheInfo(ExtendedCacheInfo info) {
        if (info.getCache().getStatus() != ComponentStatus.RUNNING) {
            return;
        }
        boolean hasIndexing = SecurityActions.getCacheConfiguration((AdvancedCache)info.getCache()).indexing().enabled();
        info.update(hasIndexing);
    }

    private String validCacheName(String cacheName) {
        return cacheName.isEmpty() ? this.defaultCacheName() : cacheName;
    }

    private AdvancedCache<byte[], byte[]> obtainAnonymizedCache(String cacheName, boolean assertRunning) {
        String validCacheName = this.validCacheName(cacheName);
        boolean isRunning = this.cacheManager.isRunning(validCacheName);
        if (assertRunning && !isRunning && Thread.currentThread() instanceof NonBlockingResource) {
            throw new IllegalLifecycleStateException("Cache " + cacheName + " is not running and was attempted to be retrieved on a non blocking thread");
        }
        Cache cache = SecurityActions.getCache((EmbeddedCacheManager)this.cacheManager, (String)validCacheName);
        return cache.getAdvancedCache();
    }

    public Cache<Address, ServerAddress> getAddressCache() {
        return this.addressCache;
    }

    public void addCacheEventFilterFactory(String name, CacheEventFilterFactory factory) {
        this.clientListenerRegistry.addCacheEventFilterFactory(name, factory);
    }

    public void removeCacheEventFilterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventFilterFactory(name);
    }

    public void addCacheEventConverterFactory(String name, CacheEventConverterFactory factory) {
        this.clientListenerRegistry.addCacheEventConverterFactory(name, factory);
    }

    public void removeCacheEventConverterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventConverterFactory(name);
    }

    public void addCacheEventFilterConverterFactory(String name, CacheEventFilterConverterFactory factory) {
        this.clientListenerRegistry.addCacheEventFilterConverterFactory(name, factory);
    }

    public void removeCacheEventFilterConverterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventFilterConverterFactory(name);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        Optional<Marshaller> optMarshaller = Optional.ofNullable(marshaller);
        this.clientListenerRegistry.setEventMarshaller(optMarshaller);
    }

    public void addKeyValueFilterConverterFactory(String name, KeyValueFilterConverterFactory factory) {
        this.iterationManager.addKeyValueFilterConverterFactory(name, factory);
    }

    public void removeKeyValueFilterConverterFactory(String name) {
        this.iterationManager.removeKeyValueFilterConverterFactory(name);
    }

    public IterationManager getIterationManager() {
        return this.iterationManager;
    }

    public StreamingManager getStreamingManager() {
        return this.streamingManager;
    }

    private static KeyValuePair<MediaType, MediaType> getRequestMediaTypes(HotRodHeader header, Configuration configuration) {
        MediaType valueRequestType;
        MediaType keyRequestType = header == null ? MediaType.APPLICATION_UNKNOWN : header.getKeyMediaType();
        MediaType mediaType = valueRequestType = header == null ? MediaType.APPLICATION_UNKNOWN : header.getValueMediaType();
        if (header != null && HotRodVersion.HOTROD_28.isOlder(header.version)) {
            if (header.cacheName.equals("___protobuf_metadata")) {
                keyRequestType = MediaType.APPLICATION_PROTOSTREAM;
                valueRequestType = MediaType.APPLICATION_PROTOSTREAM;
            } else if (header.op == HotRodOperation.QUERY) {
                boolean objectStorage = MediaType.APPLICATION_OBJECT.match(configuration.encoding().valueDataType().mediaType());
                keyRequestType = objectStorage ? MediaType.APPLICATION_JBOSS_MARSHALLING : MediaType.APPLICATION_PROTOSTREAM;
                valueRequestType = objectStorage ? MediaType.APPLICATION_JBOSS_MARSHALLING : MediaType.APPLICATION_PROTOSTREAM;
            }
        }
        return new KeyValuePair((Object)keyRequestType, (Object)valueRequestType);
    }

    public void stop() {
        InternalCacheRegistry internalCacheRegistry;
        if (log.isDebugEnabled()) {
            log.debugf("Stopping server %s listening at %s:%d", this.getQualifiedName(), ((HotRodServerConfiguration)this.configuration).host(), ((HotRodServerConfiguration)this.configuration).port());
        }
        AggregateCompletionStage removeAllStage = CompletionStages.aggregateCompletionStage();
        if (this.serverCacheListener != null) {
            removeAllStage.dependsOn(SecurityActions.removeListenerAsync((Listenable)this.cacheManager, (Object)this.serverCacheListener));
        }
        if (this.viewChangeListener != null) {
            removeAllStage.dependsOn(SecurityActions.removeListenerAsync((Listenable)this.cacheManager, (Object)this.viewChangeListener));
        }
        if (this.topologyChangeListener != null) {
            removeAllStage.dependsOn(SecurityActions.removeListenerAsync(this.addressCache, (Object)this.topologyChangeListener));
        }
        CompletionStages.join((CompletionStage)removeAllStage.freeze());
        if (this.cacheManager != null && Configurations.isClustered((GlobalConfiguration)SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)this.cacheManager)) && (internalCacheRegistry = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cacheManager).getComponent(InternalCacheRegistry.class)) != null) {
            internalCacheRegistry.unregisterInternalCache(((HotRodServerConfiguration)this.configuration).topologyCacheName());
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        if (this.clientListenerRegistry != null) {
            this.clientListenerRegistry.stop();
        }
        if (this.clientCounterNotificationManager != null) {
            this.clientCounterNotificationManager.stop();
        }
        super.stop();
    }

    public HotRodAccessLogging accessLogging() {
        return this.accessLogging;
    }

    public Metadata.Builder buildMetadata2x(long lifespan, TimeUnitValue lifespanUnit, long maxIdle, TimeUnitValue maxIdleUnit) {
        EmbeddedMetadata.Builder metadata = new EmbeddedMetadata.Builder();
        if (lifespan != -2L && lifespanUnit != TimeUnitValue.DEFAULT) {
            if (lifespanUnit == TimeUnitValue.INFINITE) {
                metadata.lifespan(-1L);
            } else {
                metadata.lifespan(HotRodServer.toMillis(lifespan, lifespanUnit));
            }
        }
        if (maxIdle != -2L && maxIdleUnit != TimeUnitValue.DEFAULT) {
            if (maxIdleUnit == TimeUnitValue.INFINITE) {
                metadata.maxIdle(-1L);
            } else {
                metadata.maxIdle(HotRodServer.toMillis(maxIdle, maxIdleUnit));
            }
        }
        return metadata;
    }

    public Metadata.Builder buildMetadata(long lifespan, TimeUnitValue lifespanUnit, long maxIdle, TimeUnitValue maxIdleUnit) {
        EmbeddedMetadata.Builder metadata = new EmbeddedMetadata.Builder();
        if (lifespan != -2L && lifespanUnit != TimeUnitValue.DEFAULT) {
            if (lifespanUnit == TimeUnitValue.INFINITE) {
                metadata.lifespan(-1L);
            } else {
                metadata.lifespan(lifespanUnit.toTimeUnit().toMillis(lifespan));
            }
        }
        if (maxIdle != -2L && maxIdleUnit != TimeUnitValue.DEFAULT) {
            if (maxIdleUnit == TimeUnitValue.INFINITE) {
                metadata.maxIdle(-1L);
            } else {
                metadata.maxIdle(maxIdleUnit.toTimeUnit().toMillis(maxIdle));
            }
        }
        return metadata;
    }

    private static long toMillis(long duration, TimeUnitValue unit) {
        if (duration > 0L) {
            long milliseconds = unit.toTimeUnit().toMillis(duration);
            if (milliseconds > MILLISECONDS_IN_30_DAYS) {
                long unixTimeExpiry = milliseconds - System.currentTimeMillis();
                return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
            }
            return milliseconds;
        }
        return duration;
    }

    private static VersionGenerator getHotRodVersionGenerator(AdvancedCache<?, ?> cache) {
        return (VersionGenerator)((BasicComponentRegistry)SecurityActions.getCacheComponentRegistry(cache).getComponent(BasicComponentRegistry.class)).getComponent("org.infinispan.server.hotrod.versionGenerator", VersionGenerator.class).running();
    }

    protected String protocolType() {
        return "hotrod";
    }

    public String toString() {
        return this.toString("Hot Rod", "protocol=" + String.valueOf((Object)HotRodVersion.LATEST) + ", auth=" + String.join((CharSequence)",", ((HotRodServerConfiguration)this.configuration).authentication().sasl().mechanisms()));
    }

    @ProtoTypeId(value=6613)
    static class ToEmptyBytesKeyValueFilterConverter
    extends AbstractKeyValueFilterConverter {
        static final ToEmptyBytesKeyValueFilterConverter INSTANCE = new ToEmptyBytesKeyValueFilterConverter();
        static final byte[] bytes = Util.EMPTY_BYTE_ARRAY;

        ToEmptyBytesKeyValueFilterConverter() {
        }

        @ProtoFactory
        static ToEmptyBytesKeyValueFilterConverter protoFactory() {
            return INSTANCE;
        }

        public Object filterAndConvert(Object key, Object value, Metadata metadata) {
            return bytes;
        }

        public MediaType format() {
            return null;
        }
    }

    static class ToEmptyBytesFactory
    implements ParamKeyValueFilterConverterFactory {
        ToEmptyBytesFactory() {
        }

        public KeyValueFilterConverter getFilterConverter(Object[] params) {
            return ToEmptyBytesKeyValueFilterConverter.INSTANCE;
        }

        public boolean binaryParam() {
            return true;
        }
    }

    @Listener
    class ServerCacheListener {
        ServerCacheListener() {
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            HotRodServer.this.knownCaches.remove(event.getCacheName());
        }

        @ConfigurationChanged
        public void configurationChanged(ConfigurationChangedEvent event) {
            HotRodServer.this.knownCaches.clear();
        }
    }

    private class CacheInfoUpdateTask
    implements Runnable {
        private CacheInfoUpdateTask() {
        }

        @Override
        public void run() {
            for (ExtendedCacheInfo cacheInfo : HotRodServer.this.knownCaches.values()) {
                HotRodServer.this.updateCacheInfo(cacheInfo);
            }
        }
    }

    @Listener(sync=false, observation=Listener.Observation.POST)
    class ReAddMyAddressListener {
        private final Cache<Address, ServerAddress> addressCache;
        private final Address clusterAddress;
        private final ServerAddress address;

        ReAddMyAddressListener(Cache<Address, ServerAddress> addressCache, Address clusterAddress, ServerAddress address) {
            this.addressCache = addressCache;
            this.clusterAddress = clusterAddress;
            this.address = address;
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent<Address, ServerAddress> event) {
            this.recursionTopologyChanged();
        }

        private void recursionTopologyChanged() {
            if (HotRodServer.this.cacheManager.getStatus().allowInvocations()) {
                HotRodServer.this.clusterExecutor.submitConsumer((Function)new CheckAddressTask(this.addressCache.getName(), this.clusterAddress), (a, v, t) -> {
                    if (t != null && !(t instanceof IllegalLifecycleStateException)) {
                        log.debug("Error re-adding address to topology cache, retrying", (Throwable)t);
                        this.recursionTopologyChanged();
                    }
                    if (t == null && !v.booleanValue()) {
                        log.debugf("Re-adding %s to the topology cache", this.clusterAddress);
                        this.addressCache.putAsync((Object)this.clusterAddress, (Object)this.address);
                    }
                });
            }
        }
    }

    public static class ExtendedCacheInfo
    extends CacheInfo<byte[], byte[]> {
        final DistributionManager distributionManager;
        final VersionGenerator versionGenerator;
        final Configuration configuration;
        final boolean transactional;
        final boolean clustered;
        volatile boolean indexing;

        ExtendedCacheInfo(AdvancedCache<byte[], byte[]> cache, Configuration configuration) {
            super(SecurityActions.anonymizeSecureCache(cache));
            this.distributionManager = SecurityActions.getDistributionManager(cache);
            this.versionGenerator = HotRodServer.getHotRodVersionGenerator(cache);
            this.configuration = configuration;
            this.transactional = configuration.transaction().transactionMode().isTransactional();
            this.clustered = configuration.clustering().cacheMode().isClustered();
            this.indexing = true;
        }

        public void update(boolean indexing) {
            this.indexing = indexing;
        }
    }
}

