/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.transaction.tm.EmbeddedTransaction;

public class PerCacheTxTable {
    private static final Log log = (Log)LogFactory.getLog(PerCacheTxTable.class, Log.class);
    private final Map<XidImpl, EmbeddedTransaction> localTxTable = new ConcurrentHashMap<XidImpl, EmbeddedTransaction>();

    public EmbeddedTransaction getLocalTx(XidImpl xid) {
        return this.localTxTable.get(xid);
    }

    public void removeLocalTx(XidImpl xid) {
        EmbeddedTransaction tx = this.localTxTable.remove(xid);
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Removed tx=%s", xid, tx);
        }
    }

    public void createLocalTx(XidImpl xid, EmbeddedTransaction tx) {
        this.localTxTable.put(xid, tx);
        if (log.isTraceEnabled()) {
            log.tracef("[%s] New tx=%s", xid, tx);
        }
    }

    public boolean isEmpty() {
        if (log.isTraceEnabled()) {
            log.tracef("Active Transactions: %s", this.localTxTable.keySet());
        }
        return this.localTxTable.isEmpty();
    }
}

