/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers$;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.core.transport.Encoder;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HashDistAwareResponse;
import org.infinispan.server.hotrod.HotRodEncoder$;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.TopologyAwareResponse;
import org.infinispan.server.hotrod.TopologyView;
import org.infinispan.util.ByteArrayKey;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003\u001b!{GOU8e\u000b:\u001cw\u000eZ3s\u0015\t\u0019A!\u0001\u0004i_R\u0014x\u000e\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\u000b\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012!\u0003;sC:\u001c\bo\u001c:u\u0015\t\tB!\u0001\u0003d_J,\u0017BA\n\u000f\u0005\u001d)enY8eKJ\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u00111bU2bY\u0006|%M[3di\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0007dC\u000eDW-T1oC\u001e,'\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u00059Q.\u00198bO\u0016\u0014\u0018BA\u0011\u001f\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\"!J\u0014\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000bm\u0011\u0003\u0019\u0001\u000f\t\u0011%\u0002\u0001R1A\u0005\n)\n1\"[:DYV\u001cH/\u001a:fIV\t1\u0006\u0005\u0002\u0016Y%\u0011QF\u0006\u0002\b\u0005>|G.Z1o\u0011!y\u0003\u0001#A!B\u0013Y\u0013\u0001D5t\u00072,8\u000f^3sK\u0012\u0004\u0003\u0002C\u0019\u0001\u0011\u000b\u0007I\u0011\u0002\u001a\u0002\u001bQ|\u0007o\u001c7pOf\u001c\u0015m\u00195f+\u0005\u0019\u0004\u0003\u0002\u001b6oyj\u0011AB\u0005\u0003m\u0019\u0011QaQ1dQ\u0016\u0004\"\u0001O\u001e\u000f\u0005UI\u0014B\u0001\u001e\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i2\u0002C\u0001\u0014@\u0013\t\u0001%A\u0001\u0007U_B|Gn\\4z-&,w\u000f\u0003\u0005C\u0001!\u0005\t\u0015)\u00034\u00039!x\u000e]8m_\u001eL8)Y2iK\u0002BQ\u0001\u0012\u0001\u0005B\u0015\u000ba!\u001a8d_\u0012,G\u0003\u0002$J\u001dN\u0003\"!F$\n\u0005!3\"AB!osJ+g\rC\u0003K\u0007\u0002\u00071*A\u0002dib\u0004\"!\u0004'\n\u00055s!!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006\u001f\u000e\u0003\r\u0001U\u0001\bG\"\fgN\\3m!\ti\u0011+\u0003\u0002S\u001d\t91\t[1o]\u0016d\u0007\"\u0002+D\u0001\u00041\u0015aA7tO\")a\u000b\u0001C\u0005/\u0006\u0019r-\u001a;U_B|Gn\\4z%\u0016\u001c\bo\u001c8tKR\u0011\u0001l\u0017\t\u0003MeK!A\u0017\u0002\u00031\u0005\u00137\u000f\u001e:bGR$v\u000e]8m_\u001eL(+Z:q_:\u001cX\rC\u0003]+\u0002\u0007Q,A\u0001s!\t1c,\u0003\u0002`\u0005\tA!+Z:q_:\u001cX\rC\u0003b\u0001\u0011%!-A\u0006xe&$X\rS3bI\u0016\u0014H\u0003B2gO&\u0004\"!\u00043\n\u0005\u0015t!!D\"iC:tW\r\u001c\"vM\u001a,'\u000fC\u0003]A\u0002\u0007Q\fC\u0003iA\u0002\u00071&A\u0004jgR\u0013\u0018mY3\t\u000b)\u0004\u0007\u0019\u0001-\u0002\u0019Q|\u0007o\u001c7pOf\u0014Vm\u001d9\t\u000b1\u0004A\u0011B7\u0002']\u0014\u0018\u000e^3U_B|Gn\\4z\u0011\u0016\fG-\u001a:\u0015\t9\fh\u000f\u001f\t\u0003+=L!\u0001\u001d\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006e.\u0004\ra]\u0001\u0002iB\u0011a\u0005^\u0005\u0003k\n\u0011Q\u0003V8q_2|w-_!xCJ,'+Z:q_:\u001cX\rC\u0003xW\u0002\u00071-\u0001\u0004ck\u001a4WM\u001d\u0005\u0006Q.\u0004\ra\u000b\u0005\u0006u\u0002!Ia_\u0001\u0018oJLG/\u001a%bg\"$v\u000e]8m_\u001eL\b*Z1eKJ$BA\u001c?~}\")!/\u001fa\u0001g\")q/\u001fa\u0001G\")\u0001.\u001fa\u0001W!1!\u0010\u0001C\u0005\u0003\u0003!\u0012B\\A\u0002\u0003\u001b\ty!!\u0005\t\u000f\u0005\u0015q\u00101\u0001\u0002\b\u0005\t\u0001\u000eE\u0002'\u0003\u0013I1!a\u0003\u0003\u0005UA\u0015m\u001d5ESN$\u0018i^1sKJ+7\u000f]8og\u0016DQa^@A\u0002\rDQ\u0001X@A\u0002uCQ\u0001[@A\u0002-:q!!\u0006\u0003\u0011\u000b\t9\"A\u0007I_R\u0014v\u000eZ#oG>$WM\u001d\t\u0004M\u0005ea!C\u0001\u0003\t\u0003\u0005\tRAA\u000e'\u001d\tI\"!\b\u0002.Q\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003mC:<'BAA\u0014\u0003\u0011Q\u0017M^1\n\t\u0005-\u0012\u0011\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005=\u0012\u0011G\u0007\u0002!%\u0019\u00111\u0007\t\u0003\u000f1{wmZ5oO\"91%!\u0007\u0005\u0002\u0005]BCAA\f\u0011)\tY$!\u0007C\u0002\u0013%\u0011QH\u0001\u0006\u001b\u0006<\u0017nY\u000b\u0003\u0003\u007f\u00012!FA!\u0013\r\t\u0019E\u0006\u0002\u0004\u0013:$\b\"CA$\u00033\u0001\u000b\u0011BA \u0003\u0019i\u0015mZ5dA\u0001")
public class HotRodEncoder
extends Encoder
implements ScalaObject {
    private final EmbeddedCacheManager cacheManager;
    private boolean isClustered;
    private Cache<String, TopologyView> topologyCache;
    public volatile int bitmap$0;

    public static final void error(Function0 function0, Throwable throwable) {
        HotRodEncoder$.MODULE$.error(function0, throwable);
    }

    public static final void error(Function0 function0) {
        HotRodEncoder$.MODULE$.error(function0);
    }

    public static final void warn(Function0 function0, Throwable throwable) {
        HotRodEncoder$.MODULE$.warn(function0, throwable);
    }

    public static final void warn(Function0 function0, Seq seq) {
        HotRodEncoder$.MODULE$.warn(function0, seq);
    }

    public static final void trace(Function0 function0, Seq seq) {
        HotRodEncoder$.MODULE$.trace(function0, seq);
    }

    public static final boolean isTraceEnabled() {
        return HotRodEncoder$.MODULE$.isTraceEnabled();
    }

    public static final void debug(Function0 function0, Seq seq) {
        HotRodEncoder$.MODULE$.debug(function0, seq);
    }

    public static final boolean isDebugEnabled() {
        return HotRodEncoder$.MODULE$.isDebugEnabled();
    }

    public static final void info(Function0 function0, Seq seq) {
        HotRodEncoder$.MODULE$.info(function0, seq);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isClustered() {
        if ((this.bitmap$0 & 1) != 0) return this.isClustered;
        HotRodEncoder hotRodEncoder = this;
        synchronized (hotRodEncoder) {
            if ((this.bitmap$0 & 1) == 0) {
                this.isClustered = this.cacheManager.getGlobalConfiguration().getTransportClass() != null;
                this.bitmap$0 |= 1;
            }
            return this.isClustered;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cache<String, TopologyView> topologyCache() {
        if ((this.bitmap$0 & 4) != 0) return this.topologyCache;
        HotRodEncoder hotRodEncoder = this;
        synchronized (hotRodEncoder) {
            if ((this.bitmap$0 & 4) == 0) {
                this.topologyCache = this.isClustered() ? this.cacheManager.getCache(HotRodServer$.MODULE$.TopologyCacheName()) : null;
                this.bitmap$0 |= 4;
            }
            return this.topologyCache;
        }
    }

    public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) {
        Object object;
        boolean isTrace = HotRodEncoder$.MODULE$.isTraceEnabled();
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$encode$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg}));
        }
        if ((object = msg) instanceof Response) {
            Response response;
            Response r = response = (Response)object;
            ChannelBuffer buffer$1 = this.writeHeader(r, isTrace, this.getTopologyResponse(r));
            Object object2 = msg;
            if (object2 instanceof ResponseWithPrevious) {
                ResponseWithPrevious responseWithPrevious;
                ResponseWithPrevious r2 = responseWithPrevious = (ResponseWithPrevious)object2;
                Option<byte[]> option = r2.previous();
                None$ none$ = None$.MODULE$;
                if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
                    buffer$1.writeUnsignedInt(0);
                } else {
                    buffer$1.writeRangedBytes((byte[])r2.previous().get());
                }
            } else if (object2 instanceof StatsResponse) {
                StatsResponse statsResponse;
                StatsResponse s = statsResponse = (StatsResponse)object2;
                buffer$1.writeUnsignedInt(s.stats().size());
                s.stats().foreach((Function1)new $anonfun$encode$2(this, buffer$1));
            } else if (object2 instanceof GetWithVersionResponse) {
                GetWithVersionResponse getWithVersionResponse;
                GetWithVersionResponse g = getWithVersionResponse = (GetWithVersionResponse)object2;
                Enumeration.Value value = g.status();
                Enumeration.Value value2 = OperationStatus$.MODULE$.Success();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    buffer$1.writeLong(g.version());
                    buffer$1.writeRangedBytes((byte[])g.data().get());
                }
            } else if (object2 instanceof GetResponse) {
                GetResponse getResponse;
                GetResponse g = getResponse = (GetResponse)object2;
                Enumeration.Value value = g.status();
                Enumeration.Value value3 = OperationStatus$.MODULE$.Success();
                if (!(value != null ? !value.equals(value3) : value3 != null)) {
                    buffer$1.writeRangedBytes((byte[])g.data().get());
                }
            } else if (object2 instanceof ErrorResponse) {
                buffer$1.writeString(((ErrorResponse)object2).msg());
            } else if (buffer$1 == null) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Response received is unknown: ").append(msg).toString());
            }
            return buffer$1;
        }
        throw new MatchError(object);
    }

    private AbstractTopologyResponse getTopologyResponse(Response r) {
        AbstractTopologyResponse abstractTopologyResponse;
        if (this.isClustered()) {
            short s = r.clientIntel();
            switch (s) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToShort((short)s));
                }
                case 2: 
                case 3: {
                    TopologyView currentTopologyView = (TopologyView)this.topologyCache().get("view");
                    if (r.topologyId() != currentTopologyView.topologyId()) {
                        Cache<ByteArrayKey, CacheValue> cache = HotRodServer$.MODULE$.getCacheInstance(r.cacheName(), this.cacheManager);
                        Configuration config = cache.getConfiguration();
                        if (r.clientIntel() != 2 && config.getCacheMode().isDistributed()) {
                            int hashSpace = cache.getAdvancedCache().getDistributionManager().getConsistentHash().getHashSpace();
                            abstractTopologyResponse = new HashDistAwareResponse(new TopologyView(currentTopologyView.topologyId(), currentTopologyView.members()), config.getNumOwners(), 1, hashSpace);
                            break;
                        }
                        abstractTopologyResponse = new TopologyAwareResponse(new TopologyView(currentTopologyView.topologyId(), currentTopologyView.members()));
                        break;
                    }
                    abstractTopologyResponse = null;
                    break;
                }
                case 1: {
                    abstractTopologyResponse = null;
                    break;
                }
            }
        } else {
            abstractTopologyResponse = null;
        }
        return abstractTopologyResponse;
    }

    private ChannelBuffer writeHeader(Response r, boolean isTrace, AbstractTopologyResponse topologyResp) {
        AbstractTopologyResponse abstractTopologyResponse;
        block8: {
            ChannelBuffer buffer;
            block6: {
                block7: {
                    TopologyAwareResponse topologyAwareResponse;
                    block5: {
                        buffer = ChannelBuffers$.MODULE$.dynamicBuffer();
                        buffer.writeByte(Predef$.MODULE$.int2Integer(HotRodEncoder$.MODULE$.org$infinispan$server$hotrod$HotRodEncoder$$Magic()).byteValue());
                        buffer.writeUnsignedLong(r.messageId());
                        buffer.writeByte(Predef$.MODULE$.int2Integer(r.operation().id()).byteValue());
                        buffer.writeByte(Predef$.MODULE$.int2Integer(r.status().id()).byteValue());
                        if (topologyResp != null) break block5;
                        buffer.writeByte((byte)0);
                        break block6;
                    }
                    buffer.writeByte((byte)1);
                    abstractTopologyResponse = topologyResp;
                    if (!(abstractTopologyResponse instanceof TopologyAwareResponse)) break block7;
                    TopologyAwareResponse t = topologyAwareResponse = (TopologyAwareResponse)abstractTopologyResponse;
                    if (r.clientIntel() == 2) {
                        this.writeTopologyHeader(t, buffer, isTrace);
                    } else {
                        this.writeHashTopologyHeader(t, buffer, isTrace);
                    }
                    break block6;
                }
                if (!(abstractTopologyResponse instanceof HashDistAwareResponse)) break block8;
                this.writeHashTopologyHeader((HashDistAwareResponse)abstractTopologyResponse, buffer, r, isTrace);
            }
            return buffer;
        }
        throw new MatchError((Object)abstractTopologyResponse);
    }

    private void writeTopologyHeader(TopologyAwareResponse t, ChannelBuffer buffer$2, boolean isTrace) {
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$writeTopologyHeader$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
        }
        buffer$2.writeUnsignedInt(t.view().topologyId());
        buffer$2.writeUnsignedInt(t.view().members().size());
        t.view().members().foreach((Function1)new $anonfun$writeTopologyHeader$2(this, buffer$2));
    }

    private void writeHashTopologyHeader(TopologyAwareResponse t, ChannelBuffer buffer$4, boolean isTrace) {
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$writeHashTopologyHeader$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
        }
        buffer$4.writeUnsignedInt(t.view().topologyId());
        buffer$4.writeUnsignedShort(0);
        buffer$4.writeByte((byte)0);
        buffer$4.writeUnsignedInt(0);
        buffer$4.writeUnsignedInt(t.view().members().size());
        t.view().members().foreach((Function1)new $anonfun$writeHashTopologyHeader$2(this, buffer$4));
    }

    private void writeHashTopologyHeader(HashDistAwareResponse h, ChannelBuffer buffer$3, Response r$1, boolean isTrace) {
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$writeHashTopologyHeader$3(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h}));
        }
        buffer$3.writeUnsignedInt(h.view().topologyId());
        buffer$3.writeUnsignedShort(h.numOwners());
        buffer$3.writeByte(h.hashFunction());
        buffer$3.writeUnsignedInt(h.hashSpace());
        buffer$3.writeUnsignedInt(h.view().members().size());
        BooleanRef hashIdUpdateRequired$1 = new BooleanRef(false);
        ConsistentHash consistentHash$1 = HotRodServer$.MODULE$.getCacheInstance(r$1.cacheName(), this.cacheManager).getAdvancedCache().getDistributionManager().getConsistentHash();
        ListBuffer updateMembers$1 = new ListBuffer();
        h.view().members().foreach((Function1)new $anonfun$writeHashTopologyHeader$4(this, buffer$3, r$1, hashIdUpdateRequired$1, consistentHash$1, updateMembers$1));
        if (hashIdUpdateRequired$1.elem) {
            List x$6 = updateMembers$1.toList();
            int x$7 = h.view().copy$default$1();
            TopologyView viewCopy = h.view().copy(x$7, x$6);
            this.topologyCache().replace("view", h.view(), viewCopy);
        }
    }

    public HotRodEncoder(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

