/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.core.Logging;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestParameters;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.hotrod.AbstractVersionedDecoder;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.Decoder10$;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation$;
import org.infinispan.server.hotrod.OperationResponse$;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ProtocolFlag$;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.stats.Stats;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Decoder10$
extends AbstractVersionedDecoder
implements Logging,
ScalaObject {
    public static final Decoder10$ MODULE$;
    private final Log org$infinispan$server$core$Logging$$log;
    public volatile int bitmap$0;

    static {
        new Decoder10$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Log org$infinispan$server$core$Logging$$log() {
        if ((this.bitmap$0 & 1) != 0) return this.org$infinispan$server$core$Logging$$log;
        Decoder10$ decoder10$ = this;
        synchronized (decoder10$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.org$infinispan$server$core$Logging$$log = Logging.class.org$infinispan$server$core$Logging$$log((Logging)this);
                this.bitmap$0 |= 1;
            }
            return this.org$infinispan$server$core$Logging$$log;
        }
    }

    public void info(Function0 msg, Seq params) {
        Logging.class.info((Logging)this, (Function0)msg, (Seq)params);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0 msg, Seq params) {
        Logging.class.debug((Logging)this, (Function0)msg, (Seq)params);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0 msg, Seq params) {
        Logging.class.trace((Logging)this, (Function0)msg, (Seq)params);
    }

    public void warn(Function0 msg, Seq params) {
        Logging.class.warn((Logging)this, (Function0)msg, (Seq)params);
    }

    public void warn(Function0 msg, Throwable t) {
        Logging.class.warn((Logging)this, (Function0)msg, (Throwable)t);
    }

    public void error(Function0 msg) {
        Logging.class.error((Logging)this, (Function0)msg);
    }

    public void error(Function0 msg, Throwable t) {
        Logging.class.error((Logging)this, (Function0)msg, (Throwable)t);
    }

    @Override
    public HotRodHeader readHeader(ChannelBuffer buffer, long messageId) {
        Enumeration.Value value;
        Enumeration.Value op;
        short streamOp;
        short s = streamOp = buffer.readUnsignedByte();
        switch (s) {
            default: {
                throw new UnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)BoxesRunTime.boxToShort((short)streamOp)).toString());
            }
            case 25: {
                Enumeration.Value value2 = HotRodOperation$.MODULE$.BulkGetRequest();
                break;
            }
            case 23: {
                Enumeration.Value value2 = HotRodOperation$.MODULE$.PingRequest();
                break;
            }
            case 21: {
                Enumeration.Value value2 = Operation$.MODULE$.StatsRequest();
                break;
            }
            case 19: {
                Enumeration.Value value2 = HotRodOperation$.MODULE$.ClearRequest();
                break;
            }
            case 17: {
                Enumeration.Value value2 = Operation$.MODULE$.GetWithVersionRequest();
                break;
            }
            case 15: {
                Enumeration.Value value2 = HotRodOperation$.MODULE$.ContainsKeyRequest();
                break;
            }
            case 13: {
                Enumeration.Value value2 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                break;
            }
            case 11: {
                Enumeration.Value value2 = Operation$.MODULE$.RemoveRequest();
                break;
            }
            case 9: {
                Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                break;
            }
            case 7: {
                Enumeration.Value value2 = Operation$.MODULE$.ReplaceRequest();
                break;
            }
            case 5: {
                Enumeration.Value value2 = Operation$.MODULE$.PutIfAbsentRequest();
                break;
            }
            case 3: {
                Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                break;
            }
            case 1: {
                Enumeration.Value value2 = op = Operation$.MODULE$.PutRequest();
            }
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0)new anonfun.readHeader.1(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)streamOp), op}));
        }
        String cacheName = buffer.readString();
        int n = buffer.readUnsignedInt();
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 1: {
                value = ProtocolFlag$.MODULE$.ForceReturnPreviousValue();
                break;
            }
            case 0: {
                value = ProtocolFlag$.MODULE$.NoFlag();
            }
        }
        Enumeration.Value flag = value;
        short clientIntelligence = buffer.readUnsignedByte();
        int topologyId = buffer.readUnsignedInt();
        byte txId = buffer.readByte();
        if (txId != 0) {
            throw new UnsupportedOperationException(new StringBuilder().append((Object)"Transaction types other than 0 (NO_TX) is not supported at this stage.  Saw TX_ID of ").append((Object)BoxesRunTime.boxToByte((byte)txId)).toString());
        }
        return new HotRodHeader(op, messageId, cacheName, flag, clientIntelligence, topologyId, this);
    }

    @Override
    public ByteArrayKey readKey(ChannelBuffer buffer) {
        return new ByteArrayKey(buffer.readRangedBytes());
    }

    @Override
    public Option<RequestParameters> readParameters(HotRodHeader header, ChannelBuffer buffer) {
        None$ none$;
        Enumeration.Value value;
        Enumeration.Value value2 = value = header.op();
        Enumeration.Value value3 = Operation$.MODULE$.RemoveRequest();
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            none$ = None$.MODULE$;
        } else {
            Enumeration.Value value4 = value;
            Enumeration.Value value5 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                none$ = new Some((Object)new RequestParameters(null, -1, -1, buffer.readLong()));
            } else {
                Enumeration.Value value6 = value;
                Enumeration.Value value7 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    int lifespan = this.readLifespanOrMaxIdle(buffer);
                    int maxIdle = this.readLifespanOrMaxIdle(buffer);
                    long version = buffer.readLong();
                    none$ = new Some((Object)new RequestParameters(buffer.readRangedBytes(), lifespan, maxIdle, version));
                } else {
                    int lifespan = this.readLifespanOrMaxIdle(buffer);
                    int maxIdle = this.readLifespanOrMaxIdle(buffer);
                    none$ = new Some((Object)new RequestParameters(buffer.readRangedBytes(), lifespan, maxIdle, -1L));
                }
            }
        }
        return none$;
    }

    private int readLifespanOrMaxIdle(ChannelBuffer buffer) {
        int stream = buffer.readUnsignedInt();
        return stream <= 0 ? -1 : stream;
    }

    @Override
    public CacheValue createValue(RequestParameters params, long nextVersion) {
        return new CacheValue(params.data(), nextVersion);
    }

    @Override
    public Object createSuccessResponse(HotRodHeader header, CacheValue prev) {
        return this.createResponse(header, this.toResponse(header.op()), OperationStatus$.MODULE$.Success(), prev);
    }

    @Override
    public Object createNotExecutedResponse(HotRodHeader header, CacheValue prev) {
        return this.createResponse(header, this.toResponse(header.op()), OperationStatus$.MODULE$.OperationNotExecuted(), prev);
    }

    @Override
    public Object createNotExistResponse(HotRodHeader header) {
        return this.createResponse(header, this.toResponse(header.op()), OperationStatus$.MODULE$.KeyDoesNotExist(), null);
    }

    private Object createResponse(HotRodHeader h, Enumeration.Value op, Enumeration.Value st, CacheValue prev) {
        Enumeration.Value value = h.flag();
        Enumeration.Value value2 = ProtocolFlag$.MODULE$.ForceReturnPreviousValue();
        return !(value != null ? !value.equals(value2) : value2 != null) ? new ResponseWithPrevious(h.messageId(), h.cacheName(), h.clientIntel(), op, st, h.topologyId(), (Option<byte[]>)(prev == null ? None$.MODULE$ : new Some((Object)prev.data()))) : new Response(h.messageId(), h.cacheName(), h.clientIntel(), op, st, h.topologyId());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object createGetResponse(HotRodHeader h, CacheValue v, Enumeration.Value op) {
        GetResponse getResponse;
        if (v != null) {
            Enumeration.Value value = op;
            Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                getResponse = new GetResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)v.data()));
                return getResponse;
            }
        }
        if (v != null) {
            Enumeration.Value value = op;
            Enumeration.Value value3 = Operation$.MODULE$.GetWithVersionRequest();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                getResponse = new GetWithVersionResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithVersionResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), (Option<byte[]>)new Some((Object)v.data()), v.version());
                return getResponse;
            }
        }
        Enumeration.Value value = op;
        Enumeration.Value value4 = Operation$.MODULE$.GetRequest();
        if (!(value != null ? !value.equals(value4) : value4 != null)) {
            getResponse = new GetResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$);
            return getResponse;
        }
        getResponse = new GetWithVersionResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.GetWithVersionResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId(), (Option<byte[]>)None$.MODULE$, 0L);
        return getResponse;
    }

    @Override
    public Object handleCustomRequest(HotRodHeader h, ChannelBuffer buffer, Cache<ByteArrayKey, CacheValue> cache) {
        Enumeration.Value value;
        block9: {
            Object object;
            block5: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                boolean removed;
                                Enumeration.Value value2 = value = h.op();
                                Enumeration.Value value3 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                                ByteArrayKey k = this.readKey(buffer);
                                Option<RequestParameters> params = this.readParameters(h, buffer);
                                CacheValue prev = (CacheValue)cache.get(k);
                                object = prev == null ? this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), prev) : (prev.version() == ((RequestParameters)params.get()).streamVersion() ? ((removed = cache.remove(k, prev)) ? this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.Success(), prev) : this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.OperationNotExecuted(), prev)) : this.createResponse(h, OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse(), OperationStatus$.MODULE$.OperationNotExecuted(), prev));
                                break block5;
                            }
                            Enumeration.Value value4 = value;
                            Enumeration.Value value5 = HotRodOperation$.MODULE$.ContainsKeyRequest();
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                            ByteArrayKey k = this.readKey(buffer);
                            object = cache.containsKey(k) ? new Response(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ContainsKeyResponse(), OperationStatus$.MODULE$.Success(), h.topologyId()) : new Response(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ContainsKeyResponse(), OperationStatus$.MODULE$.KeyDoesNotExist(), h.topologyId());
                            break block5;
                        }
                        Enumeration.Value value6 = value;
                        Enumeration.Value value7 = HotRodOperation$.MODULE$.ClearRequest();
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block7;
                        this.getOptimizedCache(h, cache).clear();
                        object = new Response(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.ClearResponse(), OperationStatus$.MODULE$.Success(), h.topologyId());
                        break block5;
                    }
                    Enumeration.Value value8 = value;
                    Enumeration.Value value9 = HotRodOperation$.MODULE$.PingRequest();
                    if (value8 != null ? !value8.equals(value9) : value9 != null) break block8;
                    object = new Response(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.PingResponse(), OperationStatus$.MODULE$.Success(), h.topologyId());
                    break block5;
                }
                Enumeration.Value value10 = value;
                Enumeration.Value value11 = HotRodOperation$.MODULE$.BulkGetRequest();
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block9;
                int count$1 = buffer.readUnsignedInt();
                if (this.isTraceEnabled()) {
                    this.trace((Function0)new anonfun.handleCustomRequest.1(count$1), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                object = new BulkGetResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse$.MODULE$.BulkGetResponse(), OperationStatus$.MODULE$.Success(), h.topologyId(), count$1);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    @Override
    public Object createStatsResponse(HotRodHeader h, Stats cacheStats) {
        Map stats = Map$.MODULE$.empty();
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"timeSinceStart").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getTimeSinceStart())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"currentNumberOfEntries").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)cacheStats.getCurrentNumberOfEntries())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"totalNumberOfEntries").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getTotalNumberOfEntries())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"stores").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getStores())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"retrievals").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRetrievals())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"hits").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getHits())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"misses").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getMisses())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"removeHits").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRemoveHits())).toString()));
        stats.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)"removeMisses").$minus$greater((Object)((Object)BoxesRunTime.boxToLong((long)cacheStats.getRemoveMisses())).toString()));
        return new StatsResponse(h.messageId(), h.cacheName(), h.clientIntel(), (scala.collection.immutable.Map<String, String>)((MapLike)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).$plus$plus((TraversableOnce)stats), h.topologyId());
    }

    @Override
    public Object createErrorResponse(HotRodHeader h, Throwable t) {
        Throwable throwable;
        block5: {
            ErrorResponse errorResponse;
            block3: {
                block4: {
                    block2: {
                        throwable = t;
                        if (!(throwable instanceof IOException)) break block2;
                        errorResponse = new ErrorResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.ParseError(), h.topologyId(), ((IOException)throwable).toString());
                        break block3;
                    }
                    if (!(throwable instanceof TimeoutException)) break block4;
                    errorResponse = new ErrorResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.OperationTimedOut(), h.topologyId(), ((TimeoutException)throwable).toString());
                    break block3;
                }
                if (throwable == null) break block5;
                errorResponse = new ErrorResponse(h.messageId(), h.cacheName(), h.clientIntel(), OperationStatus$.MODULE$.ServerError(), h.topologyId(), throwable.toString());
            }
            return errorResponse;
        }
        throw new MatchError((Object)throwable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Cache<ByteArrayKey, CacheValue> getOptimizedCache(HotRodHeader h, Cache<ByteArrayKey, CacheValue> c) {
        AdvancedCache advancedCache;
        if (c.getConfiguration().getCacheMode().isDistributed()) {
            Enumeration.Value value = h.flag();
            Enumeration.Value value2 = ProtocolFlag$.MODULE$.ForceReturnPreviousValue();
            if (value == null ? value2 != null : !value.equals(value2)) {
                advancedCache = c.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP});
                return advancedCache;
            }
        }
        advancedCache = c;
        return advancedCache;
    }

    public Enumeration.Value toResponse(Enumeration.Value request) {
        Enumeration.Value value;
        block15: {
            Enumeration.Value value2;
            block3: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                Enumeration.Value value3 = value = request;
                                                                Enumeration.Value value4 = Operation$.MODULE$.PutRequest();
                                                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                                                                value2 = OperationResponse$.MODULE$.PutResponse();
                                                                break block3;
                                                            }
                                                            Enumeration.Value value5 = value;
                                                            Enumeration.Value value6 = Operation$.MODULE$.GetRequest();
                                                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                                                            value2 = OperationResponse$.MODULE$.GetResponse();
                                                            break block3;
                                                        }
                                                        Enumeration.Value value7 = value;
                                                        Enumeration.Value value8 = Operation$.MODULE$.PutIfAbsentRequest();
                                                        if (value7 != null ? !value7.equals(value8) : value8 != null) break block5;
                                                        value2 = OperationResponse$.MODULE$.PutIfAbsentResponse();
                                                        break block3;
                                                    }
                                                    Enumeration.Value value9 = value;
                                                    Enumeration.Value value10 = Operation$.MODULE$.ReplaceRequest();
                                                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block6;
                                                    value2 = OperationResponse$.MODULE$.ReplaceResponse();
                                                    break block3;
                                                }
                                                Enumeration.Value value11 = value;
                                                Enumeration.Value value12 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
                                                if (value11 != null ? !value11.equals(value12) : value12 != null) break block7;
                                                value2 = OperationResponse$.MODULE$.ReplaceIfUnmodifiedResponse();
                                                break block3;
                                            }
                                            Enumeration.Value value13 = value;
                                            Enumeration.Value value14 = Operation$.MODULE$.RemoveRequest();
                                            if (value13 != null ? !value13.equals(value14) : value14 != null) break block8;
                                            value2 = OperationResponse$.MODULE$.RemoveResponse();
                                            break block3;
                                        }
                                        Enumeration.Value value15 = value;
                                        Enumeration.Value value16 = HotRodOperation$.MODULE$.RemoveIfUnmodifiedRequest();
                                        if (value15 != null ? !value15.equals(value16) : value16 != null) break block9;
                                        value2 = OperationResponse$.MODULE$.RemoveIfUnmodifiedResponse();
                                        break block3;
                                    }
                                    Enumeration.Value value17 = value;
                                    Enumeration.Value value18 = HotRodOperation$.MODULE$.ContainsKeyRequest();
                                    if (value17 != null ? !value17.equals(value18) : value18 != null) break block10;
                                    value2 = OperationResponse$.MODULE$.ContainsKeyResponse();
                                    break block3;
                                }
                                Enumeration.Value value19 = value;
                                Enumeration.Value value20 = Operation$.MODULE$.GetWithVersionRequest();
                                if (value19 != null ? !value19.equals(value20) : value20 != null) break block11;
                                value2 = OperationResponse$.MODULE$.GetWithVersionResponse();
                                break block3;
                            }
                            Enumeration.Value value21 = value;
                            Enumeration.Value value22 = HotRodOperation$.MODULE$.ClearRequest();
                            if (value21 != null ? !value21.equals(value22) : value22 != null) break block12;
                            value2 = OperationResponse$.MODULE$.ClearResponse();
                            break block3;
                        }
                        Enumeration.Value value23 = value;
                        Enumeration.Value value24 = Operation$.MODULE$.StatsRequest();
                        if (value23 != null ? !value23.equals(value24) : value24 != null) break block13;
                        value2 = OperationResponse$.MODULE$.StatsResponse();
                        break block3;
                    }
                    Enumeration.Value value25 = value;
                    Enumeration.Value value26 = HotRodOperation$.MODULE$.PingRequest();
                    if (value25 != null ? !value25.equals(value26) : value26 != null) break block14;
                    value2 = OperationResponse$.MODULE$.PingResponse();
                    break block3;
                }
                Enumeration.Value value27 = value;
                Enumeration.Value value28 = HotRodOperation$.MODULE$.BulkGetRequest();
                if (value27 != null ? !value27.equals(value28) : value28 != null) break block15;
                value2 = OperationResponse$.MODULE$.BulkGetResponse();
            }
            return value2;
        }
        throw new MatchError((Object)value);
    }

    private Decoder10$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

