/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.nio.channels.ClosedChannelException;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.core.RequestParameters;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.Decoder10$;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.HotRodDecoder$;
import org.infinispan.server.hotrod.HotRodException;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.UnknownVersionException;
import org.infinispan.stats.Stats;
import org.infinispan.util.ByteArrayKey;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003\u001b!{GOU8e\t\u0016\u001cw\u000eZ3s\u0015\t\u0019A!\u0001\u0004i_R\u0014x\u000e\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001D\u000e\u0011\t5\u0001\"\u0003G\u0007\u0002\u001d)\u0011q\u0002B\u0001\u0005G>\u0014X-\u0003\u0002\u0012\u001d\t9\u0012IY:ue\u0006\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c#fG>$WM\u001d\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0019\tA!\u001e;jY&\u0011q\u0003\u0006\u0002\r\u0005f$X-\u0011:sCf\\U-\u001f\t\u0003\u001beI!A\u0007\b\u0003\u0015\r\u000b7\r[3WC2,X\r\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SDA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u0019\r\f7\r[3NC:\fw-\u001a:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u00192\u0011aB7b]\u0006<WM]\u0005\u0003Q\u0015\u0012A#R7cK\u0012$W\rZ\"bG\",W*\u00198bO\u0016\u0014\b\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\b\u0006\u0002-]A\u0011Q\u0006A\u0007\u0002\u0005!)!%\u000ba\u0001G\u0015A\u0001\u0007\u0001C\u0001\u0002\u0003\u0005\u0011G\u0001\bTk&$\u0018M\u00197f\u0011\u0016\fG-\u001a:\u0011\u00055\u0012\u0014BA\u001a\u0003\u00051Au\u000e\u001e*pI\"+\u0017\rZ3s\u000b!)\u0004\u0001\"A\u0001\u0002\u00031$AE*vSR\f'\r\\3QCJ\fW.\u001a;feN\u0004\"!D\u001c\n\u0005ar!!\u0005*fcV,7\u000f\u001e)be\u0006lW\r^3sg\"9!\b\u0001a\u0001\n\u0013Y\u0014aB5t\u000bJ\u0014xN]\u000b\u0002yA\u0011A$P\u0005\u0003}u\u0011qAQ8pY\u0016\fg\u000eC\u0004A\u0001\u0001\u0007I\u0011B!\u0002\u0017%\u001cXI\u001d:pe~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"\u0001H\"\n\u0005\u0011k\"\u0001B+oSRDqAR \u0002\u0002\u0003\u0007A(A\u0002yIEBa\u0001\u0013\u0001!B\u0013a\u0014\u0001C5t\u000bJ\u0014xN\u001d\u0011\t\u000f)\u0003!\u0019!C\u0005w\u00059\u0011n\u001d+sC\u000e,\u0007B\u0002'\u0001A\u0003%A(\u0001\u0005jgR\u0013\u0018mY3!\u0011\u0015q\u0005\u0001\"\u0011P\u0003)\u0011X-\u00193IK\u0006$WM\u001d\u000b\u0003!N\u00032\u0001H)2\u0013\t\u0011VD\u0001\u0004PaRLwN\u001c\u0005\u0006)6\u0003\r!V\u0001\u0007EV4g-\u001a:\u0011\u0005YKV\"A,\u000b\u0005as\u0011!\u0003;sC:\u001c\bo\u001c:u\u0013\tQvKA\u0007DQ\u0006tg.\u001a7Ck\u001a4WM\u001d\u0005\u00069\u0002!\t%X\u0001\tO\u0016$8)Y2iKR\u0011aL\u0019\t\u0005?\u0002\u0014\u0002$D\u0001\u0007\u0013\t\tgAA\u0003DC\u000eDW\rC\u0003d7\u0002\u0007\u0011'\u0001\u0004iK\u0006$WM\u001d\u0005\u0006K\u0002!\tEZ\u0001\be\u0016\fGmS3z)\r9'\u000e\u001c\t\u00059!\u0014B(\u0003\u0002j;\t1A+\u001e9mKJBQa\u001b3A\u0002E\n\u0011\u0001\u001b\u0005\u0006[\u0012\u0004\r!V\u0001\u0002E\")q\u000e\u0001C!a\u0006q!/Z1e!\u0006\u0014\u0018-\\3uKJ\u001cHcA9sgB\u0019A$\u0015\u001c\t\u000b-t\u0007\u0019A\u0019\t\u000b5t\u0007\u0019A+\t\u000bU\u0004A\u0011\t<\u0002\u0017\r\u0014X-\u0019;f-\u0006dW/\u001a\u000b\u00051]D(\u0010C\u0003li\u0002\u0007\u0011\u0007C\u0003zi\u0002\u0007a'A\u0001q\u0011\u0015YH\u000f1\u0001}\u0003-qW\r\u001f;WKJ\u001c\u0018n\u001c8\u0011\u0005qi\u0018B\u0001@\u001e\u0005\u0011auN\\4\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005)2M]3bi\u0016\u001cVoY2fgN\u0014Vm\u001d9p]N,G\u0003CA\u0003\u0003\u0017\ti!a\u0004\u0011\u0007q\t9!C\u0002\u0002\nu\u0011a!\u00118z%\u00164\u0007\"B6\u0000\u0001\u0004\t\u0004\"B=\u0000\u0001\u0004\t\bBBA\t\u007f\u0002\u0007\u0001$\u0001\u0003qe\u00164\bbBA\u000b\u0001\u0011\u0005\u0013qC\u0001\u001aGJ,\u0017\r^3O_R,\u00050Z2vi\u0016$'+Z:q_:\u001cX\r\u0006\u0005\u0002\u0006\u0005e\u00111DA\u000f\u0011\u0019Y\u00171\u0003a\u0001c!1\u00110a\u0005A\u0002EDq!!\u0005\u0002\u0014\u0001\u0007\u0001\u0004C\u0004\u0002\"\u0001!\t%a\t\u0002-\r\u0014X-\u0019;f\u001d>$X\t_5tiJ+7\u000f]8og\u0016$b!!\u0002\u0002&\u0005\u001d\u0002BB6\u0002 \u0001\u0007\u0011\u0007\u0003\u0004z\u0003?\u0001\r!\u001d\u0005\b\u0003W\u0001A\u0011IA\u0017\u0003E\u0019'/Z1uK\u001e+GOU3ta>t7/\u001a\u000b\t\u0003\u000b\ty#!\r\u00026!11.!\u000bA\u0002EBq!a\r\u0002*\u0001\u0007!#A\u0001l\u0011\u001d\t9$!\u000bA\u0002a\t\u0011A\u001e\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003Y\u0019'/Z1uK6+H\u000e^5HKR\u0014Vm\u001d9p]N,GCBA\u0003\u0003\u007f\t\t\u0005\u0003\u0004l\u0003s\u0001\r!\r\u0005\t\u0003\u0007\nI\u00041\u0001\u0002F\u0005)\u0001/Y5sgB1\u0011qIA'%aq1\u0001HA%\u0013\r\tY%H\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0013\u0011\u000b\u0002\u0004\u001b\u0006\u0004(bAA&;!9\u0011Q\u000b\u0001\u0005B\u0005]\u0013a\u00055b]\u0012dWmQ;ti>l'+Z9vKN$HCCA\u0003\u00033\nY&!\u0018\u0002b!11.a\u0015A\u0002EBa!\\A*\u0001\u0004)\u0006bBA0\u0003'\u0002\rAX\u0001\u0006G\u0006\u001c\u0007.\u001a\u0005\t\u0003G\n\u0019\u00061\u0001\u0002f\u0005\u00191\r\u001e=\u0011\u0007Y\u000b9'C\u0002\u0002j]\u0013Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0004\u0002n\u0001!\t%a\u001c\u0002'\r\u0014X-\u0019;f'R\fGo\u001d*fgB|gn]3\u0015\r\u0005\u0015\u0011\u0011OA:\u0011\u0019Y\u00171\u000ea\u0001c!A\u0011QOA6\u0001\u0004\t9(A\u0003ti\u0006$8\u000f\u0005\u0003\u0002z\u0005uTBAA>\u0015\r\t)HB\u0005\u0005\u0003\u007f\nYHA\u0003Ti\u0006$8\u000fC\u0004\u0002\u0004\u0002!\t%!\"\u0002'\r\u0014X-\u0019;f\u000bJ\u0014xN\u001d*fgB|gn]3\u0015\t\u0005\u0015\u0011q\u0011\u0005\t\u0003\u0013\u000b\t\t1\u0001\u0002\f\u0006\tA\u000f\u0005\u0003\u0002\u000e\u0006ue\u0002BAH\u00033sA!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+S\u0011A\u0002\u001fs_>$h(C\u0001\u001f\u0013\r\tY*H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty*!)\u0003\u0013QC'o\\<bE2,'bAAN;!9\u0011Q\u0015\u0001\u0005R\u0005\u001d\u0016!E4fi>\u0003H/[7ju\u0016$7)Y2iKR)a,!+\u0002,\"11.a)A\u0002EBq!!,\u0002$\u0002\u0007a,A\u0001d\u0011\u001d\t\t\f\u0001C)\u0003g\u000bQc\u0019:fCR,7+\u001a:wKJ,\u0005pY3qi&|g\u000e\u0006\u0005\u00026\u0006u\u0016qYAe!\u0015a\u0002.a.=!\ri\u0013\u0011X\u0005\u0004\u0003w\u0013!a\u0004%piJ{G-\u0012=dKB$\u0018n\u001c8\t\u0011\u0005}\u0016q\u0016a\u0001\u0003\u0003\f\u0011!\u001a\t\u0005\u0003\u001b\u000b\u0019-\u0003\u0003\u0002F\u0006\u0005&!C#yG\u0016\u0004H/[8o\u0011\u0019Y\u0017q\u0016a\u0001!\"1Q.a,A\u0002U;q!!4\u0003\u0011\u000b\ty-A\u0007I_R\u0014v\u000e\u001a#fG>$WM\u001d\t\u0004[\u0005Eg!C\u0001\u0003\t\u0003\u0005\tRAAj'\u001d\t\t.!6\u0002fn\u0001B!a6\u0002b6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.\u0001\u0003mC:<'BAAp\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0018\u0011\u001c\u0002\u0007\u001f\nTWm\u0019;\u0011\u00075\t9/C\u0002\u0002j:\u0011q\u0001T8hO&tw\rC\u0004+\u0003#$\t!!<\u0015\u0005\u0005=\u0007BCAy\u0003#\u0014\r\u0011\"\u0003\u0002t\u0006)Q*Y4jGV\u0011\u0011Q\u001f\t\u00049\u0005]\u0018bAA};\t\u0019\u0011J\u001c;\t\u0013\u0005u\u0018\u0011\u001bQ\u0001\n\u0005U\u0018AB'bO&\u001c\u0007\u0005\u0003\u0006\u0003\u0002\u0005E'\u0019!C\u0005\u0003g\f\u0011BV3sg&|g.\r\u0019\t\u0013\t\u0015\u0011\u0011\u001bQ\u0001\n\u0005U\u0018A\u0003,feNLwN\\\u00191A\u0001")
public class HotRodDecoder
extends AbstractProtocolDecoder<ByteArrayKey, CacheValue>
implements ScalaObject {
    private final EmbeddedCacheManager cacheManager;
    private boolean isError;
    private final boolean isTrace;

    public static final void error(Function0<String> function0, Throwable throwable) {
        HotRodDecoder$.MODULE$.error(function0, throwable);
    }

    public static final void error(Function0<String> function0) {
        HotRodDecoder$.MODULE$.error(function0);
    }

    public static final void warn(Function0<String> function0, Throwable throwable) {
        HotRodDecoder$.MODULE$.warn(function0, throwable);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        HotRodDecoder$.MODULE$.warn(function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        HotRodDecoder$.MODULE$.trace(function0, seq);
    }

    public static final boolean isTraceEnabled() {
        return HotRodDecoder$.MODULE$.isTraceEnabled();
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        HotRodDecoder$.MODULE$.debug(function0, seq);
    }

    public static final boolean isDebugEnabled() {
        return HotRodDecoder$.MODULE$.isDebugEnabled();
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        HotRodDecoder$.MODULE$.info(function0, seq);
    }

    private boolean isError() {
        return this.isError;
    }

    private void isError_$eq(boolean bl) {
        this.isError = bl;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    public Option<HotRodHeader> readHeader(ChannelBuffer buffer) {
        short version;
        long messageId;
        block10: {
            block9: {
                try {
                    short magic = buffer.readUnsignedByte();
                    if (magic == HotRodDecoder$.MODULE$.org$infinispan$server$hotrod$HotRodDecoder$$Magic()) break block9;
                    if (this.isError()) {
                        if (this.isTrace()) {
                            HotRodDecoder$.MODULE$.trace((Function0)new $anonfun$readHeader$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)magic)}));
                        }
                        return None$.MODULE$;
                    }
                    throw new InvalidMagicIdException(new StringBuilder().append((Object)"Error reading magic byte or message id: ").append((Object)BoxesRunTime.boxToShort((short)magic)).toString());
                }
                catch (Exception exception) {
                    this.isError_$eq(true);
                    throw exception;
                }
            }
            messageId = buffer.readUnsignedLong();
            Some exceptionResult1 = null;
            short s = version = buffer.readUnsignedByte();
            if (s != HotRodDecoder$.MODULE$.org$infinispan$server$hotrod$HotRodDecoder$$Version10()) break block10;
            Decoder10$ decoder = Decoder10$.MODULE$;
            HotRodHeader header = decoder.readHeader(buffer, messageId);
            if (this.isTrace()) {
                HotRodDecoder$.MODULE$.trace((Function0)new $anonfun$readHeader$2(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header}));
            }
            this.isError_$eq(false);
            exceptionResult1 = new Some((Object)header);
            return exceptionResult1;
        }
        try {
            throw new UnknownVersionException(new StringBuilder().append((Object)"Unknown version:").append((Object)BoxesRunTime.boxToShort((short)version)).toString(), messageId);
        }
        catch (Exception exception) {
            this.isError_$eq(true);
            throw new RequestParsingException("Unable to parse header", messageId, exception);
        }
        catch (HotRodUnknownOperationException hotRodUnknownOperationException) {
            this.isError_$eq(true);
            throw hotRodUnknownOperationException;
        }
    }

    public Cache<ByteArrayKey, CacheValue> getCache(HotRodHeader header) {
        String cacheName;
        String string = cacheName = header.cacheName();
        String string2 = HotRodServer$.MODULE$.TopologyCacheName();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new CacheException(new StringBuilder().append((Object)"Remote requests are not allowed to topology cache. Do no send remote requests to cache ").append((Object)HotRodServer$.MODULE$.TopologyCacheName()).toString());
        }
        if (cacheName.isEmpty() || this.cacheManager.getCacheNames().contains(cacheName)) {
            return HotRodServer$.MODULE$.getCacheInstance(cacheName, this.cacheManager);
        }
        throw new CacheNotFoundException(new StringBuilder().append((Object)"Cache with name '").append((Object)cacheName).append((Object)"' not found amongst the configured caches").toString());
    }

    public Tuple2<ByteArrayKey, Boolean> readKey(HotRodHeader h, ChannelBuffer b) {
        return new Tuple2((Object)h.decoder().readKey(b), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Option<RequestParameters> readParameters(HotRodHeader h, ChannelBuffer b) {
        return h.decoder().readParameters(h, b);
    }

    public CacheValue createValue(HotRodHeader h, RequestParameters p, long nextVersion) {
        return h.decoder().createValue(p, nextVersion);
    }

    public Object createSuccessResponse(HotRodHeader h, Option<RequestParameters> p, CacheValue prev) {
        return h.decoder().createSuccessResponse(h, prev);
    }

    public Object createNotExecutedResponse(HotRodHeader h, Option<RequestParameters> p, CacheValue prev) {
        return h.decoder().createNotExecutedResponse(h, prev);
    }

    public Object createNotExistResponse(HotRodHeader h, Option<RequestParameters> p) {
        return h.decoder().createNotExistResponse(h);
    }

    public Object createGetResponse(HotRodHeader h, ByteArrayKey k, CacheValue v) {
        return h.decoder().createGetResponse(h, v, h.op());
    }

    public Object createMultiGetResponse(HotRodHeader h, Map<ByteArrayKey, CacheValue> pairs) {
        return null;
    }

    public Object handleCustomRequest(HotRodHeader h, ChannelBuffer b, Cache<ByteArrayKey, CacheValue> cache, ChannelHandlerContext ctx) {
        Object result$1 = h.decoder().handleCustomRequest(h, b, cache);
        if (this.isTrace()) {
            HotRodDecoder$.MODULE$.trace((Function0)new $anonfun$handleCustomRequest$1(this, result$1), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return result$1;
    }

    public Object createStatsResponse(HotRodHeader h, Stats stats) {
        return h.decoder().createStatsResponse(h, stats);
    }

    public Object createErrorResponse(Throwable t) {
        ErrorResponse errorResponse;
        Throwable throwable = t;
        if (throwable instanceof HotRodException) {
            errorResponse = ((HotRodException)throwable).response();
        } else if (throwable instanceof ClosedChannelException) {
            errorResponse = null;
        } else {
            if (throwable == null) {
                throw new MatchError((Object)throwable);
            }
            errorResponse = new ErrorResponse(0L, "", 1, OperationStatus$.MODULE$.ServerError(), 0, throwable.toString());
        }
        return errorResponse;
    }

    public Cache<ByteArrayKey, CacheValue> getOptimizedCache(HotRodHeader h, Cache<ByteArrayKey, CacheValue> c) {
        return h.decoder().getOptimizedCache(h, c);
    }

    public Tuple2<HotRodException, Boolean> createServerException(Exception e, Option<HotRodHeader> h, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof InvalidMagicIdException) {
            tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(0L, "", 1, OperationStatus$.MODULE$.InvalidMagicOrMsgId(), 0, ((InvalidMagicIdException)exception).toString()), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof HotRodUnknownOperationException) {
            HotRodUnknownOperationException hotRodUnknownOperationException;
            HotRodUnknownOperationException h2 = hotRodUnknownOperationException = (HotRodUnknownOperationException)((Object)exception);
            tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(h2.messageId(), "", 1, OperationStatus$.MODULE$.UnknownOperation(), 0, h2.toString()), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof UnknownVersionException) {
            UnknownVersionException unknownVersionException;
            UnknownVersionException u = unknownVersionException = (UnknownVersionException)exception;
            tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(u.messageId(), "", 1, OperationStatus$.MODULE$.UnknownVersion(), 0, u.toString()), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof RequestParsingException) {
            RequestParsingException requestParsingException;
            RequestParsingException r = requestParsingException = (RequestParsingException)exception;
            tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(r.messageId(), "", 1, OperationStatus$.MODULE$.ParseError(), 0, Predef$.MODULE$.augmentString("%s: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r.getMessage(), r.getCause().toString()}))), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            if (exception == null) {
                throw new MatchError((Object)exception);
            }
            tuple2 = new Tuple2((Object)new HotRodException(((HotRodHeader)((Object)h.get())).decoder().createErrorResponse((HotRodHeader)((Object)h.get()), exception), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    public HotRodDecoder(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.isError = false;
        this.isTrace = HotRodDecoder$.MODULE$.isTraceEnabled();
    }
}

