/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers$;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.core.transport.Encoder;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HashDistAwareResponse;
import org.infinispan.server.hotrod.HotRodEncoder$;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.TopologyAwareResponse;
import org.infinispan.server.hotrod.TopologyView;
import org.infinispan.util.ByteArrayKey;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003\u001b!{GOU8e\u000b:\u001cw\u000eZ3s\u0015\t\u0019A!\u0001\u0004i_R\u0014x\u000e\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\u000b\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012!\u0003;sC:\u001c\bo\u001c:u\u0015\t\tB!\u0001\u0003d_J,\u0017BA\n\u000f\u0005\u001d)enY8eKJ\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u00111bU2bY\u0006|%M[3di\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0007dC\u000eDW-T1oC\u001e,'\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u00059Q.\u00198bO\u0016\u0014\u0018BA\u0011\u001f\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\"!J\u0014\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000bm\u0011\u0003\u0019\u0001\u000f\t\u0011%\u0002\u0001R1A\u0005\n)\n1\"[:DYV\u001cH/\u001a:fIV\t1\u0006\u0005\u0002\u0016Y%\u0011QF\u0006\u0002\b\u0005>|G.Z1o\u0011!y\u0003\u0001#A!B\u0013Y\u0013\u0001D5t\u00072,8\u000f^3sK\u0012\u0004\u0003\u0002C\u0019\u0001\u0011\u000b\u0007I\u0011\u0002\u001a\u0002\u001bQ|\u0007o\u001c7pOf\u001c\u0015m\u00195f+\u0005\u0019\u0004\u0003\u0002\u001b6oyj\u0011AB\u0005\u0003m\u0019\u0011QaQ1dQ\u0016\u0004\"\u0001O\u001e\u000f\u0005UI\u0014B\u0001\u001e\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i2\u0002C\u0001\u0014@\u0013\t\u0001%A\u0001\u0007U_B|Gn\\4z-&,w\u000f\u0003\u0005C\u0001!\u0005\t\u0015)\u00034\u00039!x\u000e]8m_\u001eL8)Y2iK\u0002BQ\u0001\u0012\u0001\u0005B\u0015\u000ba!\u001a8d_\u0012,G\u0003\u0002$J\u001dN\u0003\"!F$\n\u0005!3\"AB!osJ+g\rC\u0003K\u0007\u0002\u00071*A\u0002dib\u0004\"!\u0004'\n\u00055s!!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006\u001f\u000e\u0003\r\u0001U\u0001\bG\"\fgN\\3m!\ti\u0011+\u0003\u0002S\u001d\t91\t[1o]\u0016d\u0007\"\u0002+D\u0001\u00041\u0015aA7tO\"9a\u000b\u0001b\u0001\n\u00039\u0016!\b#F\r\u0006+F\nV0I\u0003NCuLR+O\u0007RKuJT0W\u000bJ\u001b\u0016j\u0014(\u0016\u0003a\u0003\"!F-\n\u0005i3\"\u0001\u0002\"zi\u0016Da\u0001\u0018\u0001!\u0002\u0013A\u0016A\b#F\r\u0006+F\nV0I\u0003NCuLR+O\u0007RKuJT0W\u000bJ\u001b\u0016j\u0014(!\u0011\u0015q\u0006\u0001\"\u0003`\u0003M9W\r\u001e+pa>dwnZ=SKN\u0004xN\\:f)\t\u00017\r\u0005\u0002'C&\u0011!M\u0001\u0002\u0019\u0003\n\u001cHO]1diR{\u0007o\u001c7pOf\u0014Vm\u001d9p]N,\u0007\"\u00023^\u0001\u0004)\u0017!\u0001:\u0011\u0005\u00192\u0017BA4\u0003\u0005!\u0011Vm\u001d9p]N,\u0007\"B5\u0001\t\u0013Q\u0017aC<sSR,\u0007*Z1eKJ$Ba\u001b8pcB\u0011Q\u0002\\\u0005\u0003[:\u0011Qb\u00115b]:,GNQ;gM\u0016\u0014\b\"\u00023i\u0001\u0004)\u0007\"\u00029i\u0001\u0004Y\u0013aB5t)J\f7-\u001a\u0005\u0006e\"\u0004\r\u0001Y\u0001\ri>\u0004x\u000e\\8hsJ+7\u000f\u001d\u0005\u0006i\u0002!I!^\u0001\u0014oJLG/\u001a+pa>dwnZ=IK\u0006$WM\u001d\u000b\u0006mft\u0018\u0011\u0001\t\u0003+]L!\u0001\u001f\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006uN\u0004\ra_\u0001\u0002iB\u0011a\u0005`\u0005\u0003{\n\u0011Q\u0003V8q_2|w-_!xCJ,'+Z:q_:\u001cX\rC\u0003\u0000g\u0002\u00071.\u0001\u0004ck\u001a4WM\u001d\u0005\u0006aN\u0004\ra\u000b\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0003]9(/\u001b;f\u0011\u0006\u001c\b\u000eV8q_2|w-\u001f%fC\u0012,'\u000fF\u0004w\u0003\u0013\tY!!\u0004\t\ri\f\u0019\u00011\u0001|\u0011\u0019y\u00181\u0001a\u0001W\"1\u0001/a\u0001A\u0002-Bq!!\u0002\u0001\t\u0013\t\t\u0002F\u0005w\u0003'\ti\"a\b\u0002\"!A\u0011QCA\b\u0001\u0004\t9\"A\u0001i!\r1\u0013\u0011D\u0005\u0004\u00037\u0011!!\u0006%bg\"$\u0015n\u001d;Bo\u0006\u0014XMU3ta>t7/\u001a\u0005\u0007\u007f\u0006=\u0001\u0019A6\t\r\u0011\fy\u00011\u0001f\u0011\u0019\u0001\u0018q\u0002a\u0001W\u001d9\u0011Q\u0005\u0002\t\u0006\u0005\u001d\u0012!\u0004%piJ{G-\u00128d_\u0012,'\u000fE\u0002'\u0003S1\u0011\"\u0001\u0002\u0005\u0002\u0003E)!a\u000b\u0014\u000f\u0005%\u0012QFA\u001f)A!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001\u00027b]\u001eT!!a\u000e\u0002\t)\fg/Y\u0005\u0005\u0003w\t\tD\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u007f\t\t%D\u0001\u0011\u0013\r\t\u0019\u0005\u0005\u0002\b\u0019><w-\u001b8h\u0011\u001d\u0019\u0013\u0011\u0006C\u0001\u0003\u000f\"\"!a\n\t\u0015\u0005-\u0013\u0011\u0006b\u0001\n\u0013\ti%A\u0003NC\u001eL7-\u0006\u0002\u0002PA\u0019Q#!\u0015\n\u0007\u0005McCA\u0002J]RD\u0011\"a\u0016\u0002*\u0001\u0006I!a\u0014\u0002\r5\u000bw-[2!\u0001")
public class HotRodEncoder
extends Encoder
implements ScalaObject {
    private final EmbeddedCacheManager cacheManager;
    private boolean isClustered;
    private Cache<String, TopologyView> topologyCache;
    private final byte DEFAULT_HASH_FUNCTION_VERSION;
    public volatile int bitmap$0;

    public static final void error(Function0<String> function0, Throwable throwable) {
        HotRodEncoder$.MODULE$.error(function0, throwable);
    }

    public static final void error(Function0<String> function0) {
        HotRodEncoder$.MODULE$.error(function0);
    }

    public static final void warn(Function0<String> function0, Throwable throwable) {
        HotRodEncoder$.MODULE$.warn(function0, throwable);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        HotRodEncoder$.MODULE$.warn(function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        HotRodEncoder$.MODULE$.trace(function0, seq);
    }

    public static final boolean isTraceEnabled() {
        return HotRodEncoder$.MODULE$.isTraceEnabled();
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        HotRodEncoder$.MODULE$.debug(function0, seq);
    }

    public static final boolean isDebugEnabled() {
        return HotRodEncoder$.MODULE$.isDebugEnabled();
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        HotRodEncoder$.MODULE$.info(function0, seq);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isClustered() {
        if ((this.bitmap$0 & 1) != 0) return this.isClustered;
        HotRodEncoder hotRodEncoder = this;
        synchronized (hotRodEncoder) {
            if ((this.bitmap$0 & 1) == 0) {
                this.isClustered = this.cacheManager.getGlobalConfiguration().getTransportClass() != null;
                this.bitmap$0 |= 1;
            }
            return this.isClustered;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cache<String, TopologyView> topologyCache() {
        if ((this.bitmap$0 & 4) != 0) return this.topologyCache;
        HotRodEncoder hotRodEncoder = this;
        synchronized (hotRodEncoder) {
            if ((this.bitmap$0 & 4) == 0) {
                this.topologyCache = this.isClustered() ? this.cacheManager.getCache(HotRodServer$.MODULE$.TopologyCacheName()) : null;
                this.bitmap$0 |= 4;
            }
            return this.topologyCache;
        }
    }

    public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) {
        Object object;
        boolean isTrace = HotRodEncoder$.MODULE$.isTraceEnabled();
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$encode$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg}));
        }
        if ((object = msg) instanceof Response) {
            Response response;
            Response r = response = (Response)object;
            ChannelBuffer buffer$1 = this.writeHeader(r, isTrace, this.getTopologyResponse(r));
            Object object2 = msg;
            if (object2 instanceof ResponseWithPrevious) {
                ResponseWithPrevious responseWithPrevious;
                ResponseWithPrevious r2 = responseWithPrevious = (ResponseWithPrevious)object2;
                Option<byte[]> option = r2.previous();
                None$ none$ = None$.MODULE$;
                if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
                    buffer$1.writeUnsignedInt(0);
                } else {
                    buffer$1.writeRangedBytes((byte[])r2.previous().get());
                }
            } else if (object2 instanceof StatsResponse) {
                StatsResponse statsResponse;
                StatsResponse s = statsResponse = (StatsResponse)object2;
                buffer$1.writeUnsignedInt(s.stats().size());
                s.stats().foreach((Function1)new $anonfun$encode$2(this, buffer$1));
            } else if (object2 instanceof GetWithVersionResponse) {
                GetWithVersionResponse getWithVersionResponse;
                GetWithVersionResponse g = getWithVersionResponse = (GetWithVersionResponse)object2;
                Enumeration.Value value = g.status();
                Enumeration.Value value2 = OperationStatus$.MODULE$.Success();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    buffer$1.writeLong(g.version());
                    buffer$1.writeRangedBytes((byte[])g.data().get());
                }
            } else if (object2 instanceof BulkGetResponse) {
                BulkGetResponse bulkGetResponse;
                BulkGetResponse g = bulkGetResponse = (BulkGetResponse)object2;
                if (isTrace) {
                    HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$encode$3(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                Enumeration.Value value = g.status();
                Enumeration.Value value3 = OperationStatus$.MODULE$.Success();
                if (!(value != null ? !value.equals(value3) : value3 != null)) {
                    Cache<ByteArrayKey, CacheValue> cache = HotRodServer$.MODULE$.getCacheInstance(g.cacheName(), this.cacheManager);
                    Iterator iterator = JavaConversions$.MODULE$.asIterator(cache.entrySet().iterator());
                    if (g.count() != 0) {
                        if (isTrace) {
                            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$encode$4(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)g.count())}));
                        }
                        iterator = iterator.take(g.count());
                    }
                    iterator.foreach((Function1)new $anonfun$encode$5(this, buffer$1));
                    buffer$1.writeByte((byte)0);
                }
            } else if (object2 instanceof GetResponse) {
                GetResponse getResponse;
                GetResponse g = getResponse = (GetResponse)object2;
                Enumeration.Value value = g.status();
                Enumeration.Value value4 = OperationStatus$.MODULE$.Success();
                if (!(value != null ? !value.equals(value4) : value4 != null)) {
                    buffer$1.writeRangedBytes((byte[])g.data().get());
                }
            } else if (object2 instanceof ErrorResponse) {
                buffer$1.writeString(((ErrorResponse)object2).msg());
            } else if (buffer$1 == null) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Response received is unknown: ").append(msg).toString());
            }
            return buffer$1;
        }
        throw new MatchError(object);
    }

    public byte DEFAULT_HASH_FUNCTION_VERSION() {
        return this.DEFAULT_HASH_FUNCTION_VERSION;
    }

    private AbstractTopologyResponse getTopologyResponse(Response r) {
        AbstractTopologyResponse abstractTopologyResponse;
        if (this.isClustered()) {
            short s = r.clientIntel();
            switch (s) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToShort((short)s));
                }
                case 2: 
                case 3: {
                    TopologyView currentTopologyView = (TopologyView)this.topologyCache().get("view");
                    if (r.topologyId() != currentTopologyView.topologyId()) {
                        Cache<ByteArrayKey, CacheValue> cache = HotRodServer$.MODULE$.getCacheInstance(r.cacheName(), this.cacheManager);
                        Configuration config = cache.getConfiguration();
                        if (r.clientIntel() != 2 && config.getCacheMode().isDistributed()) {
                            int hashSpace = cache.getAdvancedCache().getDistributionManager().getConsistentHash().getHashSpace();
                            abstractTopologyResponse = new HashDistAwareResponse(new TopologyView(currentTopologyView.topologyId(), currentTopologyView.members()), config.getNumOwners(), this.DEFAULT_HASH_FUNCTION_VERSION(), hashSpace);
                            break;
                        }
                        abstractTopologyResponse = new TopologyAwareResponse(new TopologyView(currentTopologyView.topologyId(), currentTopologyView.members()));
                        break;
                    }
                    abstractTopologyResponse = null;
                    break;
                }
                case 1: {
                    abstractTopologyResponse = null;
                    break;
                }
            }
        } else {
            abstractTopologyResponse = null;
        }
        return abstractTopologyResponse;
    }

    private ChannelBuffer writeHeader(Response r, boolean isTrace, AbstractTopologyResponse topologyResp) {
        AbstractTopologyResponse abstractTopologyResponse;
        block8: {
            ChannelBuffer buffer;
            block6: {
                block7: {
                    TopologyAwareResponse topologyAwareResponse;
                    block5: {
                        buffer = ChannelBuffers$.MODULE$.dynamicBuffer();
                        buffer.writeByte(Predef$.MODULE$.int2Integer(HotRodEncoder$.MODULE$.org$infinispan$server$hotrod$HotRodEncoder$$Magic()).byteValue());
                        buffer.writeUnsignedLong(r.messageId());
                        buffer.writeByte(Predef$.MODULE$.int2Integer(r.operation().id()).byteValue());
                        buffer.writeByte(Predef$.MODULE$.int2Integer(r.status().id()).byteValue());
                        if (topologyResp != null) break block5;
                        buffer.writeByte((byte)0);
                        break block6;
                    }
                    abstractTopologyResponse = topologyResp;
                    if (!(abstractTopologyResponse instanceof TopologyAwareResponse)) break block7;
                    TopologyAwareResponse t = topologyAwareResponse = (TopologyAwareResponse)abstractTopologyResponse;
                    if (r.clientIntel() == 2) {
                        this.writeTopologyHeader(t, buffer, isTrace);
                    } else {
                        this.writeHashTopologyHeader(t, buffer, isTrace);
                    }
                    break block6;
                }
                if (!(abstractTopologyResponse instanceof HashDistAwareResponse)) break block8;
                this.writeHashTopologyHeader((HashDistAwareResponse)abstractTopologyResponse, buffer, r, isTrace);
            }
            return buffer;
        }
        throw new MatchError((Object)abstractTopologyResponse);
    }

    private void writeTopologyHeader(TopologyAwareResponse t, ChannelBuffer buffer$2, boolean isTrace) {
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$writeTopologyHeader$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
        }
        buffer$2.writeByte((byte)1);
        buffer$2.writeUnsignedInt(t.view().topologyId());
        buffer$2.writeUnsignedInt(t.view().members().size());
        t.view().members().foreach((Function1)new $anonfun$writeTopologyHeader$2(this, buffer$2));
    }

    private void writeHashTopologyHeader(TopologyAwareResponse t, ChannelBuffer buffer$4, boolean isTrace) {
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$writeHashTopologyHeader$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
        }
        buffer$4.writeByte((byte)1);
        buffer$4.writeUnsignedInt(t.view().topologyId());
        buffer$4.writeUnsignedShort(0);
        buffer$4.writeByte((byte)0);
        buffer$4.writeUnsignedInt(0);
        buffer$4.writeUnsignedInt(t.view().members().size());
        t.view().members().foreach((Function1)new $anonfun$writeHashTopologyHeader$2(this, buffer$4));
    }

    private void writeHashTopologyHeader(HashDistAwareResponse h, ChannelBuffer buffer$3, Response r$1, boolean isTrace) {
        if (isTrace) {
            HotRodEncoder$.MODULE$.trace((Function0)new $anonfun$writeHashTopologyHeader$3(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h}));
        }
        buffer$3.writeByte((byte)1);
        buffer$3.writeUnsignedInt(h.view().topologyId());
        buffer$3.writeUnsignedShort(h.numOwners());
        buffer$3.writeByte(h.hashFunction());
        buffer$3.writeUnsignedInt(h.hashSpace());
        buffer$3.writeUnsignedInt(h.view().members().size());
        h.view().members().foreach((Function1)new $anonfun$writeHashTopologyHeader$4(this, buffer$3, r$1));
    }

    public HotRodEncoder(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.DEFAULT_HASH_FUNCTION_VERSION = (byte)2;
    }
}

