/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;

@BuiltBy(value=HotRodServerConfigurationBuilder.class)
public class HotRodServerConfiguration
extends ProtocolServerConfiguration {
    public static final String TOPOLOGY_CACHE_NAME_PREFIX = "___hotRodTopologyCache";
    private final String proxyHost;
    private final int proxyPort;
    private final String topologyCacheName;
    private final long topologyLockTimeout;
    private final long topologyReplTimeout;
    private final boolean topologyStateTransfer;

    HotRodServerConfiguration(String proxyHost, int proxyPort, long topologyLockTimeout, long topologyReplTimeout, boolean topologyStateTransfer, String name, String host, int port, int idleTimeout, int recvBufSize, int sendBufSize, SslConfiguration ssl, boolean tcpNoDelay, int workerThreads) {
        super(name, host, port, idleTimeout, recvBufSize, sendBufSize, ssl, tcpNoDelay, workerThreads);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.topologyCacheName = TOPOLOGY_CACHE_NAME_PREFIX + (name.length() > 0 ? "_" + name : name);
        this.topologyLockTimeout = topologyLockTimeout;
        this.topologyReplTimeout = topologyReplTimeout;
        this.topologyStateTransfer = topologyStateTransfer;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public int proxyPort() {
        return this.proxyPort;
    }

    public String topologyCacheName() {
        return this.topologyCacheName;
    }

    public long topologyLockTimeout() {
        return this.topologyLockTimeout;
    }

    public long topologyReplTimeout() {
        return this.topologyReplTimeout;
    }

    public boolean topologyStateTransfer() {
        return this.topologyStateTransfer;
    }

    public String toString() {
        return "HotRodServerConfiguration [proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", topologyLockTimeout=" + this.topologyLockTimeout + ", topologyReplTimeout=" + this.topologyReplTimeout + ", topologyStateTransfer=" + this.topologyStateTransfer + ", " + super.toString() + "]";
    }
}

