package org.infinispan.server.hotrod;
/**
 * This class represents the work to be done by a decoder of a particular Hot Rod protocol version.
 * <p>
 * @author Galder Zamarre&#x00f1;o
 * @since 4.1
 */
public abstract class AbstractVersionedDecoder {
  public   AbstractVersionedDecoder () { throw new RuntimeException(); }
  /**
   * Having read the message's Id, read the rest of Hot Rod header from the given buffer and return it.
   */
  public abstract  boolean readHeader (org.jboss.netty.buffer.ChannelBuffer buffer, byte version, long messageId, org.infinispan.server.hotrod.HotRodHeader header) ;
  /**
   * Read the key to operate on from the message.
   */
  public abstract  scala.Tuple2<byte[], java.lang.Object> readKey (org.infinispan.server.hotrod.HotRodHeader header, org.jboss.netty.buffer.ChannelBuffer buffer) ;
  /**
   * Read the parameters of the operation, if present.
   */
  public abstract  scala.Tuple2<org.infinispan.server.core.RequestParameters, java.lang.Object> readParameters (org.infinispan.server.hotrod.HotRodHeader header, org.jboss.netty.buffer.ChannelBuffer buffer) ;
  /**
   * Create a successful response.
   */
  public abstract  java.lang.Object createSuccessResponse (org.infinispan.server.hotrod.HotRodHeader header, byte[] prev) ;
  /**
   * Create a response indicating the the operation could not be executed.
   */
  public abstract  java.lang.Object createNotExecutedResponse (org.infinispan.server.hotrod.HotRodHeader header, byte[] prev) ;
  /**
   * Create a response indicating that the key, which the message tried to operate on, did not exist.
   */
  public abstract  java.lang.Object createNotExistResponse (org.infinispan.server.hotrod.HotRodHeader header) ;
  /**
   * Create a response for get a request.
   */
  public abstract  java.lang.Object createGetResponse (org.infinispan.server.hotrod.HotRodHeader header, org.infinispan.container.entries.CacheEntry entry) ;
  /**
   * Handle a protocol specific header reading.
   */
  public abstract  java.lang.Object customReadHeader (org.infinispan.server.hotrod.HotRodHeader header, org.jboss.netty.buffer.ChannelBuffer buffer, org.infinispan.AdvancedCache<byte[], byte[]> cache) ;
  /**
   * Handle a protocol specific key reading.
   */
  public abstract  java.lang.Object customReadKey (org.infinispan.server.hotrod.HotRodHeader header, org.jboss.netty.buffer.ChannelBuffer buffer, org.infinispan.AdvancedCache<byte[], byte[]> cache, scala.collection.Seq<org.infinispan.server.core.QueryFacade> queryFacades) ;
  /**
   * Handle a protocol specific value reading.
   */
  public abstract  java.lang.Object customReadValue (org.infinispan.server.hotrod.HotRodHeader header, org.jboss.netty.buffer.ChannelBuffer buffer, org.infinispan.AdvancedCache<byte[], byte[]> cache) ;
  /**
   * Create a response for the stats command.
   */
  public abstract  java.lang.Object createStatsResponse (org.infinispan.server.hotrod.HotRodHeader header, org.infinispan.stats.Stats stats, org.infinispan.server.core.transport.NettyTransport t) ;
  /**
   * Create an error response based on the Throwable instance received.
   */
  public abstract  org.infinispan.server.hotrod.ErrorResponse createErrorResponse (org.infinispan.server.hotrod.HotRodHeader header, java.lang.Throwable t) ;
  /**
   * Get an optimized cache instance depending on the operation parameters.
   */
  public abstract  org.infinispan.AdvancedCache<byte[], byte[]> getOptimizedCache (org.infinispan.server.hotrod.HotRodHeader h, org.infinispan.AdvancedCache<byte[], byte[]> c) ;
}
