/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;

@BuiltBy(value=HotRodServerConfigurationBuilder.class)
public class HotRodServerConfiguration
extends ProtocolServerConfiguration {
    public static final String TOPOLOGY_CACHE_NAME_PREFIX = "___hotRodTopologyCache";
    private final String proxyHost;
    private final int proxyPort;
    private final String topologyCacheName;
    private final long topologyLockTimeout;
    private final long topologyReplTimeout;
    private final boolean topologyAwaitInitialTransfer;
    private final boolean topologyStateTransfer;
    private final AuthenticationConfiguration authentication;
    private final Class<? extends Marshaller> marshallerClass;

    HotRodServerConfiguration(String defaultCacheName, String proxyHost, int proxyPort, long topologyLockTimeout, long topologyReplTimeout, boolean topologyAwaitInitialTransfer, boolean topologyStateTransfer, String name, String host, int port, int idleTimeout, int recvBufSize, int sendBufSize, SslConfiguration ssl, boolean tcpNoDelay, int workerThreads, AuthenticationConfiguration authentication, Class<? extends Marshaller> marshallerClass) {
        super(defaultCacheName, name, host, port, idleTimeout, recvBufSize, sendBufSize, ssl, tcpNoDelay, workerThreads);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.topologyCacheName = TOPOLOGY_CACHE_NAME_PREFIX + (name.length() > 0 ? "_" + name : name);
        this.topologyLockTimeout = topologyLockTimeout;
        this.topologyReplTimeout = topologyReplTimeout;
        this.topologyStateTransfer = topologyStateTransfer;
        this.topologyAwaitInitialTransfer = topologyAwaitInitialTransfer;
        this.authentication = authentication;
        this.marshallerClass = marshallerClass;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public int proxyPort() {
        return this.proxyPort;
    }

    public String topologyCacheName() {
        return this.topologyCacheName;
    }

    public long topologyLockTimeout() {
        return this.topologyLockTimeout;
    }

    public long topologyReplTimeout() {
        return this.topologyReplTimeout;
    }

    public boolean topologyAwaitInitialTransfer() {
        return this.topologyAwaitInitialTransfer;
    }

    public boolean topologyStateTransfer() {
        return this.topologyStateTransfer;
    }

    public AuthenticationConfiguration authentication() {
        return this.authentication;
    }

    public Class<? extends Marshaller> marshallerClass() {
        return this.marshallerClass;
    }

    public String toString() {
        return "HotRodServerConfiguration [proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", topologyCacheName=" + this.topologyCacheName + ", topologyLockTimeout=" + this.topologyLockTimeout + ", topologyReplTimeout=" + this.topologyReplTimeout + ", topologyAwaitInitialTransfer=" + this.topologyAwaitInitialTransfer + ", topologyStateTransfer=" + this.topologyStateTransfer + ", authentication=" + this.authentication + ", marshallerClass=" + this.marshallerClass + ", " + super.toString() + "]";
    }
}

