/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Immutables;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CompatibilityModeConfiguration;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.server.hotrod.HotRodTypeConverter;

public final class BulkUtil {
    public static final int DEFAULT_SCOPE = 0;
    public static final int GLOBAL_SCOPE = 1;
    public static final int LOCAL_SCOPE = 2;

    public static Set<byte[]> getAllKeys(Cache<byte[], ?> cache, int scope) {
        boolean keysAreLocal;
        CacheMode cacheMode = cache.getAdvancedCache().getCacheConfiguration().clustering().cacheMode();
        boolean bl = keysAreLocal = !cacheMode.isClustered() || cacheMode.isReplicated();
        if (keysAreLocal || scope == 2) {
            return cache.keySet();
        }
        MapReduceTask task = new MapReduceTask(cache).mappedWith(new KeyMapper()).reducedWith(new KeyReducer());
        return (Set)task.execute(BulkUtil.createCollator(cache));
    }

    private static Collator<byte[], Object, Set<byte[]>> createCollator(Cache<byte[], ?> cache) {
        CompatibilityModeConfiguration compatibility = cache.getCacheConfiguration().compatibility();
        boolean enabled = compatibility.enabled();
        return enabled ? new CompatibilityCollator(compatibility.marshaller()) : new KeysCollator();
    }

    private static class CompatibilityCollator<K>
    implements Collator<K, Object, Set<K>> {
        private final HotRodTypeConverter converter = new HotRodTypeConverter();

        private CompatibilityCollator(Marshaller compatibilityMarshaller) {
            if (compatibilityMarshaller != null) {
                this.converter.setMarshaller(compatibilityMarshaller);
            }
        }

        public Set<K> collate(Map<K, Object> reducedResults) {
            Set<K> keySet = reducedResults.keySet();
            HashSet<byte[]> backingSet = new HashSet<byte[]>(keySet.size());
            for (K key : keySet) {
                backingSet.add(this.converter.unboxKey(key));
            }
            return Immutables.immutableSetWrap(backingSet);
        }
    }

    private static class KeysCollator<K>
    implements Collator<K, Object, Set<K>> {
        private KeysCollator() {
        }

        public Set<K> collate(Map<K, Object> reducedResults) {
            return reducedResults.keySet();
        }
    }

    private static class KeyReducer<K>
    implements Reducer<K, Object> {
        private static final long serialVersionUID = -8199097945001793869L;

        private KeyReducer() {
        }

        public Object reduce(K reducedKey, Iterator<Object> iter) {
            return null;
        }
    }

    private static class KeyMapper<K>
    implements Mapper<K, Object, K, Object> {
        private static final long serialVersionUID = -5054573988280497412L;

        private KeyMapper() {
        }

        public void map(K key, Object value, Collector<K, Object> collector) {
            collector.emit(key, null);
        }
    }
}

