/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.server.core.ServerConstants;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.ExtendedByteBuf$;
import org.infinispan.server.hotrod.AbstractVersionedDecoder;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.ExpirationParam;
import org.infinispan.server.hotrod.HotRodException;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.MissingFactoryException;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.RequestParameters;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.UnknownVersionException;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.logging.Log$class;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001B\u0001\u0003\u0001-\u0011!cQ1dQ\u0016$UmY8eK\u000e{g\u000e^3yi*\u00111\u0001B\u0001\u0007Q>$(o\u001c3\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005Q\u0011N\u001c4j]&\u001c\b/\u00198\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0007\u00131A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\t\r|'/Z\u0005\u0003/Q\u0011qbU3sm\u0016\u00148i\u001c8ti\u0006tGo\u001d\t\u00033qi\u0011A\u0007\u0006\u00037\t\tq\u0001\\8hO&tw-\u0003\u0002\u001e5\t\u0019Aj\\4\t\u0011\u0015\u0001!\u0011!Q\u0001\n}\u0001\"\u0001I\u0011\u000e\u0003\tI!A\t\u0002\u0003\u0019!{GOU8e'\u0016\u0014h/\u001a:\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002!\u0001!)Qa\ta\u0001?\u0015!\u0011\u0006\u0001\u0001+\u00055\u0011\u0015\u0010^3t%\u0016\u001c\bo\u001c8tKB!QbK\u00175\u0013\tacBA\u0005Gk:\u001cG/[8ocA\u0011a&\r\b\u0003A=J!\u0001\r\u0002\u0002\u000fA\f7m[1hK&\u0011!g\r\u0002\u0006\u0005f$Xm\u001d\u0006\u0003a\t\u0001\"\u0001I\u001b\n\u0005Y\u0012!\u0001\u0003*fgB|gn]3\t\u000fa\u0002!\u0019!C\u0001s\u00059\u0011n\u001d+sC\u000e,W#\u0001\u001e\u0011\u00055Y\u0014B\u0001\u001f\u000f\u0005\u001d\u0011un\u001c7fC:DaA\u0010\u0001!\u0002\u0013Q\u0014\u0001C5t)J\f7-\u001a\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001s\u00059\u0011n]#se>\u0014\bb\u0002\"\u0001\u0001\u0004%\taQ\u0001\fSN,%O]8s?\u0012*\u0017\u000f\u0006\u0002E\u000fB\u0011Q\"R\u0005\u0003\r:\u0011A!\u00168ji\"9\u0001*QA\u0001\u0002\u0004Q\u0014a\u0001=%c!1!\n\u0001Q!\ni\n\u0001\"[:FeJ|'\u000f\t\u0005\n\u0019\u0002\u0001\r\u00111A\u0005\u00025\u000bq\u0001Z3d_\u0012,'/F\u0001O!\t\u0001s*\u0003\u0002Q\u0005\tA\u0012IY:ue\u0006\u001cGOV3sg&|g.\u001a3EK\u000e|G-\u001a:\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0016a\u00033fG>$WM]0%KF$\"\u0001\u0012+\t\u000f!\u000b\u0016\u0011!a\u0001\u001d\"1a\u000b\u0001Q!\n9\u000b\u0001\u0002Z3d_\u0012,'\u000f\t\u0005\n1\u0002\u0001\r\u00111A\u0005\u0002e\u000ba\u0001[3bI\u0016\u0014X#\u0001.\u0011\u0005\u0001Z\u0016B\u0001/\u0003\u00051Au\u000e\u001e*pI\"+\u0017\rZ3s\u0011%q\u0006\u00011AA\u0002\u0013\u0005q,\u0001\u0006iK\u0006$WM]0%KF$\"\u0001\u00121\t\u000f!k\u0016\u0011!a\u00015\"1!\r\u0001Q!\ni\u000bq\u0001[3bI\u0016\u0014\b\u0005C\u0005e\u0001\u0001\u0007\t\u0019!C\u0001K\u0006)1-Y2iKV\ta\r\u0005\u0003hQ6jS\"\u0001\u0004\n\u0005%4!!D!em\u0006t7-\u001a3DC\u000eDW\rC\u0005l\u0001\u0001\u0007\t\u0019!C\u0001Y\u0006I1-Y2iK~#S-\u001d\u000b\u0003\t6Dq\u0001\u00136\u0002\u0002\u0003\u0007a\r\u0003\u0004p\u0001\u0001\u0006KAZ\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0003\u0011\u0018a\u00053fM\u0006,H\u000e\u001e'jM\u0016\u001c\b/\u00198US6,W#A:\u0011\u00055!\u0018BA;\u000f\u0005\u0011auN\\4\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0003A\u0018a\u00063fM\u0006,H\u000e\u001e'jM\u0016\u001c\b/\u00198US6,w\fJ3r)\t!\u0015\u0010C\u0004Im\u0006\u0005\t\u0019A:\t\rm\u0004\u0001\u0015)\u0003t\u0003Q!WMZ1vYRd\u0015NZ3ta\u0006tG+[7fA!IQ\u0010\u0001a\u0001\u0002\u0004%\tA]\u0001\u0013I\u00164\u0017-\u001e7u\u001b\u0006D\u0018\n\u001a7f)&lW\r\u0003\u0006\u0000\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003\ta\u0003Z3gCVdG/T1y\u0013\u0012dW\rV5nK~#S-\u001d\u000b\u0004\t\u0006\r\u0001b\u0002%\u007f\u0003\u0003\u0005\ra\u001d\u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003t\u0003M!WMZ1vYRl\u0015\r_%eY\u0016$\u0016.\\3!\u0011-\tY\u0001\u0001a\u0001\u0002\u0004%\t!!\u0004\u0002\u0007-,\u00170F\u0001.\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%\t!a\u0005\u0002\u000f-,\u0017p\u0018\u0013fcR\u0019A)!\u0006\t\u0011!\u000by!!AA\u00025Bq!!\u0007\u0001A\u0003&Q&\u0001\u0003lKf\u0004\u0003bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001b\t\u0001B]1x-\u0006dW/\u001a\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019#\u0001\u0007sC^4\u0016\r\\;f?\u0012*\u0017\u000fF\u0002E\u0003KA\u0001\u0002SA\u0010\u0003\u0003\u0005\r!\f\u0005\b\u0003S\u0001\u0001\u0015)\u0003.\u0003%\u0011\u0018m\u001e,bYV,\u0007\u0005C\u0006\u0002.\u0001\u0001\r\u00111A\u0005\u0002\u0005=\u0012A\u00029be\u0006l7/\u0006\u0002\u00022A\u0019\u0001%a\r\n\u0007\u0005U\"AA\tSKF,Xm\u001d;QCJ\fW.\u001a;feND1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002<\u0005Q\u0001/\u0019:b[N|F%Z9\u0015\u0007\u0011\u000bi\u0004C\u0005I\u0003o\t\t\u00111\u0001\u00022!A\u0011\u0011\t\u0001!B\u0013\t\t$A\u0004qCJ\fWn\u001d\u0011\t\u0017\u0005\u0015\u0003\u00011AA\u0002\u0013\u0005\u0011qI\u0001\naV$\u0018\t\u001c7NCB,\"!!\u0013\u0011\r\u0005-\u0013QK\u0017.\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001B;uS2T!!a\u0015\u0002\t)\fg/Y\u0005\u0005\u0003/\niEA\u0002NCBD1\"a\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002^\u0005i\u0001/\u001e;BY2l\u0015\r]0%KF$2\u0001RA0\u0011%A\u0015\u0011LA\u0001\u0002\u0004\tI\u0005\u0003\u0005\u0002d\u0001\u0001\u000b\u0015BA%\u0003)\u0001X\u000f^!mY6\u000b\u0007\u000f\t\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0003\tI'A\u0005hKR\fE\u000e\\*fiV\u0011\u00111\u000e\t\u0006\u0003\u0017\ni'L\u0005\u0005\u0003_\niEA\u0002TKRD1\"a\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002v\u0005iq-\u001a;BY2\u001cV\r^0%KF$2\u0001RA<\u0011%A\u0015\u0011OA\u0001\u0002\u0004\tY\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0015BA6\u0003)9W\r^!mYN+G\u000f\t\u0005\b\u0003\u007f\u0002A\u0011AAA\u0003-\u0011Xm]3u!\u0006\u0014\u0018-\\:\u0015\u0003\u0011Cq!!\"\u0001\t\u0003\t9)A\nde\u0016\fG/Z#se>\u0014(+Z:q_:\u001cX\rF\u0002\r\u0003\u0013C\u0001\"a#\u0002\u0004\u0002\u0007\u0011QR\u0001\u0002iB!\u0011qRAO\u001d\u0011\t\t*a'\u000f\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&\u000b\u0003\u0019a$o\\8u}%\tq\"\u0003\u00021\u001d%!\u0011qTAQ\u0005%!\u0006N]8xC\ndWM\u0003\u00021\u001d!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0016aJ2sK\u0006$X-\u0012:s_J\u0014Vm\u001d9p]N,')\u001a4pe\u0016\u0014V-\u00193j]\u001e\u0014V-];fgR$B!!+\u00020B\u0019\u0001%a+\n\u0007\u00055&AA\u0007FeJ|'OU3ta>t7/\u001a\u0005\t\u0003\u0017\u000b\u0019\u000b1\u0001\u0002\u000e\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0016!F2sK\u0006$XmU3sm\u0016\u0014X\t_2faRLwN\u001c\u000b\u0007\u0003o\u000b\u0019-!4\u0011\r5\tI,!0;\u0013\r\tYL\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u0001\ny,C\u0002\u0002B\n\u0011q\u0002S8u%>$W\t_2faRLwN\u001c\u0005\t\u0003\u000b\f\t\f1\u0001\u0002H\u0006\tQ\r\u0005\u0003\u0002\u0010\u0006%\u0017\u0002BAf\u0003C\u0013\u0011\"\u0012=dKB$\u0018n\u001c8\t\u0011\u0005=\u0017\u0011\u0017a\u0001\u0003#\f\u0011A\u0019\t\u0005\u0003'\f\t/\u0004\u0002\u0002V*!\u0011q[Am\u0003\u0019\u0011WO\u001a4fe*!\u00111\\Ao\u0003\u0015qW\r\u001e;z\u0015\t\ty.\u0001\u0002j_&!\u00111]Ak\u0005\u001d\u0011\u0015\u0010^3Ck\u001aDq!a:\u0001\t\u0003\tI/A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\u0019\tY/a>\u0003\bQ\u0019A)!<\t\u0013\u0005=\u0018Q\u001dCA\u0002\u0005E\u0018\u0001\u00039pgR\u001c\u0015\r\u001c7\u0011\t5\t\u0019\u0010R\u0005\u0004\u0003kt!\u0001\u0003\u001fcs:\fW.\u001a \t\u0011\u0005e\u0018Q\u001da\u0001\u0003w\f1a\u0019;y!\u0011\tiPa\u0001\u000e\u0005\u0005}(\u0002\u0002B\u0001\u00033\fqa\u00195b]:,G.\u0003\u0003\u0003\u0006\u0005}(!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0005\u0013\t)\u000f1\u0001\u0002\u000e\u0006)1-Y;tK\"9!Q\u0002\u0001\u0005\u0002\t=\u0011a\u0002:fa2\f7-Z\u000b\u0002i!9!1\u0003\u0001\u0005\u0002\tU\u0011aC8ci\u0006LgnQ1dQ\u0016$2\u0001\u0012B\f\u0011!\u0011IB!\u0005A\u0002\tm\u0011\u0001D2bG\",W*\u00198bO\u0016\u0014\b\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\u0007\t\u0005b!A\u0004nC:\fw-\u001a:\n\t\t\u0015\"q\u0004\u0002\u0015\u000b6\u0014W\r\u001a3fI\u000e\u000b7\r[3NC:\fw-\u001a:\t\u000f\t%\u0002\u0001\"\u0001\u0003,\u0005i!-^5mI6+G/\u00193bi\u0006,\"A!\f\u0011\t\t=\"QG\u0007\u0003\u0005cQ1Aa\r\u0007\u0003!iW\r^1eCR\f\u0017\u0002\u0002B\u001c\u0005c\u0011\u0001\"T3uC\u0012\fG/\u0019\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0003\r9W\r\u001e\u000b\u0004i\t}\u0002b\u0002B!\u0005s\u0001\r!L\u0001\tW\u0016L()\u001f;fg\"9!Q\t\u0001\u0005\u0002\t=\u0011a\u0005:fa2\f7-Z%g+:lw\u000eZ5gS\u0016$\u0007b\u0002B%\u0001\u0011\u0005!qB\u0001\faV$\u0018JZ!cg\u0016tG\u000fC\u0004\u0003N\u0001!\tAa\u0004\u0002\u0007A,H\u000fC\u0004\u0003R\u0001!\tAa\u0015\u0002\u001f\u001d,g.\u001a:bi\u00164VM]:j_:$bA!\u0016\u0003f\tU\u0004\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\u000bm\u0016\u00148/[8oS:<'b\u0001B0\r\u0005I1m\u001c8uC&tWM]\u0005\u0005\u0005G\u0012IF\u0001\u0007F]R\u0014\u0018PV3sg&|g\u000e\u0003\u0005\u0003h\t=\u0003\u0019\u0001B5\u0003!\u0011XmZ5tiJL\b\u0003\u0002B6\u0005cj!A!\u001c\u000b\u0007\t=d!A\u0005gC\u000e$xN]5fg&!!1\u000fB7\u0005E\u0019u.\u001c9p]\u0016tGOU3hSN$(/\u001f\u0005\bI\n=\u0003\u0019\u0001B<!\u00159'\u0011P\u0017.\u0013\r\u0011YH\u0002\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\u0005\b\u0005\u007f\u0002A\u0011\u0001B\b\u0003\u0019\u0011X-\\8wK\"9!1\u0011\u0001\u0005\u0002\t\u0015\u0015aC:vG\u000e,7o\u001d*fgB$2\u0001\u000eBD\u0011\u001d\u0011II!!A\u00025\nA\u0001\u001d:fm\"9!Q\u0012\u0001\u0005\u0002\t=\u0015a\u00048pi\u0016CXmY;uK\u0012\u0014Vm\u001d9\u0015\u0007Q\u0012\t\nC\u0004\u0003\n\n-\u0005\u0019A\u0017\t\u000f\tU\u0005\u0001\"\u0001\u0003\u0010\u0005aan\u001c;Fq&\u001cHOU3ta\"9!\u0011\u0014\u0001\u0005\u0002\tm\u0015!E2sK\u0006$XmR3u%\u0016\u001c\bo\u001c8tKR\u0019AG!(\t\u0011\t}%q\u0013a\u0001\u0005C\u000bQ!\u001a8uef\u0004bAa)\u0003*6jSB\u0001BS\u0015\u0011\u00119K!\u0018\u0002\u000f\u0015tGO]5fg&!!1\u0016BS\u0005)\u0019\u0015m\u00195f\u000b:$(/\u001f\u0005\b\u0005_\u0003A\u0011\u0001BY\u0003Y\u0019'/Z1uK6+H\u000e^5HKR\u0014Vm\u001d9p]N,Gc\u0001\u0007\u00034\"A!Q\u0017BW\u0001\u0004\u00119,A\u0003qC&\u00148\u000fE\u0004\u0002L\u0005USF!)")
public class CacheDecodeContext
implements ServerConstants,
Log {
    private final HotRodServer server;
    private final boolean isTrace;
    private boolean isError;
    private AbstractVersionedDecoder decoder;
    private HotRodHeader header;
    private AdvancedCache<byte[], byte[]> cache;
    private long defaultLifespanTime;
    private long defaultMaxIdleTime;
    private byte[] key;
    private byte[] rawValue;
    private RequestParameters params;
    private Map<byte[], byte[]> putAllMap;
    private Set<byte[]> getAllSet;
    private final JavaLog log;
    private volatile boolean org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged;
    private volatile boolean org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged;
    private final org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log;
    private final int EXPIRATION_NONE;
    private final int EXPIRATION_DEFAULT;
    private final Subject ANONYMOUS;
    private volatile byte bitmap$0;

    private JavaLog log$lzycompute() {
        CacheDecodeContext cacheDecodeContext = this;
        synchronized (cacheDecodeContext) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Log$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.log;
        }
    }

    @Override
    public JavaLog log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public boolean org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged() {
        return this.org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged;
    }

    @Override
    public void org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged_$eq(boolean x$1) {
        this.org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged = x$1;
    }

    @Override
    public boolean org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged() {
        return this.org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged;
    }

    @Override
    public void org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged_$eq(boolean x$1) {
        this.org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged = x$1;
    }

    @Override
    public void logViewNullWhileDetectingCrashedMember() {
        Log$class.logViewNullWhileDetectingCrashedMember(this);
    }

    @Override
    public void logUnableToUpdateView() {
        Log$class.logUnableToUpdateView(this);
    }

    @Override
    public void logErrorDetectingCrashedMember(Throwable t) {
        Log$class.logErrorDetectingCrashedMember(this, t);
    }

    @Override
    public IllegalStateException unexpectedEvent(Event<?, ?> e) {
        return Log$class.unexpectedEvent(this, e);
    }

    @Override
    public void warnConditionalOperationNonTransactional(String op) {
        Log$class.warnConditionalOperationNonTransactional(this, op);
    }

    @Override
    public void warnForceReturnPreviousNonTransactional(String op) {
        Log$class.warnForceReturnPreviousNonTransactional(this, op);
    }

    @Override
    public void warnMarshallerAlreadySet(Marshaller existingMarshaller, Marshaller newMarshaller) {
        Log$class.warnMarshallerAlreadySet(this, existingMarshaller, newMarshaller);
    }

    @Override
    public MissingFactoryException missingCacheEventFactory(String factoryType, String name) {
        return Log$class.missingCacheEventFactory(this, factoryType, name);
    }

    @Override
    public IllegalStateException illegalFilterConverterEventFactory(String name) {
        return Log$class.illegalFilterConverterEventFactory(this, name);
    }

    @Override
    public IllegalStateException illegalIterationId(String iterationId) {
        return Log$class.illegalIterationId(this, iterationId);
    }

    private org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        CacheDecodeContext cacheDecodeContext = this;
        synchronized (cacheDecodeContext) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log.class.org$infinispan$server$core$logging$Log$$log((org.infinispan.server.core.logging.Log)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    public org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$infinispan$server$core$logging$Log$$log$lzycompute() : this.org$infinispan$server$core$logging$Log$$log;
    }

    public void info(Function0<String> msg) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void info(Function0<String> msg, Object param1) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void error(Function0<String> msg, Throwable t) {
        Log.class.error((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void warn(Function0<String> msg, Throwable t) {
        Log.class.warn((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void debug(Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void debug(Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void debug(Throwable t, Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg);
    }

    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg, (Object)param1);
    }

    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log.class.debugf((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public void trace(Function0<String> msg) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void trace(Function0<String> msg, Object param1) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2, (Object)param3);
    }

    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log.class.tracef((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public boolean isDebugEnabled() {
        return Log.class.isDebugEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public boolean isTraceEnabled() {
        return Log.class.isTraceEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public void logStartWithArgs(String args) {
        Log.class.logStartWithArgs((org.infinispan.server.core.logging.Log)this, (String)args);
    }

    public void logPostingShutdownRequest() {
        Log.class.logPostingShutdownRequest((org.infinispan.server.core.logging.Log)this);
    }

    public void logExceptionReported(Throwable t) {
        Log.class.logExceptionReported((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public void logServerDidNotUnbind() {
        Log.class.logServerDidNotUnbind((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log.class.logChannelStillBound((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logServerDidNotClose() {
        Log.class.logServerDidNotClose((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log.class.logChannelStillConnected((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logSettingMasterThreadsNotSupported() {
        Log.class.logSettingMasterThreadsNotSupported((org.infinispan.server.core.logging.Log)this);
    }

    public void logErrorBeforeReadingRequest(Throwable t) {
        Log.class.logErrorBeforeReadingRequest((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public void logNoMembersInHashTopology(ConsistentHash ch, String topology) {
        Log.class.logNoMembersInHashTopology((org.infinispan.server.core.logging.Log)this, (ConsistentHash)ch, (String)topology);
    }

    public void logNoMembersInTopology() {
        Log.class.logNoMembersInTopology((org.infinispan.server.core.logging.Log)this);
    }

    public void logServerEndpointTopologyEmpty(String clusterMembers) {
        Log.class.logServerEndpointTopologyEmpty((org.infinispan.server.core.logging.Log)this, (String)clusterMembers);
    }

    public void logErrorWritingResponse(long msgId, Throwable t) {
        Log.class.logErrorWritingResponse((org.infinispan.server.core.logging.Log)this, (long)msgId, (Throwable)t);
    }

    public void logErrorEncodingMessage(Object msg, Throwable t) {
        Log.class.logErrorEncodingMessage((org.infinispan.server.core.logging.Log)this, (Object)msg, (Throwable)t);
    }

    public void logErrorUnexpectedMessage(Object msg) {
        Log.class.logErrorUnexpectedMessage((org.infinispan.server.core.logging.Log)this, (Object)msg);
    }

    public int EXPIRATION_NONE() {
        return this.EXPIRATION_NONE;
    }

    public int EXPIRATION_DEFAULT() {
        return this.EXPIRATION_DEFAULT;
    }

    public Subject ANONYMOUS() {
        return this.ANONYMOUS;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_NONE_$eq(int x$1) {
        this.EXPIRATION_NONE = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_DEFAULT_$eq(int x$1) {
        this.EXPIRATION_DEFAULT = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$ANONYMOUS_$eq(Subject x$1) {
        this.ANONYMOUS = x$1;
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public boolean isError() {
        return this.isError;
    }

    public void isError_$eq(boolean x$1) {
        this.isError = x$1;
    }

    public AbstractVersionedDecoder decoder() {
        return this.decoder;
    }

    public void decoder_$eq(AbstractVersionedDecoder x$1) {
        this.decoder = x$1;
    }

    public HotRodHeader header() {
        return this.header;
    }

    public void header_$eq(HotRodHeader x$1) {
        this.header = x$1;
    }

    public AdvancedCache<byte[], byte[]> cache() {
        return this.cache;
    }

    public void cache_$eq(AdvancedCache<byte[], byte[]> x$1) {
        this.cache = x$1;
    }

    public long defaultLifespanTime() {
        return this.defaultLifespanTime;
    }

    public void defaultLifespanTime_$eq(long x$1) {
        this.defaultLifespanTime = x$1;
    }

    public long defaultMaxIdleTime() {
        return this.defaultMaxIdleTime;
    }

    public void defaultMaxIdleTime_$eq(long x$1) {
        this.defaultMaxIdleTime = x$1;
    }

    public byte[] key() {
        return this.key;
    }

    public void key_$eq(byte[] x$1) {
        this.key = x$1;
    }

    public byte[] rawValue() {
        return this.rawValue;
    }

    public void rawValue_$eq(byte[] x$1) {
        this.rawValue = x$1;
    }

    public RequestParameters params() {
        return this.params;
    }

    public void params_$eq(RequestParameters x$1) {
        this.params = x$1;
    }

    public Map<byte[], byte[]> putAllMap() {
        return this.putAllMap;
    }

    public void putAllMap_$eq(Map<byte[], byte[]> x$1) {
        this.putAllMap = x$1;
    }

    public Set<byte[]> getAllSet() {
        return this.getAllSet;
    }

    public void getAllSet_$eq(Set<byte[]> x$1) {
        this.getAllSet = x$1;
    }

    public void resetParams() {
        this.params_$eq(null);
        this.rawValue_$eq(null);
        this.putAllMap_$eq(null);
        this.getAllSet_$eq(null);
    }

    public Object createErrorResponse(Throwable t) {
        ErrorResponse errorResponse;
        Throwable throwable = t;
        if (throwable instanceof DecoderException) {
            ErrorResponse errorResponse2;
            DecoderException decoderException = (DecoderException)throwable;
            Throwable throwable2 = decoderException.getCause();
            if (throwable2 instanceof HotRodException) {
                HotRodException hotRodException = (HotRodException)throwable2;
                errorResponse2 = hotRodException.response();
            } else {
                errorResponse2 = this.createErrorResponseBeforeReadingRequest(t);
            }
            errorResponse = errorResponse2;
        } else if (throwable instanceof HotRodException) {
            HotRodException hotRodException = (HotRodException)throwable;
            errorResponse = hotRodException.response();
        } else {
            errorResponse = throwable instanceof ClosedChannelException ? null : this.createErrorResponseBeforeReadingRequest(t);
        }
        return errorResponse;
    }

    private ErrorResponse createErrorResponseBeforeReadingRequest(Throwable t) {
        this.logErrorBeforeReadingRequest(t);
        return new ErrorResponse(0, 0L, "", 1, OperationStatus$.MODULE$.ServerError(), 0, t.toString());
    }

    public Tuple2<HotRodException, Object> createServerException(Exception e, ByteBuf b) {
        Exception exception;
        block8: {
            Tuple2 tuple2;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    exception = e;
                                    if (!(exception instanceof InvalidMagicIdException)) break block2;
                                    InvalidMagicIdException invalidMagicIdException = (InvalidMagicIdException)exception;
                                    this.logExceptionReported(invalidMagicIdException);
                                    tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(0, 0L, "", 1, OperationStatus$.MODULE$.InvalidMagicOrMsgId(), 0, invalidMagicIdException.toString()), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                                    break block3;
                                }
                                if (!(exception instanceof HotRodUnknownOperationException)) break block4;
                                HotRodUnknownOperationException hotRodUnknownOperationException = (HotRodUnknownOperationException)exception;
                                this.logExceptionReported(hotRodUnknownOperationException);
                                tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(hotRodUnknownOperationException.version(), hotRodUnknownOperationException.messageId(), "", 1, OperationStatus$.MODULE$.UnknownOperation(), 0, hotRodUnknownOperationException.toString()), (Throwable)hotRodUnknownOperationException), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                                break block3;
                            }
                            if (!(exception instanceof UnknownVersionException)) break block5;
                            UnknownVersionException unknownVersionException = (UnknownVersionException)exception;
                            this.logExceptionReported(unknownVersionException);
                            tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(unknownVersionException.version(), unknownVersionException.messageId(), "", 1, OperationStatus$.MODULE$.UnknownVersion(), 0, unknownVersionException.toString()), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                            break block3;
                        }
                        if (!(exception instanceof RequestParsingException)) break block6;
                        RequestParsingException requestParsingException = (RequestParsingException)exception;
                        this.logExceptionReported(requestParsingException);
                        String msg = requestParsingException.getCause() == null ? requestParsingException.toString() : new StringOps(Predef$.MODULE$.augmentString("%s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestParsingException.getMessage(), requestParsingException.getCause().toString()}));
                        tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(requestParsingException.version(), requestParsingException.messageId(), "", 1, OperationStatus$.MODULE$.ParseError(), 0, msg), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break block3;
                    }
                    if (!(exception instanceof IllegalStateException)) break block7;
                    IllegalStateException illegalStateException = (IllegalStateException)exception;
                    this.logExceptionReported(illegalStateException);
                    tuple2 = new Tuple2((Object)new HotRodException(this.decoder().createErrorResponse(this.header(), illegalStateException), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break block3;
                }
                if (exception == null) break block8;
                Exception exception2 = exception;
                tuple2 = new Tuple2((Object)new HotRodException(this.decoder().createErrorResponse(this.header(), exception2), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return tuple2;
        }
        throw new MatchError((Object)exception);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause, Function0<BoxedUnit> postCall) {
        BoxedUnit boxedUnit;
        Channel ch = ctx.channel();
        this.debug(cause, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Exception caught";
            }
        });
        if (cause instanceof IOException) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Object errorResponse = this.createErrorResponse(cause);
            if (errorResponse == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object;
                Object object2 = errorResponse;
                if (object2 instanceof byte[]) {
                    byte[] byArray = (byte[])object2;
                    object = ch.writeAndFlush((Object)ExtendedByteBuf$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{byArray})));
                } else if (object2 instanceof CharSequence) {
                    CharSequence charSequence = (CharSequence)object2;
                    object = ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)charSequence, (Charset)CharsetUtil.UTF_8));
                } else {
                    object = object2 == null ? BoxedUnit.UNIT : ch.writeAndFlush(errorResponse);
                }
                boxedUnit = object;
            }
        }
        postCall.apply$mcV$sp();
    }

    public Response replace() {
        byte[] prev = (byte[])this.cache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).get((Object)this.key());
        if (prev != null) {
            prev = (byte[])this.cache().replace((Object)this.key(), (Object)this.rawValue(), this.buildMetadata());
        }
        return prev != null ? this.successResp(prev) : this.notExecutedResp(prev);
    }

    public void obtainCache(EmbeddedCacheManager cacheManager) {
        String cacheName = this.header().cacheName();
        if (cacheName.startsWith(HotRodServerConfiguration.TOPOLOGY_CACHE_NAME_PREFIX)) {
            throw new RequestParsingException(new StringOps(Predef$.MODULE$.augmentString("Remote requests are not allowed to topology cache. Do no send remote requests to cache '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cacheName})), this.header().version(), this.header().messageId());
        }
        boolean seenForFirstTime = false;
        if (this.server.isCacheNameKnown(cacheName)) {
            if (cacheManager.getCacheNames().contains(cacheName)) {
                seenForFirstTime = true;
            } else {
                this.isError_$eq(true);
                throw new CacheNotFoundException(new StringOps(Predef$.MODULE$.augmentString("Cache with name '%s' not found amongst the configured caches")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cacheName})), this.header().version(), this.header().messageId());
            }
        }
        AdvancedCache<byte[], byte[]> cache = this.server.getCacheInstance(cacheName, cacheManager, seenForFirstTime);
        this.cache_$eq((AdvancedCache<byte[], byte[]>)this.decoder().getOptimizedCache(this.header(), cache).getAdvancedCache());
    }

    public Metadata buildMetadata() {
        Tuple2 tuple2;
        block6: {
            EmbeddedMetadata.Builder metadata;
            block3: {
                Metadata.Builder builder;
                block5: {
                    ExpirationParam expirationParam;
                    block4: {
                        ExpirationParam expirationParam2;
                        block2: {
                            metadata = new EmbeddedMetadata.Builder();
                            metadata.version(this.generateVersion(this.server.getCacheRegistry(this.header().cacheName()), (Cache<byte[], byte[]>)this.cache()));
                            tuple2 = new Tuple2((Object)this.params().lifespan(), (Object)this.params().maxIdle());
                            if (tuple2 == null) break block2;
                            ExpirationParam expirationParam3 = (ExpirationParam)tuple2._1();
                            ExpirationParam expirationParam4 = (ExpirationParam)tuple2._2();
                            if (expirationParam3 == null) break block2;
                            long l = expirationParam3.duration();
                            if ((long)this.EXPIRATION_DEFAULT() != l || expirationParam4 == null) break block2;
                            long l2 = expirationParam4.duration();
                            if ((long)this.EXPIRATION_DEFAULT() != l2) break block2;
                            builder = metadata.lifespan(this.defaultLifespanTime()).maxIdle(this.defaultMaxIdleTime());
                            break block3;
                        }
                        if (tuple2 == null || (expirationParam2 = (ExpirationParam)tuple2._2()) == null) break block4;
                        long l = expirationParam2.duration();
                        if ((long)this.EXPIRATION_DEFAULT() != l) break block4;
                        builder = metadata.lifespan(this.decoder().toMillis(this.params().lifespan(), this.header())).maxIdle(this.defaultMaxIdleTime());
                        break block3;
                    }
                    if (tuple2 == null || (expirationParam = (ExpirationParam)tuple2._1()) == null) break block5;
                    long l = expirationParam.duration();
                    if ((long)this.EXPIRATION_DEFAULT() != l) break block5;
                    builder = metadata.lifespan(this.defaultMaxIdleTime()).maxIdle(this.decoder().toMillis(this.params().maxIdle(), this.header()));
                    break block3;
                }
                if (tuple2 == null) break block6;
                builder = metadata.lifespan(this.decoder().toMillis(this.params().lifespan(), this.header())).maxIdle(this.decoder().toMillis(this.params().maxIdle(), this.header()));
            }
            return metadata.build();
        }
        throw new MatchError((Object)tuple2);
    }

    public Response get(byte[] keyBytes) {
        return this.createGetResponse((CacheEntry<byte[], byte[]>)this.cache().getCacheEntry((Object)keyBytes));
    }

    public Response replaceIfUnmodified() {
        Response response;
        CacheEntry entry = this.cache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).getCacheEntry((Object)this.key());
        if (entry == null) {
            response = this.notExistResp();
        } else {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(this.params().streamVersion());
            EntryVersion entryVersion = entry.getMetadata().version();
            NumericVersion numericVersion = streamVersion;
            if (!(entryVersion != null ? !entryVersion.equals(numericVersion) : numericVersion != null)) {
                byte[] v = this.rawValue();
                boolean replaced = this.cache().replace((Object)this.key(), (Object)prev, (Object)v, this.buildMetadata());
                response = replaced ? this.successResp(prev) : this.notExecutedResp(prev);
            } else {
                response = this.notExecutedResp(prev);
            }
        }
        return response;
    }

    public Response putIfAbsent() {
        byte[] prev = (byte[])this.cache().get((Object)this.key());
        if (prev == null) {
            prev = (byte[])this.cache().putIfAbsent((Object)this.key(), (Object)this.rawValue(), this.buildMetadata());
        }
        return prev == null ? this.successResp(prev) : this.notExecutedResp(prev);
    }

    public Response put() {
        byte[] prev = (byte[])this.cache().put((Object)this.key(), (Object)this.rawValue(), this.buildMetadata());
        return this.successResp(prev);
    }

    public EntryVersion generateVersion(ComponentRegistry registry, Cache<byte[], byte[]> cache) {
        IncrementableEntryVersion incrementableEntryVersion;
        VersionGenerator cacheVersionGenerator = (VersionGenerator)registry.getComponent(VersionGenerator.class);
        if (cacheVersionGenerator == null) {
            NumericVersionGenerator newVersionGenerator = new NumericVersionGenerator().clustered(registry.getComponent(RpcManager.class) != null);
            registry.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
            incrementableEntryVersion = newVersionGenerator.generateNew();
        } else {
            incrementableEntryVersion = cacheVersionGenerator.generateNew();
        }
        return incrementableEntryVersion;
    }

    public Response remove() {
        byte[] prev = (byte[])this.cache().remove((Object)this.key());
        return prev != null ? this.successResp(prev) : this.notExistResp();
    }

    public Response successResp(byte[] prev) {
        return this.decoder().createSuccessResponse(this.header(), prev);
    }

    public Response notExecutedResp(byte[] prev) {
        return this.decoder().createNotExecutedResponse(this.header(), prev);
    }

    public Response notExistResp() {
        return this.decoder().createNotExistResponse(this.header());
    }

    public Response createGetResponse(CacheEntry<byte[], byte[]> entry) {
        return this.decoder().createGetResponse(this.header(), entry);
    }

    public Object createMultiGetResponse(Map<byte[], CacheEntry<byte[], byte[]>> pairs) {
        return null;
    }

    public CacheDecodeContext(HotRodServer server) {
        this.server = server;
        ServerConstants.class.$init$((ServerConstants)this);
        Log.class.$init$((org.infinispan.server.core.logging.Log)this);
        Log$class.$init$(this);
        this.isTrace = this.isTraceEnabled();
        this.isError = false;
    }
}

