/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheConfigurationAction;
import org.infinispan.security.actions.GetCacheDistributionManagerAction;
import org.infinispan.security.actions.GetCacheGlobalComponentRegistryAction;
import org.infinispan.security.actions.GetCacheRpcManagerAction;
import org.infinispan.security.actions.RemoveListenerAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return (ComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static <K, V> Cache<K, V> getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        GetCacheAction action = new GetCacheAction(cacheManager, cacheName);
        return (Cache)SecurityActions.doPrivileged(action);
    }

    static DistributionManager getCacheDistributionManager(AdvancedCache<?, ?> cache) {
        GetCacheDistributionManagerAction action = new GetCacheDistributionManagerAction(cache);
        return (DistributionManager)SecurityActions.doPrivileged(action);
    }

    static RpcManager getCacheRpcManager(AdvancedCache<?, ?> cache) {
        GetCacheRpcManagerAction action = new GetCacheRpcManagerAction(cache);
        return (RpcManager)SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getCacheGlobalComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheGlobalComponentRegistryAction action = new GetCacheGlobalComponentRegistryAction(cache);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static Void removeListener(Listenable listenable, Object listener) {
        RemoveListenerAction action = new RemoveListenerAction(listenable, listener);
        return (Void)SecurityActions.doPrivileged(action);
    }
}

