/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.security.PrivilegedActionException;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.security.Security;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.BulkGetKeysResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.ClientListenerRequestContext;
import org.infinispan.server.hotrod.ExecRequestContext;
import org.infinispan.server.hotrod.ExecResponse;
import org.infinispan.server.hotrod.GetAllResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.IterationNextResponse;
import org.infinispan.server.hotrod.IterationStartResponse;
import org.infinispan.server.hotrod.OperationResponse;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.QueryResponse;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWriting;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.SizeResponse;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.util.BulkUtil;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.List;

public class ContextHandler
extends SimpleChannelInboundHandler<CacheDecodeContext> {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(ContextHandler.class, JavaLog.class);
    private final HotRodServer server;
    private final NettyTransport transport;
    private final Executor executor;

    public ContextHandler(HotRodServer server, NettyTransport transport, Executor executor) {
        this.server = server;
        this.transport = transport;
        this.executor = executor;
    }

    protected void channelRead0(ChannelHandlerContext ctx, CacheDecodeContext msg) throws Exception {
        this.executor.execute(() -> {
            try {
                Subject subject = msg.getSubject();
                if (subject == null) {
                    this.realRead(ctx, msg);
                } else {
                    Security.doAs((Subject)subject, () -> {
                        this.realRead(ctx, msg);
                        return null;
                    });
                }
            }
            catch (PrivilegedActionException e) {
                ctx.fireExceptionCaught(e.getCause());
            }
            catch (Exception e) {
                ctx.fireExceptionCaught((Throwable)e);
            }
        });
    }

    protected void realRead(ChannelHandlerContext ctx, CacheDecodeContext msg) throws Exception {
        HotRodHeader h = msg.header();
        switch (h.op()) {
            case PutRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.put());
                break;
            }
            case PutIfAbsentRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.putIfAbsent());
                break;
            }
            case ReplaceRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.replace());
                break;
            }
            case ReplaceIfUnmodifiedRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.replaceIfUnmodified());
                break;
            }
            case ContainsKeyRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.containsKey());
                break;
            }
            case GetRequest: 
            case GetWithVersionRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.get());
                break;
            }
            case GetWithMetadataRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.getKeyMetadata());
                break;
            }
            case RemoveRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.remove());
                break;
            }
            case RemoveIfUnmodifiedRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.removeIfUnmodified());
                break;
            }
            case PingRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse.PingResponse(), OperationStatus.Success(), h.topologyId()));
                break;
            }
            case StatsRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder().createStatsResponse(msg, this.transport));
                break;
            }
            case ClearRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.clear());
                break;
            }
            case SizeRequest: {
                ResponseWriting.writeResponse(msg, ctx.channel(), new SizeResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), msg.cache().size()));
                break;
            }
            case ExecRequest: {
                ExecRequestContext execContext = (ExecRequestContext)msg.operationDecodeContext();
                TaskManager taskManager = (TaskManager)SecurityActions.getCacheGlobalComponentRegistry(msg.cache()).getComponent(TaskManager.class);
                Object marshaller = this.server.getMarshaller() != null ? this.server.getMarshaller() : new GenericJBossMarshaller();
                byte[] result = (byte[])taskManager.runTask(execContext.name(), new TaskContext().marshaller(marshaller).cache(msg.cache()).parameters(execContext.params())).get();
                ResponseWriting.writeResponse(msg, ctx.channel(), new ExecResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), result));
                break;
            }
            case BulkGetRequest: {
                int size = (Integer)msg.operationDecodeContext();
                if (msg.isTrace()) {
                    log.tracef("About to create bulk response count = %d", size);
                }
                ResponseWriting.writeResponse(msg, ctx.channel(), new BulkGetResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), size, (Set<Map.Entry<byte[], byte[]>>)msg.cache().entrySet()));
                break;
            }
            case BulkGetKeysRequest: {
                int scope = (Integer)msg.operationDecodeContext();
                if (msg.isTrace()) {
                    log.tracef("About to create bulk get keys response scope = %d", scope);
                }
                ResponseWriting.writeResponse(msg, ctx.channel(), new BulkGetKeysResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), scope, BulkUtil.getAllKeys(msg.cache(), scope)));
                break;
            }
            case QueryRequest: {
                byte[] queryResult = this.server.query(msg.cache(), (byte[])msg.operationDecodeContext());
                ResponseWriting.writeResponse(msg, ctx.channel(), new QueryResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), queryResult));
                break;
            }
            case AddClientListenerRequest: {
                ClientListenerRequestContext clientContext = (ClientListenerRequestContext)msg.operationDecodeContext();
                this.server.getClientListenerRegistry().addClientListener(msg.decoder(), ctx.channel(), h, clientContext.listenerId(), msg.cache(), clientContext.includeCurrentState(), (Tuple2<Option<Tuple2<String, List<byte[]>>>, Option<Tuple2<String, List<byte[]>>>>)new Tuple2(clientContext.filterFactoryInfo(), clientContext.converterFactoryInfo()), clientContext.useRawData());
                break;
            }
            case RemoveClientListenerRequest: {
                byte[] listenerId = (byte[])msg.operationDecodeContext();
                if (this.server.getClientListenerRegistry().removeClientListener(listenerId, msg.cache())) {
                    ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder().createSuccessResponse(h, null));
                    break;
                }
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder().createNotExecutedResponse(h, null));
                break;
            }
            case IterationStartRequest: {
                Tuple4 iterationStart = (Tuple4)msg.operationDecodeContext();
                Option optionBitSet = ((Option)iterationStart._1()).isDefined() ? Option.apply((Object)BitSet.valueOf((byte[])((Option)iterationStart._1()).get())) : None$.empty();
                Option factoryName = (Option)iterationStart._2();
                String iterationId = this.server.iterationManager().start(msg.cache().getName(), (Option<BitSet>)optionBitSet, (Option<Tuple2<String, List<byte[]>>>)((Option)iterationStart._2()), (Integer)iterationStart._3(), (Boolean)iterationStart._4());
                ResponseWriting.writeResponse(msg, ctx.channel(), new IterationStartResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), iterationId));
                break;
            }
            case IterationNextRequest: {
                String iterationId = (String)msg.operationDecodeContext();
                IterableIterationResult iterationResult = this.server.iterationManager().next(msg.cache().getName(), iterationId);
                ResponseWriting.writeResponse(msg, ctx.channel(), new IterationNextResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), iterationResult));
                break;
            }
            case IterationEndRequest: {
                String iterationId = (String)msg.operationDecodeContext();
                boolean removed = this.server.iterationManager().close(msg.cache().getName(), iterationId);
                ResponseWriting.writeResponse(msg, ctx.channel(), new Response(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), OperationResponse.IterationEndResponse(), removed ? OperationStatus.Success() : OperationStatus.InvalidIteration(), h.topologyId()));
                break;
            }
            case PutAllRequest: {
                msg.cache().putAll((Map)msg.operationDecodeContext(), msg.buildMetadata());
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder().createSuccessResponse(h, null));
                break;
            }
            case GetAllRequest: {
                Map map = msg.cache().getAll((Set)msg.operationDecodeContext());
                ResponseWriting.writeResponse(msg, ctx.channel(), new GetAllResponse(h.version(), h.messageId(), h.cacheName(), h.clientIntel(), h.topologyId(), map));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation invoked: " + (Object)((Object)msg.header().op()));
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        log.tracef("Channel %s became active", ctx.channel());
        this.server.getClientListenerRegistry().findAndWriteEvents(ctx.channel());
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        log.tracef("Channel %s writability changed", ctx.channel());
        this.server.getClientListenerRegistry().findAndWriteEvents(ctx.channel());
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof CacheDecodeContext;
    }
}

