/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.HotRodDecoder;
import org.infinispan.server.hotrod.HotRodException;

public class HotRodExceptionHandler
extends ChannelInboundHandlerAdapter {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(HotRodExceptionHandler.class, JavaLog.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) throws Exception {
        Channel ch = ctx.channel();
        HotRodDecoder decoder = (HotRodDecoder)ctx.pipeline().get(HotRodDecoder.class);
        CacheDecodeContext decodeCtx = decoder.decodeCtx;
        log.debug((Object)"Exception caught", t);
        if (t instanceof DecoderException) {
            t = t.getCause();
        }
        if (t instanceof HotRodException) {
            ch.writeAndFlush((Object)((HotRodException)t).response(), ch.voidPromise());
        } else {
            ch.writeAndFlush((Object)decodeCtx.createExceptionResponse(t), ch.voidPromise());
        }
    }
}

