/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.Xid;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.CacheXid;
import org.infinispan.server.hotrod.tx.ClientAddress;
import org.infinispan.server.hotrod.tx.TxState;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.ByteString;

public class ServerTransactionTable {
    private static final Log log = (Log)LogFactory.getLog(ServerTransactionTable.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<CacheXid, TxState> globalTxTable;
    private final Map<Xid, EmbeddedTransaction> localTxTable;
    private final ByteString cacheName;
    private final ClientAddress clientAddress;

    public ServerTransactionTable(Map<CacheXid, TxState> globalTxTable, ByteString cacheName, Address address) {
        this.cacheName = cacheName;
        this.localTxTable = new ConcurrentHashMap<Xid, EmbeddedTransaction>();
        this.globalTxTable = globalTxTable;
        this.clientAddress = new ClientAddress(address);
    }

    ClientAddress getClientAddress() {
        return this.clientAddress;
    }

    void removeGlobalStateAndLocalTx(XidImpl xid) {
        TxState oldState = this.globalTxTable.remove(new CacheXid(this.cacheName, xid));
        EmbeddedTransaction oldTx = this.localTxTable.remove(xid);
        if (trace) {
            log.tracef("[%s] Removed state=%s and tx=%s", xid, oldState, oldTx);
        }
    }

    EmbeddedTransaction getLocalTx(Xid xid) {
        return this.localTxTable.get(xid);
    }

    void removeLocalTx(Xid xid) {
        EmbeddedTransaction tx = this.localTxTable.remove(xid);
        if (trace) {
            log.tracef("[%s] Removed tx=%s", xid, tx);
        }
    }

    boolean addGlobalState(XidImpl xid, TxState txState) {
        boolean created;
        boolean bl = created = this.globalTxTable.putIfAbsent(new CacheXid(this.cacheName, xid), txState) == null;
        if (trace && created) {
            log.tracef("[%s] New state=%s", xid, txState);
        }
        return created;
    }

    void createLocalTx(Xid xid, EmbeddedTransaction tx) {
        this.localTxTable.put(xid, tx);
        if (trace) {
            log.tracef("[%s] New tx=%s", xid, tx);
        }
    }

    void removeGlobalState(XidImpl xid) {
        TxState state = this.globalTxTable.remove(new CacheXid(this.cacheName, xid));
        if (trace) {
            log.tracef("[%s] Removed state=%s", xid, state);
        }
    }

    boolean updateGlobalState(XidImpl xid, TxState current, TxState update) {
        boolean updated = this.globalTxTable.replace(new CacheXid(this.cacheName, xid), current, update);
        if (trace && updated) {
            log.tracef("[%s] New state=%s (old state=%s)", xid, update, current);
        }
        return updated;
    }

    TxState getGlobalState(XidImpl xid) {
        return this.globalTxTable.get(new CacheXid(this.cacheName, xid));
    }

    boolean isEmpty() {
        return this.globalTxTable.isEmpty() && this.localTxTable.isEmpty();
    }
}

