/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.distribution.group.impl.PartitionerConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.AbstractHashDistAwareResponse;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.BulkGetKeysResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.Events;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithMetadataResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HashDistAwareResponse;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.QueryResponse;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.TopologyAwareResponse;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.util.KeyValuePair;

public abstract class AbstractEncoder1x
implements VersionedEncoder {
    protected final Log log = (Log)LogFactory.getLog(this.getClass(), Log.class);
    protected final boolean trace = this.log.isTraceEnabled();

    @Override
    public void writeEvent(Events.Event e, ByteBuf buf) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeHeader(Response r, ByteBuf buf, Cache<Address, ServerAddress> addressCache, HotRodServer server) {
        AbstractTopologyResponse topologyResp = this.getTopologyResponse(r, addressCache, server);
        buf.writeByte(161);
        ExtendedByteBuf.writeUnsignedLong(r.messageId, buf);
        buf.writeByte(r.operation.getResponseOpCode());
        buf.writeByte((int)r.status.getCode());
        if (topologyResp != null) {
            if (topologyResp instanceof TopologyAwareResponse) {
                TopologyAwareResponse tar = (TopologyAwareResponse)topologyResp;
                if (r.clientIntel == 2) {
                    this.writeTopologyUpdate(tar, buf);
                    return;
                } else {
                    this.writeLimitedHashTopologyUpdate(tar, buf);
                }
                return;
            } else {
                if (!(topologyResp instanceof AbstractHashDistAwareResponse)) throw new IllegalArgumentException("Unsupported response instance: " + topologyResp);
                this.writeHashTopologyUpdate((AbstractHashDistAwareResponse)topologyResp, server, r, buf);
            }
            return;
        } else {
            this.writeNoTopologyUpdate(buf);
        }
    }

    @Override
    public void writeResponse(Response r, ByteBuf buf, EmbeddedCacheManager cacheManager, HotRodServer server) {
        if (r instanceof ResponseWithPrevious) {
            Optional<byte[]> prev = ((ResponseWithPrevious)r).previous;
            if (prev.isPresent()) {
                ExtendedByteBuf.writeRangedBytes(prev.get(), buf);
            } else {
                ExtendedByteBuf.writeUnsignedInt(0, buf);
            }
        } else if (r instanceof StatsResponse) {
            Map<String, String> stats = ((StatsResponse)r).stats;
            ExtendedByteBuf.writeUnsignedInt(stats.size(), buf);
            for (Map.Entry<String, String> entry : stats.entrySet()) {
                ExtendedByteBuf.writeString(entry.getKey(), buf);
                ExtendedByteBuf.writeString(entry.getValue(), buf);
            }
        } else if (r instanceof GetWithVersionResponse) {
            GetWithVersionResponse gwvr = (GetWithVersionResponse)r;
            if (gwvr.status == OperationStatus.Success) {
                buf.writeLong(gwvr.dataVersion);
                ExtendedByteBuf.writeRangedBytes(gwvr.data, buf);
            }
        } else if (r instanceof GetWithMetadataResponse) {
            GetWithMetadataResponse gwmr = (GetWithMetadataResponse)r;
            if (gwmr.status == OperationStatus.Success) {
                int flags = gwmr.lifespan < 0 ? 1 : 0;
                flags = (byte)(flags | (gwmr.maxIdle < 0 ? 2 : 0));
                buf.writeByte(flags);
                if (gwmr.lifespan >= 0) {
                    buf.writeLong(gwmr.created);
                    ExtendedByteBuf.writeUnsignedInt(gwmr.lifespan, buf);
                }
                if (gwmr.maxIdle >= 0) {
                    buf.writeLong(gwmr.lastUsed);
                    ExtendedByteBuf.writeUnsignedInt(gwmr.maxIdle, buf);
                }
                buf.writeLong(gwmr.dataVersion);
                ExtendedByteBuf.writeRangedBytes(gwmr.data, buf);
            }
        } else if (r instanceof BulkGetResponse) {
            if (this.trace) {
                this.log.trace("About to respond to bulk get request");
            }
            BulkGetResponse bgr = (BulkGetResponse)r;
            if (bgr.status == OperationStatus.Success) {
                int count;
                if (bgr.count != 0) {
                    this.log.tracef("About to write (max) %d messages to the client", bgr.count);
                    count = bgr.count;
                } else {
                    count = Integer.MAX_VALUE;
                }
                CloseableIterator iterator = bgr.entries.iterator();
                while (iterator.hasNext() && count-- > 0) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    buf.writeByte(1);
                    ExtendedByteBuf.writeRangedBytes((byte[])entry.getKey(), buf);
                    ExtendedByteBuf.writeRangedBytes((byte[])entry.getValue(), buf);
                }
                buf.writeByte(0);
            }
        } else if (r instanceof BulkGetKeysResponse) {
            this.log.trace("About to respond to bulk get keys request");
            BulkGetKeysResponse bgkr = (BulkGetKeysResponse)r;
            if (bgkr.status == OperationStatus.Success) {
                while (bgkr.iterator.hasNext()) {
                    byte[] key = bgkr.iterator.next();
                    buf.writeByte(1);
                    ExtendedByteBuf.writeRangedBytes(key, buf);
                }
                buf.writeByte(0);
            }
        } else if (r instanceof GetResponse) {
            if (r.status == OperationStatus.Success) {
                ExtendedByteBuf.writeRangedBytes(((GetResponse)r).data, buf);
            }
        } else if (r instanceof QueryResponse) {
            ExtendedByteBuf.writeRangedBytes(((QueryResponse)r).result, buf);
        } else if (r instanceof ErrorResponse) {
            ExtendedByteBuf.writeString(((ErrorResponse)r).msg, buf);
        } else if (buf == null) {
            throw new IllegalArgumentException("Response received is unknown: " + r);
        }
    }

    AbstractTopologyResponse getTopologyResponse(Response r, Cache<Address, ServerAddress> addressCache, HotRodServer server) {
        if (addressCache != null) {
            switch (r.clientIntel) {
                case 2: 
                case 3: {
                    int currentTopologyId;
                    AdvancedCache cache = server.getCacheInstance(r.cacheName, addressCache.getCacheManager(), false, true);
                    RpcManager rpcManager = cache.getRpcManager();
                    int n = currentTopologyId = rpcManager == null ? -1 : rpcManager.getTopologyId();
                    if (currentTopologyId < -1 || r.topologyId >= currentTopologyId) break;
                    return this.generateTopologyResponse(r, addressCache, server, currentTopologyId);
                }
            }
        }
        return null;
    }

    private AbstractTopologyResponse generateTopologyResponse(Response r, Cache<Address, ServerAddress> addressCache, HotRodServer server, int currentTopologyId) {
        AdvancedCache cache = server.getCacheInstance(r.cacheName, addressCache.getCacheManager(), false, true);
        List cacheMembers = cache.getRpcManager().getMembers();
        int responseTopologyId = currentTopologyId;
        if (!addressCache.keySet().containsAll((Collection)cacheMembers)) {
            int clientTopologyId = r.topologyId;
            if (currentTopologyId - clientTopologyId < 2) {
                return null;
            }
            --responseTopologyId;
        }
        Configuration config = cache.getCacheConfiguration();
        if (r.clientIntel == 2 || !config.clustering().cacheMode().isDistributed()) {
            return new TopologyAwareResponse(responseTopologyId, (Map<Address, ServerAddress>)addressCache, 0);
        }
        return this.createHashDistAwareResp(responseTopologyId, (Map<Address, ServerAddress>)addressCache, config);
    }

    protected AbstractHashDistAwareResponse createHashDistAwareResp(int topologyId, Map<Address, ServerAddress> serverEndpointsMap, Configuration cfg) {
        return new HashDistAwareResponse(topologyId, serverEndpointsMap, 0, cfg.clustering().hash().numOwners(), 2, Integer.MAX_VALUE);
    }

    void writeHashTopologyUpdate(AbstractHashDistAwareResponse h, HotRodServer server, Response r, ByteBuf buffer) {
        AdvancedCache cache = server.getCacheInstance(r.cacheName, server.getCacheManager(), false, true);
        DistributionManager distManager = cache.getDistributionManager();
        ConsistentHash ch = distManager.getWriteConsistentHash();
        Map topologyMap = h.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            this.log.noMembersInHashTopology(ch, topologyMap.toString());
            buffer.writeByte(0);
        } else {
            this.log.tracef("Write hash distribution change response header %s", h);
            int numSegments = ch.getNumSegments();
            KeyPartitioner keyPartitioner = ((PartitionerConsistentHash)ch).getKeyPartitioner();
            List<Integer> segmentHashIds = this.extractSegmentEndHashes(keyPartitioner);
            ArrayList<KeyValuePair> serverHashes = new ArrayList<KeyValuePair>(numSegments);
            for (Map.Entry entry : topologyMap.entrySet()) {
                for (int segmentIdx = 0; segmentIdx < numSegments; ++segmentIdx) {
                    int ownerIdx = ch.locateOwnersForSegment(segmentIdx).indexOf(entry.getKey());
                    if (ownerIdx < 0) continue;
                    Integer segmentHashId = segmentHashIds.get(segmentIdx);
                    int hashId = segmentHashId + ownerIdx & Integer.MAX_VALUE;
                    serverHashes.add(new KeyValuePair(entry.getValue(), (Object)hashId));
                }
            }
            int totalNumServers = serverHashes.size();
            this.writeCommonHashTopologyHeader(buffer, h.topologyId, h.numOwners, h.hashFunction, h.hashSpace, totalNumServers);
            for (KeyValuePair serverHash : serverHashes) {
                ExtendedByteBuf.writeString(((ServerAddress)serverHash.getKey()).getHost(), buffer);
                ExtendedByteBuf.writeUnsignedShort(((ServerAddress)serverHash.getKey()).getPort(), buffer);
                int hashId = (Integer)serverHash.getValue();
                if (this.trace) {
                    this.log.tracef("Writing hash id %d for %s:%s", hashId, ((ServerAddress)serverHash.getKey()).getHost(), ((ServerAddress)serverHash.getKey()).getPort());
                }
                buffer.writeInt(hashId);
            }
        }
    }

    List<Integer> extractSegmentEndHashes(KeyPartitioner keyPartitioner) {
        if (keyPartitioner instanceof HashFunctionPartitioner) {
            return ((HashFunctionPartitioner)keyPartitioner).getSegmentEndHashes();
        }
        if (keyPartitioner instanceof GroupingPartitioner) {
            return this.extractSegmentEndHashes(((GroupingPartitioner)keyPartitioner).unwrap());
        }
        return Collections.emptyList();
    }

    void writeLimitedHashTopologyUpdate(AbstractTopologyResponse t, ByteBuf buffer) {
        this.log.tracef("Return limited hash distribution aware header because the client %s doesn't ", t);
        Map<Address, ServerAddress> topologyMap = t.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            this.log.noMembersInTopology();
            buffer.writeByte(0);
        } else {
            this.writeCommonHashTopologyHeader(buffer, t.topologyId, 0, (byte)0, 0, topologyMap.size());
            for (ServerAddress address : topologyMap.values()) {
                ExtendedByteBuf.writeString(address.getHost(), buffer);
                ExtendedByteBuf.writeUnsignedShort(address.getPort(), buffer);
                buffer.writeInt(0);
            }
        }
    }

    void writeTopologyUpdate(TopologyAwareResponse t, ByteBuf buffer) {
        Map topologyMap = t.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            this.log.noMembersInTopology();
            buffer.writeByte(0);
        } else {
            this.log.tracef("Write topology change response header %s", t);
            buffer.writeByte(1);
            ExtendedByteBuf.writeUnsignedInt(t.topologyId, buffer);
            ExtendedByteBuf.writeUnsignedInt(topologyMap.size(), buffer);
            for (ServerAddress address : topologyMap.values()) {
                ExtendedByteBuf.writeString(address.getHost(), buffer);
                ExtendedByteBuf.writeUnsignedShort(address.getPort(), buffer);
            }
        }
    }

    void writeNoTopologyUpdate(ByteBuf buffer) {
        this.log.trace("Write topology response header with no change");
        buffer.writeByte(0);
    }

    protected void writeCommonHashTopologyHeader(ByteBuf buffer, int viewId, int numOwners, byte hashFct, int hashSpace, int numServers) {
        buffer.writeByte(1);
        ExtendedByteBuf.writeUnsignedInt(viewId, buffer);
        ExtendedByteBuf.writeUnsignedShort(numOwners, buffer);
        buffer.writeByte((int)hashFct);
        ExtendedByteBuf.writeUnsignedInt(hashSpace, buffer);
        ExtendedByteBuf.writeUnsignedInt(numServers, buffer);
        this.log.tracef("Topology will contain %d addresses", numServers);
    }
}

