/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.logging.LoggingContextHandler;

public class HotRodAccessLoggingHandler
extends ChannelDuplexHandler {
    private static final Log log = (Log)LogFactory.getLog(HotRodAccessLoggingHandler.class, Log.class);
    LocalDateTime startTime;
    private int bytesRead = 0;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.startTime == null) {
            this.startTime = LocalDateTime.now();
        }
        this.bytesRead += this.getByteSize(msg);
        ctx.channel().attr(LoggingContextHandler.DECODE_CONTEXT_KEY).remove();
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.startTime != null) {
            String status;
            String cacheName;
            byte[] key;
            HotRodOperation op;
            CacheDecodeContext cacheDecodeContext = (CacheDecodeContext)ctx.channel().attr(LoggingContextHandler.DECODE_CONTEXT_KEY).get();
            String exception = (String)ctx.channel().attr(LoggingContextHandler.EXCEPTION_MESSAGE_KEY).get();
            if (cacheDecodeContext != null && exception == null) {
                op = cacheDecodeContext.getHeader().getOp();
                key = cacheDecodeContext.getKey();
                cacheName = cacheDecodeContext.getHeader().getCacheName();
                status = "OK";
            } else {
                op = (HotRodOperation)((Object)ctx.channel().attr(LoggingContextHandler.OPERATION_KEY).get());
                key = null;
                cacheName = (String)ctx.channel().attr(LoggingContextHandler.CACHE_NAME_KEY).get();
                status = exception;
            }
            String remoteAddress = ctx.channel().remoteAddress().toString();
            LocalDateTime startTime = this.startTime;
            this.startTime = null;
            int bytesRead = this.bytesRead;
            this.bytesRead = 0;
            int bytesWritten = this.getByteSize(msg);
            super.write(ctx, msg, promise.addListener(f -> {
                long ms = startTime == null ? -1L : ChronoUnit.MILLIS.between(startTime, LocalDateTime.now());
                log.tracef("%s [%s] \"%s %s\" \"%s\" %s %d %d %d ms", new Object[]{remoteAddress, this.checkForNull(startTime), this.checkForNull((Object)op), this.checkForNull(cacheName), status, this.checkForNull(key), bytesRead, bytesWritten, ms});
            }));
        } else {
            super.write(ctx, msg, promise);
        }
    }

    String checkForNull(Object obj) {
        if (obj == null || obj instanceof String && ((String)obj).isEmpty()) {
            return "-";
        }
        if (obj instanceof byte[]) {
            return Util.printArray((byte[])((byte[])obj));
        }
        return obj.toString();
    }

    int getByteSize(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return -1;
    }
}

