/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.Security;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetStreamResponse;
import org.infinispan.server.hotrod.GetWithMetadataResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.PrepareTransactionContext;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.TransactionResponse;
import org.infinispan.server.hotrod.TransactionWrite;
import org.infinispan.server.hotrod.UnknownVersionException;
import org.infinispan.server.hotrod.VersionedDecoder;
import org.infinispan.server.hotrod.counter.CounterAddDecodeContext;
import org.infinispan.server.hotrod.counter.CounterCompareAndSetDecodeContext;
import org.infinispan.server.hotrod.counter.CounterCreateDecodeContext;
import org.infinispan.server.hotrod.counter.CounterListenerDecodeContext;
import org.infinispan.server.hotrod.counter.listener.ClientCounterManagerNotificationManager;
import org.infinispan.server.hotrod.counter.listener.ListenerOperationStatus;
import org.infinispan.server.hotrod.counter.response.CounterConfigurationResponse;
import org.infinispan.server.hotrod.counter.response.CounterNamesResponse;
import org.infinispan.server.hotrod.counter.response.CounterValueResponse;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.CommitTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.PrepareTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.RollbackTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.SecondPhaseTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.TxState;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.LogFactory;

public final class CacheDecodeContext {
    static final long MillisecondsIn30days = TimeUnit.DAYS.toMillis(30L);
    static final Log log = (Log)LogFactory.getLog(CacheDecodeContext.class, Log.class);
    static final boolean isTrace = log.isTraceEnabled();
    private final HotRodServer server;
    private CounterManager counterManager;
    VersionedDecoder decoder;
    HotRodHeader header;
    AdvancedCache<byte[], byte[]> cache;
    byte[] key;
    RequestParameters params;
    Object operationDecodeContext;
    Subject subject;

    CacheDecodeContext(HotRodServer server) {
        this.server = server;
    }

    public HotRodHeader getHeader() {
        return this.header;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return (byte[])this.operationDecodeContext;
    }

    public RequestParameters getParams() {
        return this.params;
    }

    Response removeCounterListener(HotRodServer server) {
        ClientCounterManagerNotificationManager notificationManager = server.getClientCounterNotificationManager();
        CounterListenerDecodeContext opCtx = (CounterListenerDecodeContext)this.operationContext();
        return this.createResponseFrom(notificationManager.removeCounterListener(opCtx.getListenerId(), opCtx.getCounterName()));
    }

    Response addCounterListener(HotRodServer server, Channel channel) {
        ClientCounterManagerNotificationManager notificationManager = server.getClientCounterNotificationManager();
        CounterListenerDecodeContext opCtx = (CounterListenerDecodeContext)this.operationContext();
        return this.createResponseFrom(notificationManager.addCounterListener(opCtx.getListenerId(), this.header.getVersion(), opCtx.getCounterName(), channel));
    }

    Response getCounterNames() {
        return new CounterNamesResponse(this.header, this.counterManager.getCounterNames());
    }

    Response counterRemove() {
        String counterName = (String)this.operationContext();
        this.counterManager.remove(counterName);
        return Response.createEmptyResponse(this.header, OperationStatus.Success);
    }

    void counterCompareAndSwap(Consumer<Response> sendResponse) {
        CounterCompareAndSetDecodeContext decodeContext = (CounterCompareAndSetDecodeContext)this.operationContext();
        long expect = decodeContext.getExpected();
        long update = decodeContext.getUpdate();
        String name = decodeContext.getCounterName();
        this.applyCounter(name, sendResponse, (counter, responseConsumer) -> counter.compareAndSwap(expect, update).whenComplete(this.longResultHandler((Consumer<Response>)responseConsumer)), (counter, responseConsumer) -> responseConsumer.accept(this.createExceptionResponse((Throwable)log.invalidWeakCounter(name))));
    }

    void counterGet(Consumer<Response> sendResponse) {
        this.applyCounter((String)this.operationContext(), sendResponse, (counter, responseConsumer) -> counter.getValue().whenComplete(this.longResultHandler((Consumer<Response>)responseConsumer)), (counter, responseConsumer) -> this.longResultHandler((Consumer<Response>)responseConsumer).accept(counter.getValue(), null));
    }

    void counterReset(Consumer<Response> sendResponse) {
        this.applyCounter((String)this.operationContext(), sendResponse, (counter, responseConsumer) -> counter.reset().whenComplete(this.voidResultHandler((Consumer<Response>)responseConsumer)), (counter, responseConsumer) -> counter.reset().whenComplete(this.voidResultHandler((Consumer<Response>)responseConsumer)));
    }

    void counterAddAndGet(Consumer<Response> sendResponse) {
        CounterAddDecodeContext decodeContext = (CounterAddDecodeContext)this.operationContext();
        long value = decodeContext.getValue();
        this.applyCounter(decodeContext.getCounterName(), sendResponse, (counter, responseConsumer) -> counter.addAndGet(value).whenComplete(this.longResultHandler((Consumer<Response>)responseConsumer)), (counter, responseConsumer) -> counter.add(value).whenComplete((aVoid, throwable) -> this.longResultHandler((Consumer<Response>)responseConsumer).accept(0L, (Throwable)throwable)));
    }

    void getCounterConfiguration(Consumer<Response> sendResponse) {
        ((EmbeddedCounterManager)this.counterManager).getConfigurationAsync((String)this.operationContext()).whenComplete((configuration, throwable) -> {
            if (throwable != null) {
                this.checkCounterThrowable(sendResponse, (Throwable)throwable);
            } else {
                sendResponse.accept(configuration == null ? this.missingCounterResponse() : new CounterConfigurationResponse(this.header, (CounterConfiguration)configuration));
            }
        });
    }

    void isCounterDefined(Consumer<Response> sendResponse) {
        ((EmbeddedCounterManager)this.counterManager).isDefinedAsync((String)this.operationContext()).whenComplete(this.booleanResultHandler(sendResponse));
    }

    void createCounter(Consumer<Response> sendResponse) {
        CounterCreateDecodeContext decodeContext = (CounterCreateDecodeContext)this.operationContext();
        ((EmbeddedCounterManager)this.counterManager).defineCounterAsync(decodeContext.getCounterName(), decodeContext.getConfiguration()).whenComplete(this.booleanResultHandler(sendResponse));
    }

    <T> T operationContext(Supplier<T> constructor) {
        T opCtx = this.operationContext();
        if (opCtx == null) {
            opCtx = constructor.get();
            this.operationDecodeContext = opCtx;
            return opCtx;
        }
        return opCtx;
    }

    <T> T operationContext() {
        return (T)this.operationDecodeContext;
    }

    private void checkCounterThrowable(Consumer<Response> send, Throwable throwable) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof CounterOutOfBoundsException) {
            send.accept(Response.createEmptyResponse(this.header, OperationStatus.NotExecutedWithPrevious));
        } else {
            send.accept(this.createExceptionResponse(cause));
        }
    }

    private Response createCounterBooleanResponse(boolean result) {
        return Response.createEmptyResponse(this.header, result ? OperationStatus.Success : OperationStatus.OperationNotExecuted);
    }

    private Response missingCounterResponse() {
        return Response.createEmptyResponse(this.header, OperationStatus.KeyDoesNotExist);
    }

    private BiConsumer<Boolean, Throwable> booleanResultHandler(Consumer<Response> sendResponse) {
        return (aBoolean, throwable) -> {
            if (throwable != null) {
                this.checkCounterThrowable(sendResponse, (Throwable)throwable);
            } else {
                sendResponse.accept(this.createCounterBooleanResponse((boolean)aBoolean));
            }
        };
    }

    private BiConsumer<Long, Throwable> longResultHandler(Consumer<Response> sendResponse) {
        return (value, throwable) -> {
            if (throwable != null) {
                this.checkCounterThrowable(sendResponse, (Throwable)throwable);
            } else {
                sendResponse.accept(new CounterValueResponse(this.header, (long)value));
            }
        };
    }

    TransactionResponse rollbackTransaction() {
        this.validateConfiguration();
        return this.finishTransaction(new RollbackTransactionDecodeContext(this.cache, (XidImpl)this.operationDecodeContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response prepareTransaction() {
        this.validateConfiguration();
        PrepareTransactionContext context = (PrepareTransactionContext)this.operationDecodeContext;
        if (context.isEmpty()) {
            if (isTrace) {
                log.tracef("Transaction %s is read only.", context.getXid());
            }
            return this.createTransactionResponse(this.header, 3);
        }
        PrepareTransactionDecodeContext txContext = new PrepareTransactionDecodeContext(this.cache, context.getXid());
        Response response = this.checkExistingTxForPrepare(txContext);
        if (response != null) {
            if (isTrace) {
                log.tracef("Transaction %s conflicts with another node. Response is %s", context.getXid(), response);
            }
            return response;
        }
        if (!txContext.startTransaction()) {
            if (isTrace) {
                log.tracef("Unable to start transaction %s", context.getXid());
            }
            return this.decoder.createNotExecutedResponse(this.header, null);
        }
        AdvancedCache<byte[], byte[]> txCache = txContext.decorateCache(this.cache);
        try {
            for (TransactionWrite write : context.writes()) {
                if (this.isValid(write, txCache)) {
                    if (write.isRemove()) {
                        txCache.remove((Object)write.key);
                        continue;
                    }
                    txCache.put((Object)write.key, (Object)write.value, this.buildMetadata(write.lifespan, write.maxIdle));
                    continue;
                }
                txContext.setRollbackOnly();
                break;
            }
            int xaCode = txContext.prepare(context.isOnePhaseCommit());
            TransactionResponse transactionResponse = this.createTransactionResponse(this.header, xaCode);
            return transactionResponse;
        }
        catch (Exception e) {
            TransactionResponse transactionResponse = this.createTransactionResponse(this.header, txContext.rollback());
            return transactionResponse;
        }
        finally {
            EmbeddedTransactionManager.dissociateTransaction();
        }
    }

    TransactionResponse commitTransaction() {
        this.validateConfiguration();
        return this.finishTransaction(new CommitTransactionDecodeContext(this.cache, (XidImpl)this.operationDecodeContext));
    }

    private TransactionResponse finishTransaction(SecondPhaseTransactionDecodeContext txContext) {
        try {
            txContext.perform();
        }
        catch (HeuristicMixedException e) {
            return this.createTransactionResponse(this.header, 5);
        }
        catch (HeuristicRollbackException e) {
            return this.createTransactionResponse(this.header, 6);
        }
        catch (RollbackException e) {
            return this.createTransactionResponse(this.header, 100);
        }
        return this.createTransactionResponse(this.header, 0);
    }

    private void validateConfiguration() {
        Configuration configuration = this.cache.getCacheConfiguration();
        if (!configuration.transaction().transactionMode().isTransactional()) {
            throw log.expectedTransactionalCache(this.cache.getName());
        }
        if (configuration.locking().isolationLevel() != IsolationLevel.REPEATABLE_READ) {
            throw log.unexpectedIsolationLevel(this.cache.getName());
        }
        if (configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC || configuration.transaction().transactionProtocol() == TransactionProtocol.TOTAL_ORDER) {
            throw new IllegalStateException(String.format("Cache '%s' cannot use Optimistic neither Total Order transactions.", this.cache.getName()));
        }
    }

    private Response checkExistingTxForPrepare(PrepareTransactionDecodeContext context) {
        TxState txState = context.getTxState();
        if (txState == null) {
            return null;
        }
        switch (txState.status()) {
            case 0: {
                break;
            }
            case 2: {
                return this.createTransactionResponse(this.header, 0);
            }
            case 4: {
                return this.createTransactionResponse(this.header, 100);
            }
            case 3: {
                return this.createTransactionResponse(this.header, 0);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (context.isAlive(txState.getOriginator())) {
            return this.decoder.createNotExecutedResponse(this.header, null);
        }
        context.rollbackRemoteTransaction();
        return null;
    }

    ErrorResponse createExceptionResponse(Throwable e) {
        if (e instanceof InvalidMagicIdException) {
            log.exceptionReported(e);
            return new ErrorResponse(0, 0L, "", 1, OperationStatus.InvalidMagicOrMsgId, 0, e.toString());
        }
        if (e instanceof HotRodUnknownOperationException) {
            log.exceptionReported(e);
            HotRodUnknownOperationException hruoe = (HotRodUnknownOperationException)e;
            return new ErrorResponse(hruoe.version, hruoe.messageId, "", 1, OperationStatus.UnknownOperation, 0, e.toString());
        }
        if (e instanceof UnknownVersionException) {
            log.exceptionReported(e);
            UnknownVersionException uve = (UnknownVersionException)e;
            return new ErrorResponse(uve.version, uve.messageId, "", 1, OperationStatus.UnknownVersion, 0, e.toString());
        }
        if (e instanceof RequestParsingException) {
            if (e instanceof CacheNotFoundException) {
                log.debug(e.getMessage());
            } else {
                log.exceptionReported(e);
            }
            String msg = e.getCause() == null ? e.toString() : String.format("%s: %s", e.getMessage(), e.getCause().toString());
            RequestParsingException rpe = (RequestParsingException)e;
            return new ErrorResponse(rpe.version, rpe.messageId, "", 1, OperationStatus.ParseError, 0, msg);
        }
        if (e instanceof IllegalStateException) {
            log.exceptionReported(e);
            return this.decoder.createErrorResponse(this.header, e);
        }
        if (this.decoder != null) {
            return this.decoder.createErrorResponse(this.header, e);
        }
        log.exceptionReported(e);
        return new ErrorResponse(0, 0L, "", 1, OperationStatus.ServerError, 1, e.toString());
    }

    Response replace() {
        byte[] prev = (byte[])this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).get((Object)this.key);
        if (prev != null) {
            prev = (byte[])this.cache.replace((Object)this.key, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
        }
        if (prev != null) {
            return this.successResp(prev);
        }
        return this.notExecutedResp(null);
    }

    void obtainCache(EmbeddedCacheManager cacheManager) throws RequestParsingException {
        switch (this.header.op) {
            case COUNTER_CREATE: 
            case COUNTER_ADD_AND_GET: 
            case COUNTER_ADD_LISTENER: 
            case COUNTER_CAS: 
            case COUNTER_GET: 
            case COUNTER_RESET: 
            case COUNTER_IS_DEFINED: 
            case COUNTER_REMOVE_LISTENER: 
            case COUNTER_GET_CONFIGURATION: 
            case COUNTER_REMOVE: 
            case COUNTER_GET_NAMES: {
                this.header.cacheName = "___counters";
                this.counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager);
                return;
            }
        }
        String cacheName = this.header.cacheName;
        AdvancedCache cache = this.server.getKnownCache(cacheName);
        if (cache == null) {
            InternalCacheRegistry icr = (InternalCacheRegistry)cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
            if (icr.isPrivateCache(cacheName)) {
                throw new RequestParsingException(String.format("Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", cacheName), this.header.version, this.header.messageId);
            }
            if (icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.PROTECTED)) {
                cache = this.server.getCacheInstance(cacheName, cacheManager, true, false);
            } else {
                if (!cacheName.isEmpty() && !cacheManager.getCacheNames().contains(cacheName)) {
                    throw new CacheNotFoundException(String.format("Cache with name '%s' not found amongst the configured caches", cacheName), this.header.version, this.header.messageId);
                }
                cache = this.server.getCacheInstance(cacheName, cacheManager, true, true);
            }
        }
        this.cache = this.decoder.getOptimizedCache(this.header, (AdvancedCache<byte[], byte[]>)cache, this.server.getCacheConfiguration(cacheName));
    }

    void withSubect(Subject subject) {
        this.subject = subject;
        this.cache = this.cache.withSubject(subject);
    }

    public String getPrincipalName() {
        return this.subject != null ? Security.getSubjectUserPrincipal((Subject)this.subject).getName() : null;
    }

    Metadata buildMetadata() {
        return this.buildMetadata(this.params.lifespan, this.params.maxIdle);
    }

    private Metadata buildMetadata(ExpirationParam lifespan, ExpirationParam maxIdle) {
        EmbeddedMetadata.Builder metadata = new EmbeddedMetadata.Builder();
        metadata.version(this.generateVersion(this.server.getCacheRegistry(this.header.cacheName)));
        if (lifespan.duration != -2L) {
            metadata.lifespan(CacheDecodeContext.toMillis(lifespan, this.header));
        }
        if (maxIdle.duration != -2L) {
            metadata.maxIdle(CacheDecodeContext.toMillis(maxIdle, this.header));
        }
        return metadata.build();
    }

    Response get() {
        return this.createGetResponse((CacheEntry<byte[], byte[]>)this.cache.getCacheEntry((Object)this.key));
    }

    Response getKeyMetadata() {
        OperationStatus status;
        CacheEntry ce = this.cache.getCacheEntry((Object)this.key);
        OperationStatus operationStatus = status = ce == null ? OperationStatus.KeyDoesNotExist : OperationStatus.Success;
        if (this.header.op == HotRodOperation.GET_WITH_METADATA) {
            return new GetWithMetadataResponse(this.header.version, this.header.messageId, this.header.cacheName, this.header.clientIntel, this.header.op, status, this.header.topologyId, (CacheEntry<byte[], byte[]>)ce);
        }
        int offset = ce == null ? 0 : (Integer)this.operationDecodeContext;
        return new GetStreamResponse(this.header.version, this.header.messageId, this.header.cacheName, this.header.clientIntel, this.header.op, status, this.header.topologyId, offset, (CacheEntry<byte[], byte[]>)ce);
    }

    Response containsKey() {
        if (this.cache.containsKey((Object)this.key)) {
            return this.successResp(null);
        }
        return this.notExistResp();
    }

    Response replaceIfUnmodified() {
        CacheEntry entry = this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).getCacheEntry((Object)this.key);
        if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(this.params.streamVersion);
            if (entry.getMetadata().version().equals(streamVersion)) {
                boolean replaced = this.cache.replace((Object)this.key, (Object)prev, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
                if (replaced) {
                    return this.successResp(prev);
                }
                return this.notExecutedResp(prev);
            }
            return this.notExecutedResp(prev);
        }
        return this.notExistResp();
    }

    Response putIfAbsent() {
        byte[] prev = (byte[])this.cache.get((Object)this.key);
        if (prev == null) {
            prev = (byte[])this.cache.putIfAbsent((Object)this.key, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
        }
        if (prev == null) {
            return this.successResp(null);
        }
        return this.notExecutedResp(prev);
    }

    Response put() {
        byte[] prev = (byte[])this.cache.put((Object)this.key, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
        return this.successResp(prev);
    }

    EntryVersion generateVersion(ComponentRegistry registry) {
        VersionGenerator cacheVersionGenerator = registry.getVersionGenerator();
        if (cacheVersionGenerator == null) {
            NumericVersionGenerator newVersionGenerator = new NumericVersionGenerator().clustered(registry.getComponent(RpcManager.class) != null);
            registry.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
            return newVersionGenerator.generateNew();
        }
        return cacheVersionGenerator.generateNew();
    }

    Response remove() {
        byte[] prev = (byte[])this.cache.remove((Object)this.key);
        if (prev != null) {
            return this.successResp(prev);
        }
        return this.notExistResp();
    }

    Response removeIfUnmodified() {
        CacheEntry entry = this.cache.getCacheEntry((Object)this.key);
        if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(this.params.streamVersion);
            if (entry.getMetadata().version().equals(streamVersion)) {
                boolean removed = this.cache.remove((Object)this.key, (Object)prev);
                if (removed) {
                    return this.successResp(prev);
                }
                return this.notExecutedResp(prev);
            }
            return this.notExecutedResp(prev);
        }
        return this.notExistResp();
    }

    Response clear() {
        this.cache.clear();
        return this.successResp(null);
    }

    Response successResp(byte[] prev) {
        return this.decoder.createSuccessResponse(this.header, prev);
    }

    Response notExecutedResp(byte[] prev) {
        return this.decoder.createNotExecutedResponse(this.header, prev);
    }

    Response notExistResp() {
        return this.decoder.createNotExistResponse(this.header);
    }

    Response createGetResponse(CacheEntry<byte[], byte[]> entry) {
        return this.decoder.createGetResponse(this.header, entry);
    }

    ComponentRegistry getCacheRegistry(String cacheName) {
        return this.server.getCacheRegistry(cacheName);
    }

    private boolean isValid(TransactionWrite write, AdvancedCache<byte[], byte[]> readCache) {
        if (write.skipRead()) {
            if (isTrace) {
                log.tracef("Operation %s wasn't read.", write);
            }
            return true;
        }
        CacheEntry entry = readCache.getCacheEntry((Object)write.key);
        if (write.wasNonExisting()) {
            if (isTrace) {
                log.tracef("Key didn't exist for operation %s. Entry is %s", write, entry);
            }
            return entry == null || entry.getValue() == null;
        }
        if (isTrace) {
            log.tracef("Checking version for operation %s. Entry is %s", write, entry);
        }
        return entry != null && write.versionRead == MetadataUtils.extractVersion(entry);
    }

    private TransactionResponse createTransactionResponse(HotRodHeader header, int xaReturnCode) {
        return new TransactionResponse(header.version, header.messageId, header.cacheName, header.clientIntel, header.op, OperationStatus.Success, header.topologyId, xaReturnCode);
    }

    private void applyCounter(String counterName, Consumer<Response> sendResponse, BiConsumer<StrongCounter, Consumer<Response>> applyStrong, BiConsumer<WeakCounter, Consumer<Response>> applyWeak) {
        CounterConfiguration config = this.counterManager.getConfiguration(counterName);
        if (config == null) {
            sendResponse.accept(this.missingCounterResponse());
            return;
        }
        switch (config.type()) {
            case UNBOUNDED_STRONG: 
            case BOUNDED_STRONG: {
                applyStrong.accept(this.counterManager.getStrongCounter(counterName), sendResponse);
                break;
            }
            case WEAK: {
                applyWeak.accept(this.counterManager.getWeakCounter(counterName), sendResponse);
            }
        }
    }

    private Response createResponseFrom(ListenerOperationStatus status) {
        switch (status) {
            case OK: {
                return Response.createEmptyResponse(this.header, OperationStatus.OperationNotExecuted);
            }
            case OK_AND_CHANNEL_IN_USE: {
                return Response.createEmptyResponse(this.header, OperationStatus.Success);
            }
            case COUNTER_NOT_FOUND: {
                return this.missingCounterResponse();
            }
        }
        throw new IllegalStateException();
    }

    private BiConsumer<Void, Throwable> voidResultHandler(Consumer<Response> sendResponse) {
        return (value, throwable) -> {
            if (throwable != null) {
                this.checkCounterThrowable(sendResponse, (Throwable)throwable);
            } else {
                sendResponse.accept(Response.createEmptyResponse(this.header, OperationStatus.Success));
            }
        };
    }

    static long toMillis(ExpirationParam param, HotRodHeader h) {
        if (param.duration > 0L) {
            long milliseconds = param.unit.toTimeUnit().toMillis(param.duration);
            if (milliseconds > MillisecondsIn30days) {
                long unixTimeExpiry = milliseconds - System.currentTimeMillis();
                return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
            }
            return milliseconds;
        }
        return param.duration;
    }

    static class RequestParameters {
        final int valueLength;
        final ExpirationParam lifespan;
        final ExpirationParam maxIdle;
        final long streamVersion;

        RequestParameters(int valueLength, ExpirationParam lifespan, ExpirationParam maxIdle, long streamVersion) {
            this.valueLength = valueLength;
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
            this.streamVersion = streamVersion;
        }

        public String toString() {
            return "RequestParameters{valueLength=" + this.valueLength + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", streamVersion=" + this.streamVersion + '}';
        }
    }

    static class ExpirationParam {
        final long duration;
        final TimeUnitValue unit;

        ExpirationParam(long duration, TimeUnitValue unit) {
            this.duration = duration;
            this.unit = unit;
        }

        public String toString() {
            return "ExpirationParam{duration=" + this.duration + ", unit=" + (Object)((Object)this.unit) + '}';
        }
    }
}

