/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.net.InetSocketAddress;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.logging.LoggingContextHandler;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public class HotRodAccessLoggingHandler
extends ChannelDuplexHandler {
    private static final Logger log = LogFactory.getLogger((String)"HOTROD_ACCESS_LOG");
    Temporal when;
    private int requestSize = 0;

    public static boolean isEnabled() {
        return log.isTraceEnabled();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.when == null) {
            this.when = ZonedDateTime.now();
        }
        this.requestSize += this.getByteSize(msg);
        ctx.channel().attr(LoggingContextHandler.DECODE_CONTEXT_KEY).set(null);
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.when != null) {
            String who;
            String status;
            String cacheName;
            byte[] key;
            HotRodVersion version;
            HotRodOperation op;
            CacheDecodeContext cacheDecodeContext = (CacheDecodeContext)ctx.channel().attr(LoggingContextHandler.DECODE_CONTEXT_KEY).get();
            String exception = (String)ctx.channel().attr(LoggingContextHandler.EXCEPTION_MESSAGE_KEY).get();
            if (cacheDecodeContext != null && exception == null) {
                op = cacheDecodeContext.getHeader().getOp();
                version = HotRodVersion.forVersion(cacheDecodeContext.getHeader().getVersion());
                key = cacheDecodeContext.getKey();
                cacheName = cacheDecodeContext.getHeader().getCacheName();
                status = "OK";
                who = cacheDecodeContext.getPrincipalName();
            } else {
                op = (HotRodOperation)((Object)ctx.channel().attr(LoggingContextHandler.OPERATION_KEY).get());
                key = null;
                cacheName = (String)ctx.channel().attr(LoggingContextHandler.CACHE_NAME_KEY).get();
                status = exception;
                version = HotRodVersion.UNKNOWN;
                who = null;
            }
            String remoteAddress = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostString();
            Temporal startTime = this.when;
            this.when = null;
            int requestSize = this.requestSize;
            this.requestSize = 0;
            int responseSize = this.getByteSize(msg);
            super.write(ctx, msg, promise.addListener(f -> {
                long duration = startTime == null ? -1L : ChronoUnit.MILLIS.between(startTime, ZonedDateTime.now());
                MDC.clear();
                MDC.put((String)"address", (Object)remoteAddress);
                MDC.put((String)"user", (Object)this.checkForNull(who));
                MDC.put((String)"method", (Object)this.checkForNull((Object)op));
                MDC.put((String)"protocol", (Object)this.checkForNull((Object)version));
                MDC.put((String)"status", (Object)this.checkForNull(status));
                MDC.put((String)"responseSize", (Object)responseSize);
                MDC.put((String)"requestSize", (Object)requestSize);
                MDC.put((String)"duration", (Object)duration);
                log.tracef("/%s/%s", (Object)this.checkForNull(cacheName), (Object)this.checkForNull(key));
            }));
        } else {
            super.write(ctx, msg, promise);
        }
    }

    String checkForNull(Object obj) {
        if (obj == null || obj instanceof String && ((String)obj).isEmpty()) {
            return "-";
        }
        if (obj instanceof byte[]) {
            return Util.printArray((byte[])((byte[])obj));
        }
        return obj.toString();
    }

    int getByteSize(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return -1;
    }
}

