/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.Collections;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.xa.Xid;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.TransactionDecodeContext;
import org.infinispan.util.ByteString;

public abstract class SecondPhaseTransactionDecodeContext
extends TransactionDecodeContext {
    private final ByteString cacheName;

    SecondPhaseTransactionDecodeContext(AdvancedCache<byte[], byte[]> cache, XidImpl xid) {
        super(cache, xid);
        this.cacheName = ByteString.fromString((String)cache.getName());
    }

    public final void perform() throws HeuristicRollbackException, HeuristicMixedException, RollbackException {
        if (this.txState == null) {
            if (this.isTrace()) {
                this.log().tracef("Transaction with XID=%s already finished.", this.xid);
            }
            this.serverTransactionTable.removeLocalTx((Xid)this.xid);
            return;
        }
        Address originator = this.txState.getOriginator();
        if (this.isLocalMode() || this.localAddress.equals(originator)) {
            this.performLocal();
        } else if (this.isAlive(originator)) {
            this.forwardToOriginator();
        } else {
            this.performRemote();
        }
    }

    abstract Log log();

    abstract boolean isTrace();

    protected abstract void performRemote();

    protected abstract void performLocal() throws HeuristicRollbackException, HeuristicMixedException, RollbackException;

    protected abstract CacheRpcCommand buildForwardCommand(ByteString var1);

    private void forwardToOriginator() {
        CacheRpcCommand forwardCommand = this.buildForwardCommand(this.cacheName);
        this.rpcManager.invokeRemotely(Collections.singleton(this.txState.getOriginator()), (ReplicableCommand)forwardCommand, this.rpcManager.getDefaultRpcOptions(true));
    }
}

