/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWriting;

public class BaseRequestProcessor {
    protected final Channel channel;
    protected final Executor executor;

    BaseRequestProcessor(Channel channel, Executor executor) {
        this.channel = channel;
        this.executor = executor;
    }

    protected void writeException(CacheDecodeContext cdc, Throwable cause) {
        if (cause instanceof CompletionException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        this.writeResponse(cdc.createExceptionResponse(cause));
    }

    protected void writeSuccess(CacheDecodeContext cdc, byte[] result) {
        this.writeResponse(cdc.decoder.createSuccessResponse(cdc.header, result));
    }

    protected void writeNotExecuted(CacheDecodeContext cdc, byte[] prev) {
        this.writeResponse(cdc.decoder.createNotExecutedResponse(cdc.header, prev));
    }

    protected void writeNotExist(CacheDecodeContext cdc) {
        this.writeResponse(cdc.decoder.createNotExistResponse(cdc.header));
    }

    protected void writeResponse(Response response) {
        ResponseWriting.writeResponse(this.channel, response);
    }
}

