/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.infinispan.server.hotrod.counter.CounterAddDecodeContext;
import org.infinispan.server.hotrod.counter.CounterDecodeContext;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.util.logging.LogFactory;

public class CounterCompareAndSetDecodeContext
extends CounterDecodeContext {
    private static final Log log = (Log)LogFactory.getLog(CounterAddDecodeContext.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private long expected;
    private long update;
    private DecodeState decodeState = DecodeState.DECODE_EXPECTED;

    public long getExpected() {
        return this.expected;
    }

    public long getUpdate() {
        return this.update;
    }

    @Override
    CounterDecodeContext.DecodeStep nextStep() {
        switch (this.decodeState) {
            case DECODE_UPDATE: {
                return this::decodeUpdate;
            }
            case DECODE_DONE: {
                return null;
            }
            case DECODE_EXPECTED: {
                return this::decodeExpected;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    boolean trace() {
        return trace;
    }

    @Override
    Log log() {
        return log;
    }

    private boolean decodeExpected(ByteBuf buffer) {
        Optional<Long> optValue = ExtendedByteBuf.readMaybeLong(buffer);
        optValue.ifPresent(value -> {
            this.expected = value;
            this.logDecoded("expected-value", value);
            this.decodeState = DecodeState.DECODE_UPDATE;
        });
        return !optValue.isPresent();
    }

    private boolean decodeUpdate(ByteBuf buffer) {
        Optional<Long> optValue = ExtendedByteBuf.readMaybeLong(buffer);
        optValue.ifPresent(value -> {
            this.update = value;
            this.logDecoded("update-value", value);
            this.decodeState = DecodeState.DECODE_DONE;
        });
        return !optValue.isPresent();
    }

    private static enum DecodeState {
        DECODE_EXPECTED,
        DECODE_UPDATE,
        DECODE_DONE;

    }
}

