/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.Executor;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.CounterRequestProcessor;
import org.infinispan.server.hotrod.EmptyResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.MultimapRequestProcessor;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.ResponseWriting;
import org.infinispan.server.hotrod.TaskRequestProcessor;
import org.infinispan.server.hotrod.TransactionRequestProcessor;
import org.infinispan.server.hotrod.logging.Log;

public class ContextHandler
extends SimpleChannelInboundHandler {
    private static final Log log = (Log)LogFactory.getLog(ContextHandler.class, Log.class);
    private final EmbeddedCacheManager cacheManager;
    private final Executor executor;
    private final NettyTransport transport;
    private final HotRodServer server;
    private TransactionRequestProcessor cacheProcessor;
    private CounterRequestProcessor counterProcessor;
    private MultimapRequestProcessor multimapRequestProcessor;
    private TaskRequestProcessor taskRequestProcessor;

    public ContextHandler(EmbeddedCacheManager cacheManager, Executor executor, NettyTransport transport, HotRodServer server) {
        this.cacheManager = cacheManager;
        this.executor = executor;
        this.transport = transport;
        this.server = server;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.cacheProcessor = new TransactionRequestProcessor(ctx.channel(), this.executor, this.server);
        this.counterProcessor = new CounterRequestProcessor(ctx.channel(), (EmbeddedCounterManager)EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager), this.executor, this.server);
        this.multimapRequestProcessor = new MultimapRequestProcessor(ctx.channel(), this.executor);
        this.taskRequestProcessor = new TaskRequestProcessor(ctx.channel(), this.executor, this.server);
    }

    private void initCache(CacheDecodeContext cdc) throws RequestParsingException {
        cdc.resource = this.server.cache(cdc);
    }

    private void initMultimap(CacheDecodeContext cdc) throws RequestParsingException {
        cdc.resource = new EmbeddedMultimapCache(this.server.cache(cdc));
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg.getClass() == CacheDecodeContext.class;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        CacheDecodeContext cdc = (CacheDecodeContext)msg;
        HotRodHeader h = cdc.header;
        switch (h.op) {
            case PUT: {
                this.initCache(cdc);
                this.cacheProcessor.put(cdc);
                break;
            }
            case PUT_IF_ABSENT: {
                this.initCache(cdc);
                this.cacheProcessor.putIfAbsent(cdc);
                break;
            }
            case REPLACE: {
                this.initCache(cdc);
                this.cacheProcessor.replace(cdc);
                break;
            }
            case REPLACE_IF_UNMODIFIED: {
                this.initCache(cdc);
                this.cacheProcessor.replaceIfUnmodified(cdc);
                break;
            }
            case CONTAINS_KEY: {
                this.initCache(cdc);
                this.cacheProcessor.containsKey(cdc);
                break;
            }
            case GET: 
            case GET_WITH_VERSION: {
                this.initCache(cdc);
                this.cacheProcessor.get(cdc);
                break;
            }
            case GET_STREAM: 
            case GET_WITH_METADATA: {
                this.initCache(cdc);
                this.cacheProcessor.getKeyMetadata(cdc);
                break;
            }
            case REMOVE: {
                this.initCache(cdc);
                this.cacheProcessor.remove(cdc);
                break;
            }
            case REMOVE_IF_UNMODIFIED: {
                this.initCache(cdc);
                this.cacheProcessor.removeIfUnmodified(cdc);
                break;
            }
            case PING: {
                this.server.cache(cdc);
                ResponseWriting.writeResponse(ctx.channel(), new EmptyResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.PING, OperationStatus.Success, h.topologyId));
                break;
            }
            case STATS: {
                ResponseWriting.writeResponse(ctx.channel(), cdc.decoder.createStatsResponse(cdc, this.server.cache(cdc).getStats(), this.transport));
                break;
            }
            case CLEAR: {
                this.initCache(cdc);
                this.cacheProcessor.clear(cdc);
                break;
            }
            case EXEC: {
                this.initCache(cdc);
                this.taskRequestProcessor.exec(cdc);
                break;
            }
            case PUT_ALL: {
                this.initCache(cdc);
                this.cacheProcessor.putAll(cdc);
                break;
            }
            case GET_ALL: {
                this.initCache(cdc);
                this.cacheProcessor.getAll(cdc);
                break;
            }
            case PUT_STREAM: {
                this.initCache(cdc);
                this.cacheProcessor.putStream(cdc);
                break;
            }
            case SIZE: {
                this.initCache(cdc);
                this.cacheProcessor.size(cdc);
                break;
            }
            case BULK_GET: {
                this.initCache(cdc);
                this.cacheProcessor.bulkGet(cdc);
                break;
            }
            case BULK_GET_KEYS: {
                this.initCache(cdc);
                this.cacheProcessor.bulkGetKeys(cdc);
                break;
            }
            case QUERY: {
                this.initCache(cdc);
                this.cacheProcessor.query(cdc);
                break;
            }
            case ADD_CLIENT_LISTENER: {
                this.initCache(cdc);
                this.cacheProcessor.addClientListener(cdc);
                break;
            }
            case REMOVE_CLIENT_LISTENER: {
                this.initCache(cdc);
                this.cacheProcessor.removeClientListener(cdc);
                break;
            }
            case ITERATION_START: {
                this.initCache(cdc);
                this.cacheProcessor.iterationStart(cdc);
                break;
            }
            case ITERATION_NEXT: {
                this.initCache(cdc);
                this.cacheProcessor.iterationNext(cdc);
                break;
            }
            case ITERATION_END: {
                this.initCache(cdc);
                this.cacheProcessor.iterationEnd(cdc);
                break;
            }
            case ROLLBACK_TX: {
                this.initCache(cdc);
                this.cacheProcessor.rollbackTransaction(cdc);
                break;
            }
            case PREPARE_TX: {
                this.initCache(cdc);
                this.cacheProcessor.prepareTransaction(cdc);
                break;
            }
            case COMMIT_TX: {
                this.initCache(cdc);
                this.cacheProcessor.commitTransaction(cdc);
                break;
            }
            case COUNTER_CREATE: {
                this.counterProcessor.createCounter(cdc);
                break;
            }
            case COUNTER_GET_CONFIGURATION: {
                this.counterProcessor.getCounterConfiguration(cdc);
                break;
            }
            case COUNTER_IS_DEFINED: {
                this.counterProcessor.isCounterDefined(cdc);
                break;
            }
            case COUNTER_ADD_AND_GET: {
                this.counterProcessor.counterAddAndGet(cdc);
                break;
            }
            case COUNTER_RESET: {
                this.counterProcessor.counterReset(cdc);
                break;
            }
            case COUNTER_GET: {
                this.counterProcessor.counterGet(cdc);
                break;
            }
            case COUNTER_CAS: {
                this.counterProcessor.counterCompareAndSwap(cdc);
                break;
            }
            case COUNTER_REMOVE: {
                this.counterProcessor.counterRemove(cdc);
                break;
            }
            case COUNTER_GET_NAMES: {
                this.counterProcessor.getCounterNames(cdc);
                break;
            }
            case COUNTER_REMOVE_LISTENER: {
                this.counterProcessor.removeCounterListener(cdc);
                break;
            }
            case COUNTER_ADD_LISTENER: {
                this.counterProcessor.addCounterListener(cdc);
                break;
            }
            case CONTAINS_KEY_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.containsKey(cdc);
                break;
            }
            case GET_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.get(cdc);
                break;
            }
            case GET_MULTIMAP_WITH_METADATA: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.getWithMetadata(cdc);
                break;
            }
            case PUT_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.put(cdc);
                break;
            }
            case REMOVE_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.removeKey(cdc);
                break;
            }
            case REMOVE_ENTRY_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.removeEntry(cdc);
                break;
            }
            case SIZE_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.size(cdc);
                break;
            }
            case CONTAINS_ENTRY_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.containsEntry(cdc);
                break;
            }
            case CONTAINS_VALUE_MULTIMAP: {
                this.initMultimap(cdc);
                this.multimapRequestProcessor.containsValue(cdc);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation invoked: " + (Object)((Object)cdc.header.op));
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        log.tracef("Channel %s became active", ctx.channel());
        this.server.getClientListenerRegistry().findAndWriteEvents(ctx.channel());
        this.server.getClientCounterNotificationManager().channelActive(ctx.channel());
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        log.tracef("Channel %s writability changed", ctx.channel());
        this.server.getClientListenerRegistry().findAndWriteEvents(ctx.channel());
        this.server.getClientCounterNotificationManager().channelActive(ctx.channel());
    }
}

