/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.multimap;

import java.util.Collection;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.multimap.MultimapResponse;

public class MultimapGetWithMetadataResponse
extends MultimapResponse<Collection<byte[]>> {
    protected final long dataVersion;
    protected final long created;
    protected final int lifespan;
    protected final long lastUsed;
    protected final int maxIdle;

    public MultimapGetWithMetadataResponse(HotRodHeader header, OperationStatus operationStatus, CacheEntry<WrappedByteArray, Collection<WrappedByteArray>> ce, Collection<byte[]> result) {
        super(header, HotRodOperation.GET_MULTIMAP_WITH_METADATA, operationStatus, result);
        this.dataVersion = MetadataUtils.extractVersion(ce);
        this.created = MetadataUtils.extractCreated(ce);
        this.lifespan = MetadataUtils.extractLifespan(ce);
        this.lastUsed = MetadataUtils.extractLastUsed(ce);
        this.maxIdle = MetadataUtils.extractMaxIdle(ce);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("MultimapGetWithMetadataResponse{").append("version=").append(this.version).append(", messageId=").append(this.messageId).append(", cacheName=").append(this.cacheName).append(", clientIntel=").append(this.clientIntel).append(", operation=").append((Object)this.operation).append(", status=").append((Object)this.status).append(", topologyId=").append(this.topologyId).append(", value=");
        if (this.getResult() != null) {
            sb.append("[");
            ((Collection)this.getResult()).forEach(v -> sb.append(Util.printArray((byte[])v, (boolean)true)));
            sb.append("]");
        } else {
            sb.append("null");
        }
        sb.append(", dataVersion=").append(this.dataVersion).append(", created=").append(this.created).append(", lifespan=").append(this.lifespan).append(", lastUsed=").append(this.lastUsed).append(", maxIdle=").append(this.maxIdle).append("}");
        return sb.toString();
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }
}

