/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.util.Optional;
import javax.transaction.xa.Xid;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.commons.util.Util;
import org.infinispan.server.core.transport.VInt;
import org.infinispan.server.core.transport.VLong;

public class ExtendedByteBuf {
    public static ByteBuf wrappedBuffer(byte[] ... arrays) {
        return Unpooled.wrappedBuffer((byte[][])arrays);
    }

    public static ByteBuf buffer(int capacity) {
        return Unpooled.buffer((int)capacity);
    }

    public static ByteBuf dynamicBuffer() {
        return Unpooled.buffer();
    }

    public static int readUnsignedShort(ByteBuf bf) {
        return bf.readUnsignedShort();
    }

    public static int readUnsignedInt(ByteBuf bf) {
        return VInt.read((ByteBuf)bf);
    }

    public static long readUnsignedLong(ByteBuf bf) {
        return VLong.read((ByteBuf)bf);
    }

    public static byte[] readRangedBytes(ByteBuf bf) {
        int length = ExtendedByteBuf.readUnsignedInt(bf);
        return ExtendedByteBuf.readRangedBytes(bf, length);
    }

    public static byte[] readRangedBytes(ByteBuf bf, int length) {
        if (length > 0) {
            byte[] array = new byte[length];
            bf.readBytes(array);
            return array;
        }
        return new byte[0];
    }

    public static Optional<byte[]> readOptRangedBytes(ByteBuf bf) {
        int length = SignedNumeric.decode((int)ExtendedByteBuf.readUnsignedInt(bf));
        return length < 0 ? Optional.empty() : Optional.of(ExtendedByteBuf.readRangedBytes(bf, length));
    }

    public static Optional<String> readOptString(ByteBuf bf) {
        Optional<byte[]> bytes = ExtendedByteBuf.readOptRangedBytes(bf);
        return bytes.map(b -> new String((byte[])b, CharsetUtil.UTF_8));
    }

    public static String readString(ByteBuf bf) {
        byte[] bytes = ExtendedByteBuf.readRangedBytes(bf);
        return bytes.length > 0 ? new String(bytes, CharsetUtil.UTF_8) : "";
    }

    public static Optional<Byte> readMaybeByte(ByteBuf bf) {
        if (bf.readableBytes() >= 1) {
            return Optional.of(bf.readByte());
        }
        bf.resetReaderIndex();
        return Optional.empty();
    }

    public static Optional<Long> readMaybeLong(ByteBuf bf) {
        if (bf.readableBytes() < 8) {
            bf.resetReaderIndex();
            return Optional.empty();
        }
        return Optional.of(bf.readLong());
    }

    public static Optional<Long> readMaybeVLong(ByteBuf bf) {
        if (bf.readableBytes() >= 1) {
            byte b = bf.readByte();
            return ExtendedByteBuf.read(bf, b, 7, (long)b & 0x7FL, 1);
        }
        bf.resetReaderIndex();
        return Optional.empty();
    }

    private static Optional<Long> read(ByteBuf buf, byte b, int shift, long i, int count) {
        if ((b & 0x80) == 0) {
            return Optional.of(i);
        }
        if (count > 9) {
            throw new IllegalStateException("Stream corrupted.  A variable length long cannot be longer than 9 bytes.");
        }
        if (buf.readableBytes() >= 1) {
            byte bb = buf.readByte();
            return ExtendedByteBuf.read(buf, bb, shift + 7, i | ((long)bb & 0x7FL) << shift, count + 1);
        }
        buf.resetReaderIndex();
        return Optional.empty();
    }

    public static Optional<Integer> readMaybeVInt(ByteBuf bf) {
        if (bf.readableBytes() >= 1) {
            byte b = bf.readByte();
            return ExtendedByteBuf.read(bf, b, 7, b & 0x7F, 1);
        }
        bf.resetReaderIndex();
        return Optional.empty();
    }

    private static Optional<Integer> read(ByteBuf buf, byte b, int shift, int i, int count) {
        if ((b & 0x80) == 0) {
            return Optional.of(i);
        }
        if (count > 5) {
            throw new IllegalStateException("Stream corrupted.  A variable length integer cannot be longer than 5 bytes.");
        }
        if (buf.readableBytes() >= 1) {
            byte bb = buf.readByte();
            return ExtendedByteBuf.read(buf, bb, shift + 7, i | (int)(((long)bb & 0x7FL) << shift), count + 1);
        }
        buf.resetReaderIndex();
        return Optional.empty();
    }

    public static Optional<byte[]> readMaybeRangedBytes(ByteBuf bf) {
        Optional<Integer> length = ExtendedByteBuf.readMaybeVInt(bf);
        if (length.isPresent()) {
            int l = length.get();
            if (bf.readableBytes() >= l) {
                if (l > 0) {
                    byte[] array = new byte[l];
                    bf.readBytes(array);
                    return Optional.of(array);
                }
                return Optional.of(Util.EMPTY_BYTE_ARRAY);
            }
            bf.resetReaderIndex();
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<byte[]> readMaybeRangedBytes(ByteBuf bf, int length) {
        if (bf.readableBytes() < length) {
            bf.resetReaderIndex();
            return Optional.empty();
        }
        byte[] bytes = new byte[length];
        bf.readBytes(bytes);
        return Optional.of(bytes);
    }

    public static Optional<Integer> readMaybeSignedInt(ByteBuf bf) {
        return ExtendedByteBuf.readMaybeVInt(bf).map(SignedNumeric::decode);
    }

    public static Optional<Optional<byte[]>> readMaybeOptRangedBytes(ByteBuf bf) {
        Optional<Integer> l = ExtendedByteBuf.readMaybeSignedInt(bf);
        if (l.isPresent()) {
            int length = l.get();
            if (length < 0) {
                return Optional.of(Optional.empty());
            }
            Optional<byte[]> rb = ExtendedByteBuf.readMaybeRangedBytes(bf, length);
            if (rb.isPresent()) {
                return Optional.of(rb);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<String> readMaybeString(ByteBuf bf) {
        Optional<byte[]> bytes = ExtendedByteBuf.readMaybeRangedBytes(bf);
        return bytes.map(b -> {
            if (((byte[])b).length == 0) {
                return "";
            }
            return new String((byte[])b, CharsetUtil.UTF_8);
        });
    }

    public static Optional<Optional<String>> readMaybeOptString(ByteBuf bf) {
        return ExtendedByteBuf.readMaybeOptRangedBytes(bf).map(optionalBytes -> optionalBytes.map(bytes -> {
            if (((byte[])bytes).length == 0) {
                return "";
            }
            return new String((byte[])bytes, CharsetUtil.UTF_8);
        }));
    }

    public static void writeUnsignedShort(int i, ByteBuf bf) {
        bf.writeShort(i);
    }

    public static void writeUnsignedInt(int i, ByteBuf bf) {
        VInt.write((ByteBuf)bf, (int)i);
    }

    public static void writeUnsignedLong(long l, ByteBuf bf) {
        VLong.write((ByteBuf)bf, (long)l);
    }

    public static void writeRangedBytes(byte[] src, ByteBuf bf) {
        ExtendedByteBuf.writeUnsignedInt(src.length, bf);
        if (src.length > 0) {
            bf.writeBytes(src);
        }
    }

    public static void writeRangedBytes(byte[] src, int offset, ByteBuf bf) {
        int l = src.length - offset;
        ExtendedByteBuf.writeUnsignedInt(l, bf);
        if (l > 0) {
            bf.writeBytes(src);
        }
    }

    public static void writeString(String msg, ByteBuf bf) {
        ExtendedByteBuf.writeRangedBytes(msg.getBytes(CharsetUtil.UTF_8), bf);
    }

    public static void writeString(Optional<String> msg, ByteBuf bf) {
        ExtendedByteBuf.writeRangedBytes(msg.map(m -> m.getBytes(CharsetUtil.UTF_8)).orElse(Util.EMPTY_BYTE_ARRAY), bf);
    }

    public static void writeXid(Xid xid, ByteBuf buffer) {
        VInt.write((ByteBuf)buffer, (int)SignedNumeric.encode((int)xid.getFormatId()));
        ExtendedByteBuf.writeRangedBytes(xid.getGlobalTransactionId(), buffer);
        ExtendedByteBuf.writeRangedBytes(xid.getBranchQualifier(), buffer);
    }
}

