/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodMagicKeyGenerator;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRod11StorageOnlyNodesTest")
public class HotRod11StorageOnlyNodesTest
extends HotRodMultiNodeTest {
    @Override
    protected String cacheName() {
        return "distributed";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration(HotRod11StorageOnlyNodesTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfg.clustering().l1().disable();
        return cfg;
    }

    @Override
    protected byte protocolVersion() {
        return 11;
    }

    protected int virtualNodes() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddingStorageOnlyNode(Method m) throws Exception {
        Optional<Integer> leaveTopologyId;
        HotRodServer server1 = this.servers().get(0);
        HotRodServer server2 = this.servers().get(1);
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        int initialTopologyId = this.currentServerTopologyId();
        TestResponse resp = client1.ping((byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopologyReceived(resp.topologyResponse, this.servers(), this.cacheName(), 2, this.virtualNodes(), initialTopologyId);
        EmbeddedCacheManager newCacheManager = this.addClusterEnabledCacheManager();
        try {
            newCacheManager.defineConfiguration(this.cacheName(), this.createCacheConfig().build());
            newCacheManager.getCache(this.cacheName());
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)true, (CacheContainer[])new CacheContainer[]{this.manager(0), this.manager(1), this.manager(2)});
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName()), this.cache(2, this.cacheName())});
            int joinTopologyId = this.currentServerTopologyId();
            byte[] key1 = HotRodMagicKeyGenerator.newKey(this.cache(0, this.cacheName()));
            resp = client1.put(key1, 0, 0, HotRodTestingUtil.v(m, "v1-"), (byte)3, initialTopologyId);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            HotRodTestingUtil.assertHashTopologyReceived(resp.topologyResponse, this.servers(), this.cacheName(), 2, this.virtualNodes(), joinTopologyId - 1);
            this.log.trace((Object)"Check that the clients do not receive a new topology");
            resp = client1.put(key1, 0, 0, HotRodTestingUtil.v(m, "v1-"), (byte)3, joinTopologyId - 1);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertNull((Object)resp.topologyResponse);
            this.log.trace((Object)"Check that the clients can access a key for which the storage-only node is primary owner");
            byte[] key2 = HotRodMagicKeyGenerator.newKey(this.cache(2, this.cacheName()));
            resp = client1.put(key2, 0, 0, HotRodTestingUtil.v(m, "v2-"), (byte)3, joinTopologyId - 1);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertNull((Object)resp.topologyResponse);
            HotRodTestingUtil.assertSuccess(client2.get(key1, 0), HotRodTestingUtil.v(m, "v1-"));
            HotRodTestingUtil.assertSuccess(client2.get(key2, 0), HotRodTestingUtil.v(m, "v2-"));
            this.log.trace((Object)"Force a topology change by shutting down one of the proper HotRod servers");
            ServerTestingUtil.killServer((AbstractProtocolServer)server2);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.servers().get(1).getCacheManager()});
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)false, (CacheContainer[])new CacheContainer[]{this.manager(0), this.manager(2)});
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(2, this.cacheName())});
            leaveTopologyId = Optional.of(this.currentServerTopologyId());
            resp = client1.put(key1, 0, 0, HotRodTestingUtil.v(m, "v3-"), (byte)3, joinTopologyId - 1);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            HotRodTestingUtil.assertHashTopologyReceived(resp.topologyResponse, Arrays.asList(server1), this.cacheName(), 2, this.virtualNodes(), leaveTopologyId.get() - 1);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{newCacheManager});
            TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)false, (CacheContainer[])new CacheContainer[]{this.manager(0)});
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName())});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{newCacheManager});
        TestingUtil.blockUntilViewsReceived((long)50000L, (boolean)false, (CacheContainer[])new CacheContainer[]{this.manager(0)});
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName())});
        int storageOnlyLeaveTopologyId = this.currentServerTopologyId();
        this.log.trace((Object)"Check that only the topology id changes after the storage-only server is killed");
        resp = client1.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v4-"), (byte)3, leaveTopologyId.get() - 1);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopologyReceived(resp.topologyResponse, Arrays.asList(server1), this.cacheName(), 2, 1, storageOnlyLeaveTopologyId);
        HotRodTestingUtil.assertSuccess(client1.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v4-"));
    }
}

