package org.infinispan.server.hotrod.logging;

import java.util.Locale;
import org.infinispan.distribution.ch.ConsistentHash;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.infinispan.commons.marshall.Marshaller;
import javax.annotation.Generated;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.commons.dataconversion.EncodingException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.infinispan.server.hotrod.MissingFactoryException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.notifications.cachelistener.event.Event;
import java.lang.Object;
import org.infinispan.counter.exception.CounterException;
import java.util.Arrays;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-20T08:28:58+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void exceptionReported(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, exceptionReported$str());
    }
    private static final String exceptionReported = "ISPN005003: Exception reported";
    protected String exceptionReported$str() {
        return exceptionReported;
    }
    @Override
    public final void noMembersInHashTopology(final ConsistentHash ch, final String topologyMap) {
        super.log.logf(FQCN, WARN, null, noMembersInHashTopology$str(), ch, topologyMap);
    }
    private static final String noMembersInHashTopology = "ISPN005019: No members for new topology after applying consistent hash %s filtering into base topology %s";
    protected String noMembersInHashTopology$str() {
        return noMembersInHashTopology;
    }
    @Override
    public final void noMembersInTopology() {
        super.log.logf(FQCN, WARN, null, noMembersInTopology$str());
    }
    private static final String noMembersInTopology = "ISPN005020: No members in new topology";
    protected String noMembersInTopology$str() {
        return noMembersInTopology;
    }
    @Override
    public final void serverEndpointTopologyEmpty(final String clusterMembers) {
        super.log.logf(FQCN, WARN, null, serverEndpointTopologyEmpty$str(), clusterMembers);
    }
    private static final String serverEndpointTopologyEmpty = "ISPN005021: Server endpoint topology is empty, and cluster members are %s";
    protected String serverEndpointTopologyEmpty$str() {
        return serverEndpointTopologyEmpty;
    }
    @Override
    public final void errorWritingResponse(final long msgId, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorWritingResponse$str(), msgId);
    }
    private static final String errorWritingResponse = "ISPN005022: Exception writing response with messageId=%s";
    protected String errorWritingResponse$str() {
        return errorWritingResponse;
    }
    @Override
    public final void errorEncodingMessage(final Object msg, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorEncodingMessage$str(), msg);
    }
    private static final String errorEncodingMessage = "ISPN005023: Exception encoding message %s";
    protected String errorEncodingMessage$str() {
        return errorEncodingMessage;
    }
    @Override
    public final void errorUnexpectedMessage(final Object msg) {
        super.log.logf(FQCN, ERROR, null, errorUnexpectedMessage$str(), msg);
    }
    private static final String errorUnexpectedMessage = "ISPN005024: Request to encode unexpected message %s";
    protected String errorUnexpectedMessage$str() {
        return errorUnexpectedMessage;
    }
    @Override
    public final void viewNullWhileDetectingCrashedMember() {
        super.log.logf(FQCN, WARN, null, viewNullWhileDetectingCrashedMember$str());
    }
    private static final String viewNullWhileDetectingCrashedMember = "ISPN006000: While trying to detect a crashed member, current view returned null";
    protected String viewNullWhileDetectingCrashedMember$str() {
        return viewNullWhileDetectingCrashedMember;
    }
    @Override
    public final void unableToUpdateView() {
        super.log.logf(FQCN, WARN, null, unableToUpdateView$str());
    }
    private static final String unableToUpdateView = "ISPN006001: Unable to update topology view after a crashed member left, wait for next view change.";
    protected String unableToUpdateView$str() {
        return unableToUpdateView;
    }
    @Override
    public final void errorDetectingCrashedMember(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorDetectingCrashedMember$str());
    }
    private static final String errorDetectingCrashedMember = "ISPN006002: Error detecting crashed member";
    protected String errorDetectingCrashedMember$str() {
        return errorDetectingCrashedMember;
    }
    private static final String invalidTopologyCache = "ISPN006003: A topology cache named '%s' has already been defined";
    protected String invalidTopologyCache$str() {
        return invalidTopologyCache;
    }
    @Override
    public final CacheConfigurationException invalidTopologyCache(final String topologyCacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidTopologyCache$str(), topologyCacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIsolationLevel = "ISPN006004: Cannot enable isolation level '%s' with writeSkewCheck disabled";
    protected String invalidIsolationLevel$str() {
        return invalidIsolationLevel;
    }
    @Override
    public final CacheConfigurationException invalidIsolationLevel(final IsolationLevel isolationLevel) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidIsolationLevel$str(), isolationLevel));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverAuthenticationProvider = "ISPN006005: Cannot enable authentication without specifying a ServerAuthenticationProvider";
    protected String serverAuthenticationProvider$str() {
        return serverAuthenticationProvider;
    }
    @Override
    public final CacheConfigurationException serverAuthenticationProvider() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), serverAuthenticationProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAllowedMechs = "ISPN006006: The specified allowedMechs [%s] contains mechs which are unsupported by the underlying factories [%s]";
    protected String invalidAllowedMechs$str() {
        return invalidAllowedMechs;
    }
    @Override
    public final CacheConfigurationException invalidAllowedMechs(final java.util.Set<String> allowedMechs, final java.util.Set<String> allMechs) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidAllowedMechs$str(), allowedMechs, allMechs));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOperation = "ISPN006007: The requested operation is invalid";
    protected String invalidOperation$str() {
        return invalidOperation;
    }
    @Override
    public final UnsupportedOperationException invalidOperation() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), invalidOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingServerName = "ISPN006008: A serverName must be specified when enabling authentication";
    protected String missingServerName$str() {
        return missingServerName;
    }
    @Override
    public final CacheConfigurationException missingServerName() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingServerName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEvent = "ISPN006009: Event not handled by current Hot Rod event implementation: '%s'";
    protected String unexpectedEvent$str() {
        return unexpectedEvent;
    }
    @Override
    public final IllegalStateException unexpectedEvent(final Event e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedEvent$str(), e));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnConditionalOperationNonTransactional(final String op) {
        super.log.logf(FQCN, WARN, null, warnConditionalOperationNonTransactional$str(), op);
    }
    private static final String warnConditionalOperationNonTransactional = "ISPN006010: Conditional operation '%s' should be used with transactional caches, otherwise data inconsistency issues could arise under failure situations";
    protected String warnConditionalOperationNonTransactional$str() {
        return warnConditionalOperationNonTransactional;
    }
    @Override
    public final void warnForceReturnPreviousNonTransactional(final String op) {
        super.log.logf(FQCN, WARN, null, warnForceReturnPreviousNonTransactional$str(), op);
    }
    private static final String warnForceReturnPreviousNonTransactional = "ISPN006011: Operation '%s' forced to return previous value should be used on transactional caches, otherwise data inconsistency issues could arise under failure situations";
    protected String warnForceReturnPreviousNonTransactional$str() {
        return warnForceReturnPreviousNonTransactional;
    }
    @Override
    public final void warnMarshallerAlreadySet(final Marshaller existingMarshaller, final Marshaller newMarshaller) {
        super.log.logf(FQCN, WARN, null, warnMarshallerAlreadySet$str(), existingMarshaller, newMarshaller);
    }
    private static final String warnMarshallerAlreadySet = "ISPN006012: Marshaller already set to '%s', ignoring passed '%s'";
    protected String warnMarshallerAlreadySet$str() {
        return warnMarshallerAlreadySet;
    }
    private static final String missingCacheEventFactory = "ISPN006013: Listener %s factory '%s' not found in server";
    protected String missingCacheEventFactory$str() {
        return missingCacheEventFactory;
    }
    @Override
    public final MissingFactoryException missingCacheEventFactory(final String factoryType, final String name) {
        final MissingFactoryException result = new MissingFactoryException(String.format(getLoggingLocale(), missingCacheEventFactory$str(), factoryType, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalFilterConverterEventFactory = "ISPN006014: Trying to add a filter and converter factory with name '%s' but it does not extend CacheEventFilterConverterFactory";
    protected String illegalFilterConverterEventFactory$str() {
        return illegalFilterConverterEventFactory;
    }
    @Override
    public final IllegalStateException illegalFilterConverterEventFactory(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalFilterConverterEventFactory$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalIterationId = "ISPN006015: Failed iterating, invalid iteration id '%s' found";
    protected String illegalIterationId$str() {
        return illegalIterationId;
    }
    @Override
    public final IllegalStateException illegalIterationId(final String iterationId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalIterationId$str(), iterationId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingKeyValueFilterConverterFactory = "ISPN006016: Factory '%s' not found in server";
    protected String missingKeyValueFilterConverterFactory$str() {
        return missingKeyValueFilterConverterFactory;
    }
    @Override
    public final IllegalStateException missingKeyValueFilterConverterFactory(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingKeyValueFilterConverterFactory$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorizedOperation = "ISPN006017: Unauthorized operation";
    protected String unauthorizedOperation$str() {
        return unauthorizedOperation;
    }
    @Override
    public final SecurityException unauthorizedOperation() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unauthorizedOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String externalMechNotAllowedWithoutSSLClientCert = "ISPN006018: EXTERNAL SASL mechanism not allowed without SSL client certificate";
    protected String externalMechNotAllowedWithoutSSLClientCert$str() {
        return externalMechNotAllowedWithoutSSLClientCert;
    }
    @Override
    public final SecurityException externalMechNotAllowedWithoutSSLClientCert() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), externalMechNotAllowedWithoutSSLClientCert$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingHostAddress = "ISPN006019: A host or proxyHost address has not been specified";
    protected String missingHostAddress$str() {
        return missingHostAddress;
    }
    @Override
    public final CacheConfigurationException missingHostAddress() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingHostAddress$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedTransactionalCache = "ISPN006020: Cache '%s' is not transactional to execute a client transaction";
    protected String expectedTransactionalCache$str() {
        return expectedTransactionalCache;
    }
    @Override
    public final IllegalStateException expectedTransactionalCache(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expectedTransactionalCache$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedIsolationLevel = "ISPN006021: Cache '%s' must have REPEATABLE_READ isolation level";
    protected String unexpectedIsolationLevel$str() {
        return unexpectedIsolationLevel;
    }
    @Override
    public final IllegalStateException unexpectedIsolationLevel(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedIsolationLevel$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidWeakCounter = "ISPN028023: Expects a STRONG counter for '%s'";
    protected String invalidWeakCounter$str() {
        return invalidWeakCounter;
    }
    @Override
    public final CounterException invalidWeakCounter(final String name) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidWeakCounter$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void skippingMarshallerWrapping(final String mediaType) {
        super.log.logf(FQCN, WARN, null, skippingMarshallerWrapping$str(), mediaType);
    }
    private static final String skippingMarshallerWrapping = "ISPN028024: Not wrapping custom marshaller with media type '%s' since the format is already supported by the server";
    protected String skippingMarshallerWrapping$str() {
        return skippingMarshallerWrapping;
    }
    private static final String errorSerializingResponse = "ISPN028025: Error serializing script response '%s'";
    protected String errorSerializingResponse$str() {
        return errorSerializingResponse;
    }
    @Override
    public final EncodingException errorSerializingResponse(final Object o) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorSerializingResponse$str(), o));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
