/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.memcached.MemcachedDecoder;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.logging.Log;

@Deprecated
public class MemcachedServer
extends AbstractProtocolServer<MemcachedServerConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(MemcachedServer.class, Log.class);
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private AdvancedCache<byte[], byte[]> memcachedCache;

    public MemcachedServer() {
        super("Memcached");
    }

    protected void startInternal() {
        ExpirationConfiguration expConfig;
        if (this.cacheManager.getCacheConfiguration(((MemcachedServerConfiguration)this.configuration).defaultCacheName()) == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            Configuration defaultCacheConfiguration = this.cacheManager.getDefaultCacheConfiguration();
            if (defaultCacheConfiguration != null) {
                builder.read(defaultCacheConfiguration);
            } else if (this.cacheManager.getCacheManagerConfiguration().isClustered()) {
                builder.clustering().cacheMode(CacheMode.REPL_SYNC);
            }
            this.cacheManager.defineConfiguration(((MemcachedServerConfiguration)this.configuration).defaultCacheName(), builder.build());
        }
        if ((expConfig = this.cacheManager.getCacheConfiguration(((MemcachedServerConfiguration)this.configuration).defaultCacheName()).expiration()).lifespan() >= 0L || expConfig.maxIdle() >= 0L) {
            throw log.invalidExpiration(((MemcachedServerConfiguration)this.configuration).defaultCacheName());
        }
        Cache cache = this.cacheManager.getCache(((MemcachedServerConfiguration)this.configuration).defaultCacheName());
        this.memcachedCache = cache.getAdvancedCache();
        super.startInternal();
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return new MemcachedDecoder(this.memcachedCache, this.scheduler, this.transport, arg_0 -> ((MemcachedServer)this).isCacheIgnored(arg_0), ((MemcachedServerConfiguration)this.configuration).clientEncoding());
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), this.getDecoder())});
    }

    public void stop() {
        super.stop();
        this.scheduler.shutdown();
    }

    public Cache<byte[], byte[]> getCache() {
        return this.memcachedCache;
    }
}

