/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.util.List;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.binary.BinaryAuthDecoder;
import org.infinispan.server.memcached.binary.BinaryCommand;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.binary.BinaryIntrinsics;

public class BinaryAuthDecoderImpl
extends BinaryAuthDecoder {
    private int state;
    private int requestBytes;
    private long mc_long;
    private byte mc_dataType;
    private short mc_vbucketId;
    private int mc_opaque;
    private BinaryCommand mc_op;
    private int mc_totalBodyLength;
    private int mc_int;
    private int mc_verbosity;
    private BinaryHeader mc_header;
    private long mc_cas;
    private BinaryCommand mc_opCode;
    private byte[] mc_fixedArray;
    private byte mc_byte;
    private long mc_initial;
    private byte[] mc_key;
    private byte mc_magic;
    private short mc_keyLength;
    private long mc_delta;
    private byte[] mc_value;
    private short mc_short;
    private int mc_valueLength;
    private byte mc_extrasLength;
    private boolean deadEnd = false;

    public BinaryAuthDecoderImpl(MemcachedServer server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            while (this.switch0(buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch0(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_magic = this.mc_byte;
                this.state = 2;
            }
            case 2: {
                this.requestStart = Instant.now();
                this.state = 3;
            }
            case 3: {
                if (this.mc_magic != -128) {
                    this.state = 5;
                    return true;
                }
                this.deadEnd = false;
                this.state = 6;
                return true;
            }
            case 4: {
                if (log.isTraceEnabled()) {
                    log.tracef("Parsed header: %s", this.mc_header);
                }
                this.state = 14;
                return true;
            }
            case 5: {
                throw new IllegalStateException("Error reading magic byte or message id: " + this.mc_magic);
            }
            case 6: {
                int pos = buf.readerIndex();
                this.mc_opCode = BinaryIntrinsics.opCode(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_op = this.mc_opCode;
                this.state = 7;
            }
            case 7: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keyLength = this.mc_short;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_extrasLength = this.mc_byte;
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_dataType = this.mc_byte;
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vbucketId = this.mc_short;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_totalBodyLength = this.mc_int;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_opaque = this.mc_int;
                this.state = 13;
            }
            case 13: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_cas = this.mc_long;
                this.mc_valueLength = this.mc_totalBodyLength - this.mc_keyLength - this.mc_extrasLength;
                this.mc_header = this.acquireHeader().replace(this.requestStart, this.requestBytes, this.principalName, this.mc_key, this.mc_opCode, this.mc_opaque, this.mc_cas);
                this.state = 4;
                return true;
            }
            case 14: {
                switch (this.mc_op) {
                    case SASL_LIST_MECHS: {
                        this.state = 15;
                        return true;
                    }
                    case SASL_AUTH: {
                        this.state = 16;
                        return true;
                    }
                    case SASL_STEP: {
                        this.state = 21;
                        return true;
                    }
                    case CONFIG_GET: {
                        this.state = 26;
                        return true;
                    }
                }
                throw new IllegalArgumentException("Unknown operation " + String.valueOf((Object)this.mc_op));
            }
            case 15: {
                if (out.add(this.saslListMechs(this.mc_header))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 16: {
                if (this.mc_keyLength > 0) {
                    this.state = 18;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 17;
            }
            case 17: {
                if (this.mc_valueLength > 0) {
                    this.state = 20;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 19;
                return true;
            }
            case 18: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 17;
                return true;
            }
            case 19: {
                if (out.add(this.saslAuth(this.mc_header, this.mc_key, this.mc_value))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 20: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 19;
                return true;
            }
            case 21: {
                if (this.mc_keyLength > 0) {
                    this.state = 23;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 22;
            }
            case 22: {
                if (this.mc_valueLength > 0) {
                    this.state = 25;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 24;
                return true;
            }
            case 23: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 22;
                return true;
            }
            case 24: {
                if (out.add(this.saslStep(this.mc_header, this.mc_key, this.mc_value))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 25: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 24;
                return true;
            }
            case 26: {
                if (this.mc_keyLength > 0) {
                    this.state = 28;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 27;
            }
            case 27: {
                if (out.add(this.config(this.mc_header, this.mc_key))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 28: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 27;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            log.tracef("Invalid state of parsing", new Object[0]);
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(Throwable t) throws Exception {
        log.trace("Parsing error", t);
        this.state = 0;
    }

    private void reset() {
        this.requestBytes = 0;
        this.mc_long = 0L;
        this.mc_dataType = 0;
        this.mc_vbucketId = 0;
        this.mc_opaque = 0;
        this.mc_op = null;
        this.mc_totalBodyLength = 0;
        this.mc_int = 0;
        this.mc_verbosity = 0;
        this.mc_header = null;
        this.mc_cas = 0L;
        this.mc_opCode = null;
        this.mc_fixedArray = null;
        this.mc_byte = 0;
        this.mc_initial = 0L;
        this.mc_key = null;
        this.mc_magic = 0;
        this.mc_keyLength = 0;
        this.mc_delta = 0L;
        this.mc_value = null;
        this.mc_short = 0;
        this.mc_valueLength = 0;
        this.mc_extrasLength = 0;
    }

    public int requestBytes() {
        return this.requestBytes;
    }
}

