/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.SimpleImmutableEntry;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedStats;
import org.infinispan.server.memcached.MemcachedStatus;
import org.infinispan.server.memcached.ParseUtil;
import org.infinispan.server.memcached.binary.BinaryCommand;
import org.infinispan.server.memcached.binary.BinaryDecoder;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.SerializableBiFunction;
import org.jgroups.util.CompletableFutures;

abstract class BinaryOpDecoder
extends BinaryDecoder {
    protected BinaryOpDecoder(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    protected MemcachedResponse get(BinaryHeader header, byte[] key, boolean quiet) {
        CompletableFuture cs = this.cache.getCacheEntryAsync((Object)key);
        if (CompletionStages.isCompletedSuccessfully((CompletionStage)cs)) {
            this.handleGet((CacheEntry<byte[], byte[]>)((CacheEntry)CompletionStages.join((CompletionStage)cs)), header, key, quiet);
            return this.send(header, CompletableFutures.completedNull());
        }
        return this.send(header, cs.thenAccept(e -> this.handleGet((CacheEntry<byte[], byte[]>)e, header, key, quiet)));
    }

    private void handleGet(CacheEntry<byte[], byte[]> e, BinaryHeader header, byte[] key, boolean quiet) {
        boolean withKey;
        boolean bl = withKey = header.getCommand() == BinaryCommand.GETK || header.getCommand() == BinaryCommand.GETKQ;
        if (e == null) {
            if (!quiet) {
                this.response(header, MemcachedStatus.KEY_NOT_FOUND, withKey ? key : Util.EMPTY_BYTE_ARRAY, Util.EMPTY_BYTE_ARRAY);
            }
        } else {
            MemcachedMetadata metadata = (MemcachedMetadata)e.getMetadata();
            header.setCas(((NumericVersion)metadata.version()).getVersion());
            this.response(header, MemcachedStatus.NO_ERROR, metadata.flags, withKey ? key : Util.EMPTY_BYTE_ARRAY, (byte[])e.getValue());
        }
    }

    protected MemcachedResponse set(BinaryHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(flags, expiration);
        if (header.getCas() == 0L) {
            CompletableFuture cs = this.cache.withFlags(Flag.IGNORE_RETURN_VALUES).putAsync((Object)key, (Object)value, metadata);
            if (CompletionStages.isCompletedSuccessfully((CompletionStage)cs)) {
                this.storeResponse(header, quiet, metadata);
                return this.send(header, CompletableFutures.completedNull());
            }
            return this.send(header, cs.thenAccept(ignore -> this.storeResponse(header, quiet, metadata)));
        }
        CompletableFuture cs = this.cache.getCacheEntryAsync((Object)key);
        if (CompletionStages.isCompletedSuccessfully((CompletionStage)cs)) {
            return this.send(header, this.handleSet((CacheEntry<byte[], byte[]>)((CacheEntry)CompletionStages.join((CompletionStage)cs)), metadata, header, key, value, flags, expiration, quiet));
        }
        CompletionStage response = this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> this.handleSet((CacheEntry<byte[], byte[]>)e, metadata, header, key, value, flags, expiration, quiet));
        return this.send(header, response);
    }

    private CompletionStage<Void> handleSet(CacheEntry<byte[], byte[]> e, Metadata metadata, BinaryHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        if (e == null) {
            this.response(header, MemcachedStatus.KEY_NOT_FOUND);
            return CompletableFutures.completedNull();
        }
        long version = ((NumericVersion)e.getMetadata().version()).getVersion();
        if (version == header.getCas()) {
            return this.cache.replaceAsync((Object)key, (Object)((byte[])e.getValue()), (Object)value, metadata).thenAccept(ignore -> this.storeResponse(header, quiet, metadata));
        }
        this.response(header, MemcachedStatus.KEY_EXISTS);
        return CompletableFutures.completedNull();
    }

    protected MemcachedResponse add(BinaryHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(flags, expiration);
        CompletionStage response = this.cache.putIfAbsentAsyncEntry((Object)key, (Object)value, metadata).thenAccept(e -> {
            if (e != null) {
                this.response(header, MemcachedStatus.KEY_EXISTS);
            } else {
                this.storeResponse(header, quiet, metadata);
            }
        });
        return this.send(header, response);
    }

    protected MemcachedResponse replace(BinaryHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(flags, expiration);
        CompletionStage response = header.getCas() == 0L ? this.cache.replaceAsync((Object)key, (Object)value, metadata).thenAccept(e -> {
            if (e == null) {
                this.response(header, MemcachedStatus.KEY_NOT_FOUND);
            } else {
                this.storeResponse(header, quiet, metadata);
            }
        }) : this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                MemcachedStats.CAS_MISSES.incrementAndGet(this.statistics);
                this.response(header, MemcachedStatus.KEY_NOT_FOUND);
                return CompletableFutures.completedNull();
            }
            long version = ((NumericVersion)metadata.version()).getVersion();
            if (header.getCas() == version) {
                return this.cache.replaceAsync((Object)key, (Object)((byte[])e.getValue()), (Object)value, metadata).thenAccept(ignore -> {
                    MemcachedStats.CAS_HITS.incrementAndGet(this.statistics);
                    this.storeResponse(header, quiet, metadata);
                });
            }
            MemcachedStats.CAS_BADVAL.incrementAndGet(this.statistics);
            this.response(header, MemcachedStatus.ITEM_NOT_STORED);
            return CompletableFutures.completedNull();
        });
        return this.send(header, response);
    }

    private void storeResponse(BinaryHeader header, boolean quiet, Metadata metadata) {
        if (quiet) {
            return;
        }
        header.setCas(((NumericVersion)metadata.version()).getVersion());
        this.response(header, MemcachedStatus.NO_ERROR);
    }

    protected MemcachedResponse delete(BinaryHeader header, byte[] key, boolean quiet) {
        CompletionStage response = header.getCas() == 0L ? this.cache.removeAsync((Object)key).thenAccept(v -> {
            if (v != null && quiet) {
                return;
            }
            this.response(header, v == null ? MemcachedStatus.KEY_NOT_FOUND : MemcachedStatus.DELETED);
        }) : this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                this.response(header, MemcachedStatus.KEY_NOT_FOUND);
                return CompletableFutures.completedNull();
            }
            long version = ((NumericVersion)e.getMetadata().version()).getVersion();
            if (header.getCas() == version) {
                return this.cache.removeAsync((Object)key, e.getValue()).thenAccept(d -> {
                    if (d.booleanValue()) {
                        if (!quiet) {
                            this.response(header, MemcachedStatus.DELETED);
                        }
                    } else {
                        this.response(header, MemcachedStatus.KEY_EXISTS);
                    }
                });
            }
            this.response(header, MemcachedStatus.KEY_EXISTS);
            return CompletableFutures.completedNull();
        });
        return this.send(header, response);
    }

    protected MemcachedResponse increment(BinaryHeader header, byte[] key, long delta, long initial, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(0, expiration);
        CompletableFuture f = expiration == -1 ? this.cache.computeIfPresentAsync((Object)key, (SerializableBiFunction & Serializable)(k, v) -> BinaryOpDecoder.increment(delta, v), metadata) : this.cache.mergeAsync((Object)key, (Object)ParseUtil.writeAsciiLong(initial), (SerializableBiFunction & Serializable)(v1, v2) -> BinaryOpDecoder.increment(delta, v1), metadata);
        CompletionStage response = f.thenAccept(v -> {
            if (v == null) {
                if (this.statsEnabled) {
                    if (delta > 0L) {
                        MemcachedStats.INCR_MISSES.incrementAndGet(this.statistics);
                    } else {
                        MemcachedStats.DECR_MISSES.incrementAndGet(this.statistics);
                    }
                }
                this.response(header, MemcachedStatus.KEY_NOT_FOUND);
                return;
            }
            if (this.statsEnabled) {
                if (delta > 0L) {
                    MemcachedStats.INCR_HITS.incrementAndGet(this.statistics);
                } else {
                    MemcachedStats.DECR_HITS.incrementAndGet(this.statistics);
                }
            }
            if (quiet) {
                return;
            }
            header.setCas(((NumericVersion)metadata.version()).getVersion());
            this.response(header, MemcachedStatus.NO_ERROR, ParseUtil.readLong(v));
        });
        return this.send(header, response);
    }

    private static byte[] increment(long delta, byte[] v1) {
        long l = ParseUtil.readLong(v1);
        if ((l += delta) < 0L) {
            l = 0L;
        }
        return ParseUtil.writeAsciiLong(l);
    }

    protected MemcachedResponse append(BinaryHeader header, byte[] key, byte[] value, boolean quiet) {
        CompletionStage response = this.cache.computeIfPresentAsync((Object)key, (SerializableBiFunction & Serializable)(k, v) -> {
            byte[] r = Arrays.copyOf(v, ((byte[])v).length + value.length);
            System.arraycopy(value, 0, r, ((byte[])v).length, value.length);
            return r;
        }, null).thenAccept(v -> {
            if (!quiet) {
                this.response(header, v == null ? MemcachedStatus.KEY_NOT_FOUND : MemcachedStatus.NO_ERROR);
            }
        });
        return this.send(header, response);
    }

    protected MemcachedResponse prepend(BinaryHeader header, byte[] key, byte[] value, boolean quiet) {
        CompletionStage response = this.cache.computeIfPresentAsync((Object)key, (SerializableBiFunction & Serializable)(k, v) -> {
            byte[] r = Arrays.copyOf(value, ((byte[])v).length + value.length);
            System.arraycopy(v, 0, r, value.length, ((byte[])v).length);
            return r;
        }, null).thenAccept(v -> {
            if (!quiet) {
                this.response(header, v == null ? MemcachedStatus.KEY_NOT_FOUND : MemcachedStatus.NO_ERROR);
            }
        });
        return this.send(header, response);
    }

    protected MemcachedResponse quit(BinaryHeader header, boolean quiet) {
        if (quiet) {
            this.ctx.close();
            return null;
        }
        this.response(header, MemcachedStatus.NO_ERROR);
        return this.send(header, CompletableFutures.completedNull(), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)v -> this.ctx.close()));
    }

    protected MemcachedResponse version(BinaryHeader header) {
        this.response(header, MemcachedStatus.NO_ERROR, Version.getVersion().getBytes(StandardCharsets.US_ASCII));
        return this.send(header, CompletableFutures.completedNull());
    }

    protected MemcachedResponse noop(BinaryHeader header) {
        this.response(header, MemcachedStatus.NO_ERROR);
        return this.send(header, CompletableFutures.completedNull());
    }

    protected MemcachedResponse touch(BinaryHeader header, byte[] key, int expiration) {
        CompletionStage r = this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                this.response(header, MemcachedStatus.KEY_NOT_FOUND);
                return CompletableFutures.completedNull();
            }
            return this.cache.replaceAsync((Object)((byte[])e.getKey()), (Object)((byte[])e.getValue()), this.touchMetadata((CacheEntry<?, ?>)e, expiration)).thenAccept(ignore -> this.response(header, MemcachedStatus.NO_ERROR));
        });
        return this.send(header, r);
    }

    protected MemcachedResponse gat(BinaryHeader header, byte[] key, int expiration, boolean quiet) {
        CompletionStage r = this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            boolean withKey;
            boolean bl = withKey = header.getCommand() == BinaryCommand.GATK || header.getCommand() == BinaryCommand.GATKQ;
            if (e == null) {
                if (!quiet) {
                    this.response(header, MemcachedStatus.KEY_NOT_FOUND, withKey ? key : Util.EMPTY_BYTE_ARRAY, Util.EMPTY_BYTE_ARRAY);
                }
                return CompletableFutures.completedNull();
            }
            MemcachedMetadata metadata = (MemcachedMetadata)e.getMetadata();
            header.setCas(((NumericVersion)metadata.version()).getVersion());
            return this.cache.replaceAsync((Object)((byte[])e.getKey()), (Object)((byte[])e.getValue()), this.touchMetadata((CacheEntry<?, ?>)e, expiration)).thenAccept(ignore -> this.response(header, MemcachedStatus.NO_ERROR, metadata.flags, withKey ? (byte[])e.getKey() : Util.EMPTY_BYTE_ARRAY, (byte[])e.getValue()));
        });
        return this.send(header, r);
    }

    protected MemcachedResponse stat(BinaryHeader header, byte[] key) {
        CompletionStage s = this.server.getBlockingManager().supplyBlocking(() -> {
            Map<byte[], byte[]> map = this.statsMap();
            if (key != null) {
                if (!map.containsKey(key)) {
                    this.response(header, MemcachedStatus.KEY_NOT_FOUND);
                } else {
                    this.singleStat(header, (Map.Entry<byte[], byte[]>)new SimpleImmutableEntry((Object)key, (Object)map.get(key)));
                }
            } else {
                for (Map.Entry<byte[], byte[]> e : map.entrySet()) {
                    this.singleStat(header, e);
                }
                this.response(header, MemcachedStatus.NO_ERROR);
            }
            return null;
        }, (Object)"memcached-stats");
        return this.send(header, s);
    }

    private void singleStat(BinaryHeader header, Map.Entry<byte[], byte[]> e) {
        this.response(header, MemcachedStatus.NO_ERROR, e.getKey(), e.getValue());
    }

    protected MemcachedResponse flush(BinaryHeader header, int expiration, boolean quiet) {
        CompletableFuture<Object> future;
        if (expiration == 0) {
            future = this.cache.clearAsync();
        } else {
            this.server.getBlockingManager().scheduleRunBlocking(() -> ((AdvancedCache)this.cache).clear(), this.toMillis(expiration), TimeUnit.MILLISECONDS, (Object)"memcached-flush");
            future = CompletableFuture.completedFuture(null);
        }
        if (quiet) {
            return null;
        }
        return this.send(header, future.thenAccept(ignore -> this.response(header, MemcachedStatus.NO_ERROR)));
    }

    protected MemcachedResponse verbosityLevel(BinaryHeader header, int verbosity) {
        this.response(header, MemcachedStatus.NO_ERROR);
        return this.send(header, CompletableFutures.completedNull());
    }
}

