/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.util.BitSet;

public class TokenReader
implements ByteProcessor {
    private final ByteBuf output;
    private BitSet token;
    private boolean found;
    private int bytesRead = 0;

    public TokenReader(ByteBuf output) {
        this.output = output;
    }

    public void release() {
        this.output.release();
    }

    public TokenReader forToken(BitSet token) {
        this.found = false;
        this.bytesRead = 0;
        this.output.resetReaderIndex().resetWriterIndex();
        this.token = token;
        return this;
    }

    public ByteBuf output() {
        if (this.output.writerIndex() == 0) {
            return null;
        }
        return this.output.resetReaderIndex();
    }

    public int readBytesSize() {
        return this.bytesRead;
    }

    public boolean process(byte b) throws Exception {
        if (this.found) {
            return false;
        }
        if (!this.output.isWritable()) {
            return false;
        }
        ++this.bytesRead;
        if (b == 32) {
            this.found = true;
            return true;
        }
        if (b == 10) {
            return false;
        }
        if (b == 13) {
            if (this.output.writerIndex() > 0) {
                --this.bytesRead;
                return false;
            }
            return true;
        }
        if (!this.token.get(b & 0xFF)) {
            return false;
        }
        this.output.writeByte((int)b);
        return true;
    }
}

