/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.configuration.AuthenticationConfiguration;
import org.infinispan.server.core.configuration.EncryptionConfiguration;
import org.infinispan.server.core.configuration.IpFilterConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;

@BuiltBy(value=MemcachedServerConfigurationBuilder.class)
@ConfigurationFor(value=MemcachedServer.class)
public class MemcachedServerConfiguration
extends ProtocolServerConfiguration<MemcachedServerConfiguration, MemcachedAuthenticationConfiguration> {
    public static final int DEFAULT_MEMCACHED_PORT = 11211;
    public static final String DEFAULT_MEMCACHED_CACHE = "memcachedCache";
    public static final AttributeDefinition<MediaType> CLIENT_ENCODING = AttributeDefinition.builder((String)"client-encoding", (Object)MediaType.APPLICATION_OCTET_STREAM, MediaType.class).immutable().build();
    public static final AttributeDefinition<MemcachedProtocol> PROTOCOL = AttributeDefinition.builder((String)"protocol", (Object)((Object)MemcachedProtocol.AUTO), MemcachedProtocol.class).immutable().build();
    private final EncryptionConfiguration encryption;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(MemcachedServerConfiguration.class, ProtocolServerConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{CLIENT_ENCODING, PROTOCOL});
    }

    MemcachedServerConfiguration(AttributeSet attributes, MemcachedAuthenticationConfiguration authentication, SslConfiguration ssl, EncryptionConfiguration encryptionConfiguration, IpFilterConfiguration ipRules) {
        super("memcached-connector", attributes, (AuthenticationConfiguration)authentication, ssl, ipRules);
        this.encryption = encryptionConfiguration;
    }

    public EncryptionConfiguration encryption() {
        return this.encryption;
    }

    public MediaType clientEncoding() {
        return (MediaType)this.attributes.attribute(CLIENT_ENCODING).get();
    }

    public MemcachedProtocol protocol() {
        return (MemcachedProtocol)((Object)this.attributes.attribute(PROTOCOL).get());
    }
}

