/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Commands;
import org.infinispan.server.resp.commands.Resp3Command;

public class COMMAND
extends RespCommand
implements Resp3Command {
    public static final String NAME = "COMMAND";

    public COMMAND() {
        super(NAME, -1, 0, 0, 0);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        if (!arguments.isEmpty()) {
            ByteBufferUtils.stringToByteBufAscii("-ERR COMMAND does not currently support arguments\r\n", handler.allocator());
        } else {
            StringBuilder commandBuilder = new StringBuilder();
            List<RespCommand> commands = Commands.all();
            commandBuilder.append("*");
            commandBuilder.append(commands.size());
            commandBuilder.append("\r\n");
            for (RespCommand command : commands) {
                this.addCommand(commandBuilder, command);
            }
            ByteBufferUtils.stringToByteBufAscii(commandBuilder.toString(), handler.allocator());
        }
        return handler.myStage();
    }

    private void addCommand(StringBuilder builder, RespCommand command) {
        builder.append("*6\r\n");
        builder.append("$").append(ByteBufUtil.utf8Bytes((CharSequence)command.getName())).append("\r\n").append(command.getName()).append("\r\n");
        builder.append(":").append(command.getArity()).append("\r\n");
        builder.append("*0\r\n");
        builder.append(":").append(command.getFirstKeyPos()).append("\r\n");
        builder.append(":").append(command.getLastKeyPos()).append("\r\n");
        builder.append(":").append(command.getSteps()).append("\r\n");
    }
}

