/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset.internal;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.sortedset.ZSetCommonUtils;
import org.infinispan.util.concurrent.CompletionStages;

public abstract class DIFF
extends RespCommand
implements Resp3Command {
    protected DIFF(int arity, int firstKeyPos, int lastKeyPos, int steps) {
        super(arity, firstKeyPos, lastKeyPos, steps);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        int numberOfKeysArg;
        int pos = 0;
        byte[] destination = this.getArity() == -4 ? arguments.get(pos++) : null;
        try {
            numberOfKeysArg = ArgumentUtils.toInt(arguments.get(pos++));
        }
        catch (NumberFormatException ex) {
            RespErrorUtil.valueNotInteger(handler.allocator());
            return handler.myStage();
        }
        if (numberOfKeysArg <= 0) {
            RespErrorUtil.customError("at least 1 input key is needed for '" + this.getName().toLowerCase() + "' command", handler.allocator());
            return handler.myStage();
        }
        boolean withScores = this.getArity() == -3 ? ZSetCommonUtils.isWithScoresArg(arguments.get(arguments.size() - 1)) : false;
        if (this.invalidNumberOfKeys(arguments, numberOfKeysArg, withScores)) {
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache = handler.getSortedSeMultimap();
        CompletionStage diffScoreValues = sortedSetCache.getValueAsList((Object)arguments.get(pos++));
        for (int i = 1; i < numberOfKeysArg; ++i) {
            byte[] setName = arguments.get(pos++);
            diffScoreValues = CompletionStages.handleAndCompose((CompletionStage)diffScoreValues, (c1, t1) -> {
                if (t1 != null) {
                    return CompletableFuture.failedFuture(t1);
                }
                if (c1 == null || c1.isEmpty()) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                return sortedSetCache.getValuesSet((Object)setName).handle((c2, t2) -> {
                    if (c2 == null || c2.isEmpty()) {
                        return c1;
                    }
                    return c1.stream().filter(e -> !c2.contains(e.wrappedValue())).collect(Collectors.toList());
                });
            });
        }
        CompletionStage cs = diffScoreValues.thenCompose(result -> destination != null ? sortedSetCache.addMany((Object)destination, (Collection)result, SortedSetAddArgs.create().replace().build()) : CompletableFuture.completedFuture(ZSetCommonUtils.mapResultsToArrayList(result, withScores)));
        return handler.stageToReturn(cs, ctx, Consumers.LONG_ELSE_COLLECTION);
    }

    private boolean invalidNumberOfKeys(List<byte[]> arguments, int numberOfKeys, boolean withScores) {
        int excludeCount = this.getArity() == -4 || withScores ? 2 : 1;
        return arguments.size() - excludeCount != numberOfKeys;
    }
}

