/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.hll;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.hll.internal.CompactSet;
import org.infinispan.server.resp.hll.internal.ExplicitSet;
import org.infinispan.server.resp.hll.internal.HLLRepresentation;

@ThreadSafe
@ProtoTypeId(value=6101)
public class HyperLogLog {
    @GuardedBy(value="this")
    private ExplicitSet explicit;
    @GuardedBy(value="this")
    private CompactSet compact;

    public HyperLogLog() {
    }

    @ProtoFactory
    HyperLogLog(ExplicitSet explicit, CompactSet compact) {
        this.explicit = explicit;
        this.compact = compact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(byte[] data) {
        boolean ret;
        ExplicitSet src = null;
        HyperLogLog hyperLogLog = this;
        synchronized (hyperLogLog) {
            if (this.compact != null) {
                return this.compact.set(data);
            }
            if (this.explicit == null) {
                this.explicit = new ExplicitSet();
            }
            try {
                ret = this.explicit.set(data);
            }
            finally {
                if (this.explicit.needsMigration()) {
                    src = this.explicit;
                    this.explicit = null;
                    this.compact = new CompactSet();
                }
            }
        }
        if (src != null) {
            src.migrate(this.compact);
        }
        return ret;
    }

    public long cardinality() {
        HLLRepresentation representation = this.store();
        return representation == null ? 0L : representation.cardinality();
    }

    synchronized HLLRepresentation store() {
        if (this.compact != null) {
            return this.compact;
        }
        if (this.explicit != null) {
            return this.explicit;
        }
        return null;
    }

    @ProtoField(number=1)
    ExplicitSet explicit() {
        return this.explicit;
    }

    @ProtoField(number=2)
    CompactSet compact() {
        return this.compact;
    }
}

