package org.infinispan.server.resp.logging;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.jboss.logging.BasicLogger;
import java.nio.CharBuffer;
import java.lang.Throwable;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-10-04T11:00:53-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String authenticationWithoutAuthenticator$str() {
        return "ISPN012002: Cannot enable authentication without an authenticator.";
    }
    @Override
    public final CacheConfigurationException authenticationWithoutAuthenticator() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), authenticationWithoutAuthenticator$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void unexpectedException(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unexpectedException$str());
    }
    protected String unexpectedException$str() {
        return "ISPN012003: Received an unexpected exception.";
    }
    @Override
    public final void exceptionWhileRemovingListener(final Throwable cause, final CharBuffer channelName) {
        super.log.logf(FQCN, WARN, cause, exceptionWhileRemovingListener$str(), channelName);
    }
    protected String exceptionWhileRemovingListener$str() {
        return "ISPN012004: An error occurred when removing the listener for channel %s";
    }
    @Override
    public final void exceptionWhileRegisteringListener(final Throwable cause, final CharBuffer channelName) {
        super.log.logf(FQCN, WARN, cause, exceptionWhileRegisteringListener$str(), channelName);
    }
    protected String exceptionWhileRegisteringListener$str() {
        return "ISPN012005: There was an error adding listener for channel %s";
    }
    @Override
    public final void lmoveConsistencyMessage() {
        if (super.log.isEnabled(WARN) && lmoveConsistencyMessage_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, lmoveConsistencyMessage$str());
        }
    }
    protected String lmoveConsistencyMessage$str() {
        return "ISPN012006: LMOVE command can't guarantee atomicity and consistency when the source list and the destination list are different";
    }
    private static final AtomicBoolean lmoveConsistencyMessage_$Once = new AtomicBoolean(false);
    @Override
    public final void multiKeyOperationUseBatching() {
        if (super.log.isEnabled(WARN) && multiKeyOperationUseBatching_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, multiKeyOperationUseBatching$str());
        }
    }
    protected String multiKeyOperationUseBatching$str() {
        return "ISPN012007: Multi-key operations without batching have a relaxed isolation level. Consider enabling batching.";
    }
    private static final AtomicBoolean multiKeyOperationUseBatching_$Once = new AtomicBoolean(false);
    @Override
    public final void smoveConsistencyMessage() {
        if (super.log.isEnabled(WARN) && smoveConsistencyMessage_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, smoveConsistencyMessage$str());
        }
    }
    protected String smoveConsistencyMessage$str() {
        return "ISPN012008: SMOVE command can't guarantee atomicity and consistency when the source list and the destination set are different";
    }
    private static final AtomicBoolean smoveConsistencyMessage_$Once = new AtomicBoolean(false);
    @Override
    public final void msetnxConsistencyMessage() {
        if (super.log.isEnabled(WARN) && msetnxConsistencyMessage_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, msetnxConsistencyMessage$str());
        }
    }
    protected String msetnxConsistencyMessage$str() {
        return "ISPN012009: MSETNX command can't guarantee atomicity and consistency against concurrent set";
    }
    private static final AtomicBoolean msetnxConsistencyMessage_$Once = new AtomicBoolean(false);
}
