/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset.internal;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.sortedset.ZSetCommonUtils;
import org.infinispan.server.resp.serialization.Resp3Response;

public abstract class ZREMRANGE
extends RespCommand
implements Resp3Command {
    private final Type type;

    protected ZREMRANGE(int arity, Type type) {
        super(arity, 1, 1, 1);
        this.type = type;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        CompletionStage removeAllCall;
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache = handler.getSortedSeMultimap();
        int pos = 0;
        byte[] name = arguments.get(pos++);
        byte[] start = arguments.get(pos++);
        byte[] stop = arguments.get(pos++);
        if (this.type == Type.SCORE) {
            ZSetCommonUtils.Score startScore = ZSetCommonUtils.parseScore(start);
            ZSetCommonUtils.Score stopScore = ZSetCommonUtils.parseScore(stop);
            if (startScore == null || stopScore == null) {
                RespErrorUtil.minOrMaxNotAValidFloat(handler.allocator());
                return handler.myStage();
            }
            removeAllCall = sortedSetCache.removeAll((Object)name, startScore.value, startScore.include, stopScore.value, stopScore.include);
        } else if (this.type == Type.LEX) {
            ZSetCommonUtils.Lex startLex = ZSetCommonUtils.parseLex(start);
            ZSetCommonUtils.Lex stopLex = ZSetCommonUtils.parseLex(stop);
            if (startLex == null || stopLex == null) {
                RespErrorUtil.customError("min or max not valid string range item", handler.allocator());
                return handler.myStage();
            }
            removeAllCall = sortedSetCache.removeAll((Object)name, (Object)startLex.value, startLex.include, (Object)stopLex.value, stopLex.include);
        } else {
            long to;
            long from;
            try {
                from = ArgumentUtils.toLong(start);
                to = ArgumentUtils.toLong(stop);
            }
            catch (NumberFormatException ex) {
                RespErrorUtil.valueNotInteger(handler.allocator());
                return handler.myStage();
            }
            removeAllCall = sortedSetCache.removeAll((Object)name, Long.valueOf(from), Long.valueOf(to));
        }
        return handler.stageToReturn(removeAllCall, ctx, Resp3Response.INTEGER);
    }

    protected static enum Type {
        RANK,
        SCORE,
        LEX;

    }
}

