/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.response;

import java.util.function.BiConsumer;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Response;

public class SetResponse {
    public static final BiConsumer<SetResponse, ByteBufPool> SERIALIZER = (res, alloc) -> Resp3Response.write(res, alloc, SetResponseSerializer.INSTANCE);
    private final byte[] value;
    private final boolean returnValue;
    private final boolean success;

    public SetResponse(byte[] value, boolean returnValue) {
        this(value, returnValue, true);
    }

    public SetResponse(byte[] value, boolean returnValue, boolean success) {
        this.value = value;
        this.returnValue = returnValue;
        this.success = success;
    }

    public byte[] value() {
        return this.value;
    }

    public boolean isReturnValue() {
        return this.returnValue;
    }

    public boolean isSuccess() {
        return this.success;
    }

    private static final class SetResponseSerializer
    implements JavaObjectSerializer<SetResponse> {
        private static final SetResponseSerializer INSTANCE = new SetResponseSerializer();

        private SetResponseSerializer() {
        }

        @Override
        public void accept(SetResponse res, ByteBufPool alloc) {
            if (res.isReturnValue()) {
                Resp3Response.string(res.value(), alloc);
                return;
            }
            if (res.isSuccess()) {
                Resp3Response.ok(alloc);
                return;
            }
            Resp3Response.nulls(alloc);
        }
    }
}

