/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.meta;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ClientMetadata {
    private static final AtomicLongFieldUpdater<ClientMetadata> CONNECTED = AtomicLongFieldUpdater.newUpdater(ClientMetadata.class, "connectedClients");
    private static final AtomicLongFieldUpdater<ClientMetadata> BLOCKED = AtomicLongFieldUpdater.newUpdater(ClientMetadata.class, "blockedClients");
    private static final AtomicLongFieldUpdater<ClientMetadata> PUB_SUB = AtomicLongFieldUpdater.newUpdater(ClientMetadata.class, "pubSubClients");
    private static final AtomicLongFieldUpdater<ClientMetadata> WATCH = AtomicLongFieldUpdater.newUpdater(ClientMetadata.class, "watchingClients");
    private static final AtomicLongFieldUpdater<ClientMetadata> KEYS_BLOCKED = AtomicLongFieldUpdater.newUpdater(ClientMetadata.class, "blockedKeys");
    private static final AtomicLongFieldUpdater<ClientMetadata> KEYS_WATCH = AtomicLongFieldUpdater.newUpdater(ClientMetadata.class, "watchedKeys");
    private volatile long connectedClients = 0L;
    private volatile long blockedClients = 0L;
    private volatile long pubSubClients = 0L;
    private volatile long watchingClients = 0L;
    private volatile long blockedKeys = 0L;
    private volatile long watchedKeys = 0L;

    public void incrementConnectedClients() {
        CONNECTED.incrementAndGet(this);
    }

    public void decrementConnectedClients() {
        CONNECTED.decrementAndGet(this);
    }

    public void incrementBlockedClients() {
        BLOCKED.incrementAndGet(this);
    }

    public void decrementBlockedClients() {
        BLOCKED.decrementAndGet(this);
    }

    public void incrementPubSubClients() {
        PUB_SUB.incrementAndGet(this);
    }

    public void decrementPubSubClients() {
        PUB_SUB.decrementAndGet(this);
    }

    public void incrementWatchingClients() {
        WATCH.incrementAndGet(this);
    }

    public void decrementWatchingClients() {
        WATCH.decrementAndGet(this);
    }

    public long getConnectedClients() {
        return CONNECTED.get(this);
    }

    public long getBlockedClients() {
        return BLOCKED.get(this);
    }

    public long getPubSubClients() {
        return PUB_SUB.get(this);
    }

    public long getWatchingClients() {
        return WATCH.get(this);
    }

    public void recordBlockedKeys(long value) {
        KEYS_BLOCKED.addAndGet(this, value);
    }

    public void recordWatchedKeys(long value) {
        KEYS_WATCH.addAndGet(this, value);
    }

    public long getBlockedKeys() {
        return KEYS_BLOCKED.get(this);
    }

    public long getWatchedKeys() {
        return KEYS_WATCH.get(this);
    }
}

