/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.tx;

import jakarta.transaction.Transaction;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.commons.tx.DefaultResourceConverter;
import org.infinispan.commons.tx.TransactionResourceConverter;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;

final class TransactionDecorator {
    private TransactionDecorator() {
    }

    static TransactionResume beginTransaction(Resp3Handler handler, AdvancedCache<byte[], byte[]> cache) {
        EmbeddedTransaction tx = new EmbeddedTransaction((EmbeddedBaseTransactionManager)EmbeddedTransactionManager.getInstance());
        TransactionTable table = TransactionDecorator.acquireTransactionTable(cache);
        LocalTransaction localTx = table.getOrCreateLocalTransaction((Transaction)tx, false);
        LocalTxInvocationContext ic = new LocalTxInvocationContext(localTx);
        table.enlistClientTransaction((Transaction)tx, localTx);
        handler.setCache(TransactionDecorator.injectExecCache(cache, (InvocationContext)ic));
        return new TransactionResume(handler, cache, tx);
    }

    static CompletionStage<Void> completeTransaction(TransactionResume resume, boolean success) {
        resume.handler.setCache(resume.cache);
        return resume.tx.runCommitAsync(!success, (TransactionResourceConverter)DefaultResourceConverter.INSTANCE);
    }

    private static TransactionTable acquireTransactionTable(AdvancedCache<?, ?> cache) {
        return (TransactionTable)ComponentRegistry.componentOf(cache, TransactionTable.class);
    }

    private static AdvancedCache<byte[], byte[]> injectExecCache(Cache<byte[], byte[]> cache, InvocationContext ctx) {
        if (cache instanceof CacheImpl) {
            CacheImpl ci = (CacheImpl)cache;
            return new RespExecDecoratedCache(ctx, (CacheImpl<byte[], byte[]>)ci, 0L);
        }
        if (cache instanceof AbstractDelegatingAdvancedCache) {
            AbstractDelegatingAdvancedCache adac = (AbstractDelegatingAdvancedCache)cache;
            AdvancedCache<byte[], byte[]> delegate = TransactionDecorator.injectExecCache((Cache<byte[], byte[]>)adac.getDelegate(), ctx);
            return adac.rewrap(delegate);
        }
        throw new IllegalStateException("Simple cache not found for: " + String.valueOf(cache.getClass()));
    }

    static final class TransactionResume {
        private final Resp3Handler handler;
        private final AdvancedCache<byte[], byte[]> cache;
        private final EmbeddedTransaction tx;

        TransactionResume(Resp3Handler handler, AdvancedCache<byte[], byte[]> cache, EmbeddedTransaction tx) {
            this.handler = handler;
            this.cache = cache;
            this.tx = tx;
        }
    }

    private static class RespExecDecoratedCache
    extends DecoratedCache<byte[], byte[]> {
        private final InvocationContext ctx;

        private RespExecDecoratedCache(InvocationContext ctx, CacheImpl<byte[], byte[]> delegate, long flags) {
            super(delegate, flags);
            this.ctx = ctx;
        }

        private RespExecDecoratedCache(InvocationContext ctx, CacheImpl<byte[], byte[]> delegate, Object lockOwner, long flags) {
            super(delegate, lockOwner, flags);
            this.ctx = ctx;
        }

        protected DecoratedCache<byte[], byte[]> newInstance(CacheImpl<byte[], byte[]> impl, Object lockOwner, long newFlags) {
            return new RespExecDecoratedCache(this.ctx, impl, lockOwner, newFlags);
        }

        protected InvocationContext readContext(int size) {
            return this.ctx;
        }

        protected InvocationContext writeContext(int size) {
            return this.ctx;
        }

        public boolean bypassInvocationContextFactory() {
            return true;
        }
    }
}

