/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.logging;

import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.server.resp.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean lmoveConsistencyMessage_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean smoveConsistencyMessage_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean msetnxConsistencyMessage_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean enableTransactionForMultiExec_$Once = new AtomicBoolean(false);

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String authenticationWithoutAuthenticator$str() {
        return "ISPN012002: Cannot enable authentication without an authenticator.";
    }

    @Override
    public final CacheConfigurationException authenticationWithoutAuthenticator() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authenticationWithoutAuthenticator$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void unexpectedException(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.unexpectedException$str(), new Object[0]);
    }

    protected String unexpectedException$str() {
        return "ISPN012003: Received an unexpected exception.";
    }

    @Override
    public final void exceptionWhileRemovingListener(Throwable cause, CharBuffer channelName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.exceptionWhileRemovingListener$str(), (Object)channelName);
    }

    protected String exceptionWhileRemovingListener$str() {
        return "ISPN012004: An error occurred when removing the listener for channel %s";
    }

    @Override
    public final void exceptionWhileRegisteringListener(Throwable cause, CharBuffer channelName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.exceptionWhileRegisteringListener$str(), (Object)channelName);
    }

    protected String exceptionWhileRegisteringListener$str() {
        return "ISPN012005: There was an error adding listener for channel %s";
    }

    @Override
    public final void lmoveConsistencyMessage() {
        if (this.log.isEnabled(Logger.Level.WARN) && lmoveConsistencyMessage_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.lmoveConsistencyMessage$str(), new Object[0]);
        }
    }

    protected String lmoveConsistencyMessage$str() {
        return "ISPN012006: LMOVE command can't guarantee atomicity and consistency when the source list and the destination list are different";
    }

    @Override
    public final void smoveConsistencyMessage() {
        if (this.log.isEnabled(Logger.Level.WARN) && smoveConsistencyMessage_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.smoveConsistencyMessage$str(), new Object[0]);
        }
    }

    protected String smoveConsistencyMessage$str() {
        return "ISPN012008: SMOVE command can't guarantee atomicity and consistency when the source list and the destination set are different";
    }

    @Override
    public final void msetnxConsistencyMessage() {
        if (this.log.isEnabled(Logger.Level.WARN) && msetnxConsistencyMessage_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.msetnxConsistencyMessage$str(), new Object[0]);
        }
    }

    protected String msetnxConsistencyMessage$str() {
        return "ISPN012009: MSETNX command can't guarantee atomicity and consistency against concurrent set";
    }

    @Override
    public final void utilizePessimisticLocking(String mode) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.utilizePessimisticLocking$str(), (Object)mode);
    }

    protected String utilizePessimisticLocking$str() {
        return "ISPN013010: PESSIMISTIC locking is preferred instead of '%s'";
    }

    @Override
    public final void enableTransactionForMultiExec() {
        if (this.log.isEnabled(Logger.Level.WARN) && enableTransactionForMultiExec_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.enableTransactionForMultiExec$str(), new Object[0]);
        }
    }

    protected String enableTransactionForMultiExec$str() {
        return "ISPN013011: Multi-Exec operations without transactions have a relaxed isolation level. Consider enabling transaction.";
    }
}

